<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductSearchQueryPerformanceReportFilter StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ProductSearchQueryPerformanceReportFilter
 * @subpackage Structs
 */
class ProductSearchQueryPerformanceReportFilter extends AbstractStructBase
{
    /**
     * The AccountStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AccountStatus;
    /**
     * The AdGroupStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AdGroupStatus;
    /**
     * The AdStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AdStatus;
    /**
     * The AdType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AdType;
    /**
     * The CampaignStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $CampaignStatus;
    /**
     * The ExcludeZeroClicks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ExcludeZeroClicks;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $Language;
    /**
     * The SearchQueries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $SearchQueries;
    /**
     * Constructor method for ProductSearchQueryPerformanceReportFilter
     * @uses ProductSearchQueryPerformanceReportFilter::setAccountStatus()
     * @uses ProductSearchQueryPerformanceReportFilter::setAdGroupStatus()
     * @uses ProductSearchQueryPerformanceReportFilter::setAdStatus()
     * @uses ProductSearchQueryPerformanceReportFilter::setAdType()
     * @uses ProductSearchQueryPerformanceReportFilter::setCampaignStatus()
     * @uses ProductSearchQueryPerformanceReportFilter::setExcludeZeroClicks()
     * @uses ProductSearchQueryPerformanceReportFilter::setLanguage()
     * @uses ProductSearchQueryPerformanceReportFilter::setSearchQueries()
     * @param string[] $accountStatus
     * @param string[] $adGroupStatus
     * @param string[] $adStatus
     * @param string[] $adType
     * @param string[] $campaignStatus
     * @param bool $excludeZeroClicks
     * @param string[] $language
     * @param \ArrayType\ArrayOfstring $searchQueries
     */
    public function __construct(array $accountStatus = array(), array $adGroupStatus = array(), array $adStatus = array(), array $adType = array(), array $campaignStatus = array(), $excludeZeroClicks = null, array $language = array(), \ArrayType\ArrayOfstring $searchQueries = null)
    {
        $this
            ->setAccountStatus($accountStatus)
            ->setAdGroupStatus($adGroupStatus)
            ->setAdStatus($adStatus)
            ->setAdType($adType)
            ->setCampaignStatus($campaignStatus)
            ->setExcludeZeroClicks($excludeZeroClicks)
            ->setLanguage($language)
            ->setSearchQueries($searchQueries);
    }
    /**
     * Get AccountStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAccountStatus()
    {
        return isset($this->AccountStatus) ? $this->AccountStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountStatusForArrayConstraintsFromSetAccountStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productSearchQueryPerformanceReportFilterAccountStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AccountStatusReportFilter::valueIsValid($productSearchQueryPerformanceReportFilterAccountStatusItem)) {
                $invalidValues[] = is_object($productSearchQueryPerformanceReportFilterAccountStatusItem) ? get_class($productSearchQueryPerformanceReportFilterAccountStatusItem) : sprintf('%s(%s)', gettype($productSearchQueryPerformanceReportFilterAccountStatusItem), var_export($productSearchQueryPerformanceReportFilterAccountStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AccountStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccountStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AccountStatusReportFilter::valueIsValid()
     * @uses \EnumType\AccountStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accountStatus
     * @return \StructType\ProductSearchQueryPerformanceReportFilter
     */
    public function setAccountStatus(array $accountStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($accountStatusArrayErrorMessage = self::validateAccountStatusForArrayConstraintsFromSetAccountStatus($accountStatus))) {
            throw new \InvalidArgumentException($accountStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($accountStatus) || (is_array($accountStatus) && empty($accountStatus))) {
            unset($this->AccountStatus);
        } else {
            $this->AccountStatus = is_array($accountStatus) ? implode(' ', $accountStatus) : null;
        }
        return $this;
    }
    /**
     * Get AdGroupStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdGroupStatus()
    {
        return isset($this->AdGroupStatus) ? $this->AdGroupStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdGroupStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdGroupStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdGroupStatusForArrayConstraintsFromSetAdGroupStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productSearchQueryPerformanceReportFilterAdGroupStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdGroupStatusReportFilter::valueIsValid($productSearchQueryPerformanceReportFilterAdGroupStatusItem)) {
                $invalidValues[] = is_object($productSearchQueryPerformanceReportFilterAdGroupStatusItem) ? get_class($productSearchQueryPerformanceReportFilterAdGroupStatusItem) : sprintf('%s(%s)', gettype($productSearchQueryPerformanceReportFilterAdGroupStatusItem), var_export($productSearchQueryPerformanceReportFilterAdGroupStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdGroupStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdGroupStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdGroupStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdGroupStatusReportFilter::valueIsValid()
     * @uses \EnumType\AdGroupStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $adGroupStatus
     * @return \StructType\ProductSearchQueryPerformanceReportFilter
     */
    public function setAdGroupStatus(array $adGroupStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($adGroupStatusArrayErrorMessage = self::validateAdGroupStatusForArrayConstraintsFromSetAdGroupStatus($adGroupStatus))) {
            throw new \InvalidArgumentException($adGroupStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($adGroupStatus) || (is_array($adGroupStatus) && empty($adGroupStatus))) {
            unset($this->AdGroupStatus);
        } else {
            $this->AdGroupStatus = is_array($adGroupStatus) ? implode(' ', $adGroupStatus) : null;
        }
        return $this;
    }
    /**
     * Get AdStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdStatus()
    {
        return isset($this->AdStatus) ? $this->AdStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdStatusForArrayConstraintsFromSetAdStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productSearchQueryPerformanceReportFilterAdStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdStatusReportFilter::valueIsValid($productSearchQueryPerformanceReportFilterAdStatusItem)) {
                $invalidValues[] = is_object($productSearchQueryPerformanceReportFilterAdStatusItem) ? get_class($productSearchQueryPerformanceReportFilterAdStatusItem) : sprintf('%s(%s)', gettype($productSearchQueryPerformanceReportFilterAdStatusItem), var_export($productSearchQueryPerformanceReportFilterAdStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdStatusReportFilter::valueIsValid()
     * @uses \EnumType\AdStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $adStatus
     * @return \StructType\ProductSearchQueryPerformanceReportFilter
     */
    public function setAdStatus(array $adStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($adStatusArrayErrorMessage = self::validateAdStatusForArrayConstraintsFromSetAdStatus($adStatus))) {
            throw new \InvalidArgumentException($adStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($adStatus) || (is_array($adStatus) && empty($adStatus))) {
            unset($this->AdStatus);
        } else {
            $this->AdStatus = is_array($adStatus) ? implode(' ', $adStatus) : null;
        }
        return $this;
    }
    /**
     * Get AdType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdType()
    {
        return isset($this->AdType) ? $this->AdType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdTypeForArrayConstraintsFromSetAdType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productSearchQueryPerformanceReportFilterAdTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdTypeReportFilter::valueIsValid($productSearchQueryPerformanceReportFilterAdTypeItem)) {
                $invalidValues[] = is_object($productSearchQueryPerformanceReportFilterAdTypeItem) ? get_class($productSearchQueryPerformanceReportFilterAdTypeItem) : sprintf('%s(%s)', gettype($productSearchQueryPerformanceReportFilterAdTypeItem), var_export($productSearchQueryPerformanceReportFilterAdTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdTypeReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdTypeReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdTypeReportFilter::valueIsValid()
     * @uses \EnumType\AdTypeReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $adType
     * @return \StructType\ProductSearchQueryPerformanceReportFilter
     */
    public function setAdType(array $adType = array())
    {
        // validation for constraint: list
        if ('' !== ($adTypeArrayErrorMessage = self::validateAdTypeForArrayConstraintsFromSetAdType($adType))) {
            throw new \InvalidArgumentException($adTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($adType) || (is_array($adType) && empty($adType))) {
            unset($this->AdType);
        } else {
            $this->AdType = is_array($adType) ? implode(' ', $adType) : null;
        }
        return $this;
    }
    /**
     * Get CampaignStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getCampaignStatus()
    {
        return isset($this->CampaignStatus) ? $this->CampaignStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCampaignStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCampaignStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCampaignStatusForArrayConstraintsFromSetCampaignStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productSearchQueryPerformanceReportFilterCampaignStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\CampaignStatusReportFilter::valueIsValid($productSearchQueryPerformanceReportFilterCampaignStatusItem)) {
                $invalidValues[] = is_object($productSearchQueryPerformanceReportFilterCampaignStatusItem) ? get_class($productSearchQueryPerformanceReportFilterCampaignStatusItem) : sprintf('%s(%s)', gettype($productSearchQueryPerformanceReportFilterCampaignStatusItem), var_export($productSearchQueryPerformanceReportFilterCampaignStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CampaignStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\CampaignStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CampaignStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\CampaignStatusReportFilter::valueIsValid()
     * @uses \EnumType\CampaignStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $campaignStatus
     * @return \StructType\ProductSearchQueryPerformanceReportFilter
     */
    public function setCampaignStatus(array $campaignStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($campaignStatusArrayErrorMessage = self::validateCampaignStatusForArrayConstraintsFromSetCampaignStatus($campaignStatus))) {
            throw new \InvalidArgumentException($campaignStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($campaignStatus) || (is_array($campaignStatus) && empty($campaignStatus))) {
            unset($this->CampaignStatus);
        } else {
            $this->CampaignStatus = is_array($campaignStatus) ? implode(' ', $campaignStatus) : null;
        }
        return $this;
    }
    /**
     * Get ExcludeZeroClicks value
     * @return bool|null
     */
    public function getExcludeZeroClicks()
    {
        return $this->ExcludeZeroClicks;
    }
    /**
     * Set ExcludeZeroClicks value
     * @param bool $excludeZeroClicks
     * @return \StructType\ProductSearchQueryPerformanceReportFilter
     */
    public function setExcludeZeroClicks($excludeZeroClicks = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeZeroClicks) && !is_bool($excludeZeroClicks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeZeroClicks, true), gettype($excludeZeroClicks)), __LINE__);
        }
        $this->ExcludeZeroClicks = $excludeZeroClicks;
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLanguage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLanguage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLanguageForArrayConstraintsFromSetLanguage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productSearchQueryPerformanceReportFilterLanguageItem) {
            // validation for constraint: enumeration
            if (!\EnumType\LanguageReportFilter::valueIsValid($productSearchQueryPerformanceReportFilterLanguageItem)) {
                $invalidValues[] = is_object($productSearchQueryPerformanceReportFilterLanguageItem) ? get_class($productSearchQueryPerformanceReportFilterLanguageItem) : sprintf('%s(%s)', gettype($productSearchQueryPerformanceReportFilterLanguageItem), var_export($productSearchQueryPerformanceReportFilterLanguageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LanguageReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\LanguageReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\LanguageReportFilter::valueIsValid()
     * @uses \EnumType\LanguageReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $language
     * @return \StructType\ProductSearchQueryPerformanceReportFilter
     */
    public function setLanguage(array $language = array())
    {
        // validation for constraint: list
        if ('' !== ($languageArrayErrorMessage = self::validateLanguageForArrayConstraintsFromSetLanguage($language))) {
            throw new \InvalidArgumentException($languageArrayErrorMessage, __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = is_array($language) ? implode(' ', $language) : null;
        }
        return $this;
    }
    /**
     * Get SearchQueries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getSearchQueries()
    {
        return isset($this->SearchQueries) ? $this->SearchQueries : null;
    }
    /**
     * Set SearchQueries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $searchQueries
     * @return \StructType\ProductSearchQueryPerformanceReportFilter
     */
    public function setSearchQueries(\ArrayType\ArrayOfstring $searchQueries = null)
    {
        if (is_null($searchQueries) || (is_array($searchQueries) && empty($searchQueries))) {
            unset($this->SearchQueries);
        } else {
            $this->SearchQueries = $searchQueries;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductSearchQueryPerformanceReportFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
