<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductMatchCountReportRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ProductMatchCountReportRequest
 * @subpackage Structs
 */
class ProductMatchCountReportRequest extends ReportRequest
{
    /**
     * The Aggregation
     * @var string
     */
    public $Aggregation;
    /**
     * The Columns
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfProductMatchCountReportColumn
     */
    public $Columns;
    /**
     * The Scope
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\AccountThroughAdGroupReportScope
     */
    public $Scope;
    /**
     * The Time
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReportTime
     */
    public $Time;
    /**
     * Constructor method for ProductMatchCountReportRequest
     * @uses ProductMatchCountReportRequest::setAggregation()
     * @uses ProductMatchCountReportRequest::setColumns()
     * @uses ProductMatchCountReportRequest::setScope()
     * @uses ProductMatchCountReportRequest::setTime()
     * @param string $aggregation
     * @param \ArrayType\ArrayOfProductMatchCountReportColumn $columns
     * @param \StructType\AccountThroughAdGroupReportScope $scope
     * @param \StructType\ReportTime $time
     */
    public function __construct($aggregation = null, \ArrayType\ArrayOfProductMatchCountReportColumn $columns = null, \StructType\AccountThroughAdGroupReportScope $scope = null, \StructType\ReportTime $time = null)
    {
        $this
            ->setAggregation($aggregation)
            ->setColumns($columns)
            ->setScope($scope)
            ->setTime($time);
    }
    /**
     * Get Aggregation value
     * @return string|null
     */
    public function getAggregation()
    {
        return $this->Aggregation;
    }
    /**
     * Set Aggregation value
     * @uses \EnumType\ReportAggregation::valueIsValid()
     * @uses \EnumType\ReportAggregation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $aggregation
     * @return \StructType\ProductMatchCountReportRequest
     */
    public function setAggregation($aggregation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReportAggregation::valueIsValid($aggregation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ReportAggregation', is_array($aggregation) ? implode(', ', $aggregation) : var_export($aggregation, true), implode(', ', \EnumType\ReportAggregation::getValidValues())), __LINE__);
        }
        $this->Aggregation = $aggregation;
        return $this;
    }
    /**
     * Get Columns value
     * @return \ArrayType\ArrayOfProductMatchCountReportColumn|null
     */
    public function getColumns()
    {
        return $this->Columns;
    }
    /**
     * Set Columns value
     * @param \ArrayType\ArrayOfProductMatchCountReportColumn $columns
     * @return \StructType\ProductMatchCountReportRequest
     */
    public function setColumns(\ArrayType\ArrayOfProductMatchCountReportColumn $columns = null)
    {
        $this->Columns = $columns;
        return $this;
    }
    /**
     * Get Scope value
     * @return \StructType\AccountThroughAdGroupReportScope|null
     */
    public function getScope()
    {
        return $this->Scope;
    }
    /**
     * Set Scope value
     * @param \StructType\AccountThroughAdGroupReportScope $scope
     * @return \StructType\ProductMatchCountReportRequest
     */
    public function setScope(\StructType\AccountThroughAdGroupReportScope $scope = null)
    {
        $this->Scope = $scope;
        return $this;
    }
    /**
     * Get Time value
     * @return \StructType\ReportTime|null
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * Set Time value
     * @param \StructType\ReportTime $time
     * @return \StructType\ProductMatchCountReportRequest
     */
    public function setTime(\StructType\ReportTime $time = null)
    {
        $this->Time = $time;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductMatchCountReportRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
