<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KeywordPerformanceReportSort StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:KeywordPerformanceReportSort
 * @subpackage Structs
 */
class KeywordPerformanceReportSort extends AbstractStructBase
{
    /**
     * The SortColumn
     * @var string
     */
    public $SortColumn;
    /**
     * The SortOrder
     * @var string
     */
    public $SortOrder;
    /**
     * Constructor method for KeywordPerformanceReportSort
     * @uses KeywordPerformanceReportSort::setSortColumn()
     * @uses KeywordPerformanceReportSort::setSortOrder()
     * @param string $sortColumn
     * @param string $sortOrder
     */
    public function __construct($sortColumn = null, $sortOrder = null)
    {
        $this
            ->setSortColumn($sortColumn)
            ->setSortOrder($sortOrder);
    }
    /**
     * Get SortColumn value
     * @return string|null
     */
    public function getSortColumn()
    {
        return $this->SortColumn;
    }
    /**
     * Set SortColumn value
     * @uses \EnumType\KeywordPerformanceReportColumn::valueIsValid()
     * @uses \EnumType\KeywordPerformanceReportColumn::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortColumn
     * @return \StructType\KeywordPerformanceReportSort
     */
    public function setSortColumn($sortColumn = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KeywordPerformanceReportColumn::valueIsValid($sortColumn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KeywordPerformanceReportColumn', is_array($sortColumn) ? implode(', ', $sortColumn) : var_export($sortColumn, true), implode(', ', \EnumType\KeywordPerformanceReportColumn::getValidValues())), __LINE__);
        }
        $this->SortColumn = $sortColumn;
        return $this;
    }
    /**
     * Get SortOrder value
     * @return string|null
     */
    public function getSortOrder()
    {
        return $this->SortOrder;
    }
    /**
     * Set SortOrder value
     * @uses \EnumType\SortOrder::valueIsValid()
     * @uses \EnumType\SortOrder::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortOrder
     * @return \StructType\KeywordPerformanceReportSort
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SortOrder::valueIsValid($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SortOrder', is_array($sortOrder) ? implode(', ', $sortOrder) : var_export($sortOrder, true), implode(', ', \EnumType\SortOrder::getValidValues())), __LINE__);
        }
        $this->SortOrder = $sortOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KeywordPerformanceReportSort
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
