<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeographicPerformanceReportRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GeographicPerformanceReportRequest
 * @subpackage Structs
 */
class GeographicPerformanceReportRequest extends ReportRequest
{
    /**
     * The Aggregation
     * @var string
     */
    public $Aggregation;
    /**
     * The Columns
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfGeographicPerformanceReportColumn
     */
    public $Columns;
    /**
     * The Filter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GeographicPerformanceReportFilter
     */
    public $Filter;
    /**
     * The Scope
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\AccountThroughAdGroupReportScope
     */
    public $Scope;
    /**
     * The Time
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReportTime
     */
    public $Time;
    /**
     * Constructor method for GeographicPerformanceReportRequest
     * @uses GeographicPerformanceReportRequest::setAggregation()
     * @uses GeographicPerformanceReportRequest::setColumns()
     * @uses GeographicPerformanceReportRequest::setFilter()
     * @uses GeographicPerformanceReportRequest::setScope()
     * @uses GeographicPerformanceReportRequest::setTime()
     * @param string $aggregation
     * @param \ArrayType\ArrayOfGeographicPerformanceReportColumn $columns
     * @param \StructType\GeographicPerformanceReportFilter $filter
     * @param \StructType\AccountThroughAdGroupReportScope $scope
     * @param \StructType\ReportTime $time
     */
    public function __construct($aggregation = null, \ArrayType\ArrayOfGeographicPerformanceReportColumn $columns = null, \StructType\GeographicPerformanceReportFilter $filter = null, \StructType\AccountThroughAdGroupReportScope $scope = null, \StructType\ReportTime $time = null)
    {
        $this
            ->setAggregation($aggregation)
            ->setColumns($columns)
            ->setFilter($filter)
            ->setScope($scope)
            ->setTime($time);
    }
    /**
     * Get Aggregation value
     * @return string|null
     */
    public function getAggregation()
    {
        return $this->Aggregation;
    }
    /**
     * Set Aggregation value
     * @uses \EnumType\ReportAggregation::valueIsValid()
     * @uses \EnumType\ReportAggregation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $aggregation
     * @return \StructType\GeographicPerformanceReportRequest
     */
    public function setAggregation($aggregation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReportAggregation::valueIsValid($aggregation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ReportAggregation', is_array($aggregation) ? implode(', ', $aggregation) : var_export($aggregation, true), implode(', ', \EnumType\ReportAggregation::getValidValues())), __LINE__);
        }
        $this->Aggregation = $aggregation;
        return $this;
    }
    /**
     * Get Columns value
     * @return \ArrayType\ArrayOfGeographicPerformanceReportColumn|null
     */
    public function getColumns()
    {
        return $this->Columns;
    }
    /**
     * Set Columns value
     * @param \ArrayType\ArrayOfGeographicPerformanceReportColumn $columns
     * @return \StructType\GeographicPerformanceReportRequest
     */
    public function setColumns(\ArrayType\ArrayOfGeographicPerformanceReportColumn $columns = null)
    {
        $this->Columns = $columns;
        return $this;
    }
    /**
     * Get Filter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GeographicPerformanceReportFilter|null
     */
    public function getFilter()
    {
        return isset($this->Filter) ? $this->Filter : null;
    }
    /**
     * Set Filter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\GeographicPerformanceReportFilter $filter
     * @return \StructType\GeographicPerformanceReportRequest
     */
    public function setFilter(\StructType\GeographicPerformanceReportFilter $filter = null)
    {
        if (is_null($filter) || (is_array($filter) && empty($filter))) {
            unset($this->Filter);
        } else {
            $this->Filter = $filter;
        }
        return $this;
    }
    /**
     * Get Scope value
     * @return \StructType\AccountThroughAdGroupReportScope|null
     */
    public function getScope()
    {
        return $this->Scope;
    }
    /**
     * Set Scope value
     * @param \StructType\AccountThroughAdGroupReportScope $scope
     * @return \StructType\GeographicPerformanceReportRequest
     */
    public function setScope(\StructType\AccountThroughAdGroupReportScope $scope = null)
    {
        $this->Scope = $scope;
        return $this;
    }
    /**
     * Get Time value
     * @return \StructType\ReportTime|null
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * Set Time value
     * @param \StructType\ReportTime $time
     * @return \StructType\GeographicPerformanceReportRequest
     */
    public function setTime(\StructType\ReportTime $time = null)
    {
        $this->Time = $time;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GeographicPerformanceReportRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
