<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConversionPerformanceReportFilter StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ConversionPerformanceReportFilter
 * @subpackage Structs
 */
class ConversionPerformanceReportFilter extends AbstractStructBase
{
    /**
     * The AccountStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AccountStatus;
    /**
     * The AdDistribution
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AdDistribution;
    /**
     * The AdGroupStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AdGroupStatus;
    /**
     * The CampaignStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $CampaignStatus;
    /**
     * The DeviceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $DeviceType;
    /**
     * The KeywordStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $KeywordStatus;
    /**
     * The Keywords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $Keywords;
    /**
     * Constructor method for ConversionPerformanceReportFilter
     * @uses ConversionPerformanceReportFilter::setAccountStatus()
     * @uses ConversionPerformanceReportFilter::setAdDistribution()
     * @uses ConversionPerformanceReportFilter::setAdGroupStatus()
     * @uses ConversionPerformanceReportFilter::setCampaignStatus()
     * @uses ConversionPerformanceReportFilter::setDeviceType()
     * @uses ConversionPerformanceReportFilter::setKeywordStatus()
     * @uses ConversionPerformanceReportFilter::setKeywords()
     * @param string[] $accountStatus
     * @param string[] $adDistribution
     * @param string[] $adGroupStatus
     * @param string[] $campaignStatus
     * @param string[] $deviceType
     * @param string[] $keywordStatus
     * @param \ArrayType\ArrayOfstring $keywords
     */
    public function __construct(array $accountStatus = array(), array $adDistribution = array(), array $adGroupStatus = array(), array $campaignStatus = array(), array $deviceType = array(), array $keywordStatus = array(), \ArrayType\ArrayOfstring $keywords = null)
    {
        $this
            ->setAccountStatus($accountStatus)
            ->setAdDistribution($adDistribution)
            ->setAdGroupStatus($adGroupStatus)
            ->setCampaignStatus($campaignStatus)
            ->setDeviceType($deviceType)
            ->setKeywordStatus($keywordStatus)
            ->setKeywords($keywords);
    }
    /**
     * Get AccountStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAccountStatus()
    {
        return isset($this->AccountStatus) ? $this->AccountStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountStatusForArrayConstraintsFromSetAccountStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $conversionPerformanceReportFilterAccountStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AccountStatusReportFilter::valueIsValid($conversionPerformanceReportFilterAccountStatusItem)) {
                $invalidValues[] = is_object($conversionPerformanceReportFilterAccountStatusItem) ? get_class($conversionPerformanceReportFilterAccountStatusItem) : sprintf('%s(%s)', gettype($conversionPerformanceReportFilterAccountStatusItem), var_export($conversionPerformanceReportFilterAccountStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AccountStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccountStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AccountStatusReportFilter::valueIsValid()
     * @uses \EnumType\AccountStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accountStatus
     * @return \StructType\ConversionPerformanceReportFilter
     */
    public function setAccountStatus(array $accountStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($accountStatusArrayErrorMessage = self::validateAccountStatusForArrayConstraintsFromSetAccountStatus($accountStatus))) {
            throw new \InvalidArgumentException($accountStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($accountStatus) || (is_array($accountStatus) && empty($accountStatus))) {
            unset($this->AccountStatus);
        } else {
            $this->AccountStatus = is_array($accountStatus) ? implode(' ', $accountStatus) : null;
        }
        return $this;
    }
    /**
     * Get AdDistribution value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdDistribution()
    {
        return isset($this->AdDistribution) ? $this->AdDistribution : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdDistribution method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdDistribution method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdDistributionForArrayConstraintsFromSetAdDistribution(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $conversionPerformanceReportFilterAdDistributionItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdDistributionReportFilter::valueIsValid($conversionPerformanceReportFilterAdDistributionItem)) {
                $invalidValues[] = is_object($conversionPerformanceReportFilterAdDistributionItem) ? get_class($conversionPerformanceReportFilterAdDistributionItem) : sprintf('%s(%s)', gettype($conversionPerformanceReportFilterAdDistributionItem), var_export($conversionPerformanceReportFilterAdDistributionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdDistributionReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdDistributionReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdDistribution value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdDistributionReportFilter::valueIsValid()
     * @uses \EnumType\AdDistributionReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $adDistribution
     * @return \StructType\ConversionPerformanceReportFilter
     */
    public function setAdDistribution(array $adDistribution = array())
    {
        // validation for constraint: list
        if ('' !== ($adDistributionArrayErrorMessage = self::validateAdDistributionForArrayConstraintsFromSetAdDistribution($adDistribution))) {
            throw new \InvalidArgumentException($adDistributionArrayErrorMessage, __LINE__);
        }
        if (is_null($adDistribution) || (is_array($adDistribution) && empty($adDistribution))) {
            unset($this->AdDistribution);
        } else {
            $this->AdDistribution = is_array($adDistribution) ? implode(' ', $adDistribution) : null;
        }
        return $this;
    }
    /**
     * Get AdGroupStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdGroupStatus()
    {
        return isset($this->AdGroupStatus) ? $this->AdGroupStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdGroupStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdGroupStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdGroupStatusForArrayConstraintsFromSetAdGroupStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $conversionPerformanceReportFilterAdGroupStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdGroupStatusReportFilter::valueIsValid($conversionPerformanceReportFilterAdGroupStatusItem)) {
                $invalidValues[] = is_object($conversionPerformanceReportFilterAdGroupStatusItem) ? get_class($conversionPerformanceReportFilterAdGroupStatusItem) : sprintf('%s(%s)', gettype($conversionPerformanceReportFilterAdGroupStatusItem), var_export($conversionPerformanceReportFilterAdGroupStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdGroupStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdGroupStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdGroupStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdGroupStatusReportFilter::valueIsValid()
     * @uses \EnumType\AdGroupStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $adGroupStatus
     * @return \StructType\ConversionPerformanceReportFilter
     */
    public function setAdGroupStatus(array $adGroupStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($adGroupStatusArrayErrorMessage = self::validateAdGroupStatusForArrayConstraintsFromSetAdGroupStatus($adGroupStatus))) {
            throw new \InvalidArgumentException($adGroupStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($adGroupStatus) || (is_array($adGroupStatus) && empty($adGroupStatus))) {
            unset($this->AdGroupStatus);
        } else {
            $this->AdGroupStatus = is_array($adGroupStatus) ? implode(' ', $adGroupStatus) : null;
        }
        return $this;
    }
    /**
     * Get CampaignStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getCampaignStatus()
    {
        return isset($this->CampaignStatus) ? $this->CampaignStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCampaignStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCampaignStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCampaignStatusForArrayConstraintsFromSetCampaignStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $conversionPerformanceReportFilterCampaignStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\CampaignStatusReportFilter::valueIsValid($conversionPerformanceReportFilterCampaignStatusItem)) {
                $invalidValues[] = is_object($conversionPerformanceReportFilterCampaignStatusItem) ? get_class($conversionPerformanceReportFilterCampaignStatusItem) : sprintf('%s(%s)', gettype($conversionPerformanceReportFilterCampaignStatusItem), var_export($conversionPerformanceReportFilterCampaignStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CampaignStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\CampaignStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CampaignStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\CampaignStatusReportFilter::valueIsValid()
     * @uses \EnumType\CampaignStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $campaignStatus
     * @return \StructType\ConversionPerformanceReportFilter
     */
    public function setCampaignStatus(array $campaignStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($campaignStatusArrayErrorMessage = self::validateCampaignStatusForArrayConstraintsFromSetCampaignStatus($campaignStatus))) {
            throw new \InvalidArgumentException($campaignStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($campaignStatus) || (is_array($campaignStatus) && empty($campaignStatus))) {
            unset($this->CampaignStatus);
        } else {
            $this->CampaignStatus = is_array($campaignStatus) ? implode(' ', $campaignStatus) : null;
        }
        return $this;
    }
    /**
     * Get DeviceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getDeviceType()
    {
        return isset($this->DeviceType) ? $this->DeviceType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDeviceType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeviceType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeviceTypeForArrayConstraintsFromSetDeviceType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $conversionPerformanceReportFilterDeviceTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\DeviceTypeReportFilter::valueIsValid($conversionPerformanceReportFilterDeviceTypeItem)) {
                $invalidValues[] = is_object($conversionPerformanceReportFilterDeviceTypeItem) ? get_class($conversionPerformanceReportFilterDeviceTypeItem) : sprintf('%s(%s)', gettype($conversionPerformanceReportFilterDeviceTypeItem), var_export($conversionPerformanceReportFilterDeviceTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DeviceTypeReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\DeviceTypeReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeviceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\DeviceTypeReportFilter::valueIsValid()
     * @uses \EnumType\DeviceTypeReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $deviceType
     * @return \StructType\ConversionPerformanceReportFilter
     */
    public function setDeviceType(array $deviceType = array())
    {
        // validation for constraint: list
        if ('' !== ($deviceTypeArrayErrorMessage = self::validateDeviceTypeForArrayConstraintsFromSetDeviceType($deviceType))) {
            throw new \InvalidArgumentException($deviceTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($deviceType) || (is_array($deviceType) && empty($deviceType))) {
            unset($this->DeviceType);
        } else {
            $this->DeviceType = is_array($deviceType) ? implode(' ', $deviceType) : null;
        }
        return $this;
    }
    /**
     * Get KeywordStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getKeywordStatus()
    {
        return isset($this->KeywordStatus) ? $this->KeywordStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setKeywordStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKeywordStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKeywordStatusForArrayConstraintsFromSetKeywordStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $conversionPerformanceReportFilterKeywordStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\KeywordStatusReportFilter::valueIsValid($conversionPerformanceReportFilterKeywordStatusItem)) {
                $invalidValues[] = is_object($conversionPerformanceReportFilterKeywordStatusItem) ? get_class($conversionPerformanceReportFilterKeywordStatusItem) : sprintf('%s(%s)', gettype($conversionPerformanceReportFilterKeywordStatusItem), var_export($conversionPerformanceReportFilterKeywordStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KeywordStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\KeywordStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set KeywordStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\KeywordStatusReportFilter::valueIsValid()
     * @uses \EnumType\KeywordStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $keywordStatus
     * @return \StructType\ConversionPerformanceReportFilter
     */
    public function setKeywordStatus(array $keywordStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($keywordStatusArrayErrorMessage = self::validateKeywordStatusForArrayConstraintsFromSetKeywordStatus($keywordStatus))) {
            throw new \InvalidArgumentException($keywordStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($keywordStatus) || (is_array($keywordStatus) && empty($keywordStatus))) {
            unset($this->KeywordStatus);
        } else {
            $this->KeywordStatus = is_array($keywordStatus) ? implode(' ', $keywordStatus) : null;
        }
        return $this;
    }
    /**
     * Get Keywords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getKeywords()
    {
        return isset($this->Keywords) ? $this->Keywords : null;
    }
    /**
     * Set Keywords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $keywords
     * @return \StructType\ConversionPerformanceReportFilter
     */
    public function setKeywords(\ArrayType\ArrayOfstring $keywords = null)
    {
        if (is_null($keywords) || (is_array($keywords) && empty($keywords))) {
            unset($this->Keywords);
        } else {
            $this->Keywords = $keywords;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConversionPerformanceReportFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
