<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdGroupPerformanceReportFilter StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AdGroupPerformanceReportFilter
 * @subpackage Structs
 */
class AdGroupPerformanceReportFilter extends AbstractStructBase
{
    /**
     * The AccountStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AccountStatus;
    /**
     * The AdDistribution
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AdDistribution;
    /**
     * The CampaignStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $CampaignStatus;
    /**
     * The DeviceOS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $DeviceOS;
    /**
     * The DeviceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $DeviceType;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $Language;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $Status;
    /**
     * Constructor method for AdGroupPerformanceReportFilter
     * @uses AdGroupPerformanceReportFilter::setAccountStatus()
     * @uses AdGroupPerformanceReportFilter::setAdDistribution()
     * @uses AdGroupPerformanceReportFilter::setCampaignStatus()
     * @uses AdGroupPerformanceReportFilter::setDeviceOS()
     * @uses AdGroupPerformanceReportFilter::setDeviceType()
     * @uses AdGroupPerformanceReportFilter::setLanguage()
     * @uses AdGroupPerformanceReportFilter::setStatus()
     * @param string[] $accountStatus
     * @param string[] $adDistribution
     * @param string[] $campaignStatus
     * @param string[] $deviceOS
     * @param string[] $deviceType
     * @param string[] $language
     * @param string[] $status
     */
    public function __construct(array $accountStatus = array(), array $adDistribution = array(), array $campaignStatus = array(), array $deviceOS = array(), array $deviceType = array(), array $language = array(), array $status = array())
    {
        $this
            ->setAccountStatus($accountStatus)
            ->setAdDistribution($adDistribution)
            ->setCampaignStatus($campaignStatus)
            ->setDeviceOS($deviceOS)
            ->setDeviceType($deviceType)
            ->setLanguage($language)
            ->setStatus($status);
    }
    /**
     * Get AccountStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAccountStatus()
    {
        return isset($this->AccountStatus) ? $this->AccountStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountStatusForArrayConstraintsFromSetAccountStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $adGroupPerformanceReportFilterAccountStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AccountStatusReportFilter::valueIsValid($adGroupPerformanceReportFilterAccountStatusItem)) {
                $invalidValues[] = is_object($adGroupPerformanceReportFilterAccountStatusItem) ? get_class($adGroupPerformanceReportFilterAccountStatusItem) : sprintf('%s(%s)', gettype($adGroupPerformanceReportFilterAccountStatusItem), var_export($adGroupPerformanceReportFilterAccountStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AccountStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccountStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AccountStatusReportFilter::valueIsValid()
     * @uses \EnumType\AccountStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accountStatus
     * @return \StructType\AdGroupPerformanceReportFilter
     */
    public function setAccountStatus(array $accountStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($accountStatusArrayErrorMessage = self::validateAccountStatusForArrayConstraintsFromSetAccountStatus($accountStatus))) {
            throw new \InvalidArgumentException($accountStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($accountStatus) || (is_array($accountStatus) && empty($accountStatus))) {
            unset($this->AccountStatus);
        } else {
            $this->AccountStatus = is_array($accountStatus) ? implode(' ', $accountStatus) : null;
        }
        return $this;
    }
    /**
     * Get AdDistribution value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdDistribution()
    {
        return isset($this->AdDistribution) ? $this->AdDistribution : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdDistribution method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdDistribution method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdDistributionForArrayConstraintsFromSetAdDistribution(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $adGroupPerformanceReportFilterAdDistributionItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdDistributionReportFilter::valueIsValid($adGroupPerformanceReportFilterAdDistributionItem)) {
                $invalidValues[] = is_object($adGroupPerformanceReportFilterAdDistributionItem) ? get_class($adGroupPerformanceReportFilterAdDistributionItem) : sprintf('%s(%s)', gettype($adGroupPerformanceReportFilterAdDistributionItem), var_export($adGroupPerformanceReportFilterAdDistributionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdDistributionReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdDistributionReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdDistribution value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdDistributionReportFilter::valueIsValid()
     * @uses \EnumType\AdDistributionReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $adDistribution
     * @return \StructType\AdGroupPerformanceReportFilter
     */
    public function setAdDistribution(array $adDistribution = array())
    {
        // validation for constraint: list
        if ('' !== ($adDistributionArrayErrorMessage = self::validateAdDistributionForArrayConstraintsFromSetAdDistribution($adDistribution))) {
            throw new \InvalidArgumentException($adDistributionArrayErrorMessage, __LINE__);
        }
        if (is_null($adDistribution) || (is_array($adDistribution) && empty($adDistribution))) {
            unset($this->AdDistribution);
        } else {
            $this->AdDistribution = is_array($adDistribution) ? implode(' ', $adDistribution) : null;
        }
        return $this;
    }
    /**
     * Get CampaignStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getCampaignStatus()
    {
        return isset($this->CampaignStatus) ? $this->CampaignStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCampaignStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCampaignStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCampaignStatusForArrayConstraintsFromSetCampaignStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $adGroupPerformanceReportFilterCampaignStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\CampaignStatusReportFilter::valueIsValid($adGroupPerformanceReportFilterCampaignStatusItem)) {
                $invalidValues[] = is_object($adGroupPerformanceReportFilterCampaignStatusItem) ? get_class($adGroupPerformanceReportFilterCampaignStatusItem) : sprintf('%s(%s)', gettype($adGroupPerformanceReportFilterCampaignStatusItem), var_export($adGroupPerformanceReportFilterCampaignStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CampaignStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\CampaignStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CampaignStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\CampaignStatusReportFilter::valueIsValid()
     * @uses \EnumType\CampaignStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $campaignStatus
     * @return \StructType\AdGroupPerformanceReportFilter
     */
    public function setCampaignStatus(array $campaignStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($campaignStatusArrayErrorMessage = self::validateCampaignStatusForArrayConstraintsFromSetCampaignStatus($campaignStatus))) {
            throw new \InvalidArgumentException($campaignStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($campaignStatus) || (is_array($campaignStatus) && empty($campaignStatus))) {
            unset($this->CampaignStatus);
        } else {
            $this->CampaignStatus = is_array($campaignStatus) ? implode(' ', $campaignStatus) : null;
        }
        return $this;
    }
    /**
     * Get DeviceOS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getDeviceOS()
    {
        return isset($this->DeviceOS) ? $this->DeviceOS : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDeviceOS method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeviceOS method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeviceOSForArrayConstraintsFromSetDeviceOS(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $adGroupPerformanceReportFilterDeviceOSItem) {
            // validation for constraint: enumeration
            if (!\EnumType\DeviceOSReportFilter::valueIsValid($adGroupPerformanceReportFilterDeviceOSItem)) {
                $invalidValues[] = is_object($adGroupPerformanceReportFilterDeviceOSItem) ? get_class($adGroupPerformanceReportFilterDeviceOSItem) : sprintf('%s(%s)', gettype($adGroupPerformanceReportFilterDeviceOSItem), var_export($adGroupPerformanceReportFilterDeviceOSItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DeviceOSReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\DeviceOSReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeviceOS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\DeviceOSReportFilter::valueIsValid()
     * @uses \EnumType\DeviceOSReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $deviceOS
     * @return \StructType\AdGroupPerformanceReportFilter
     */
    public function setDeviceOS(array $deviceOS = array())
    {
        // validation for constraint: list
        if ('' !== ($deviceOSArrayErrorMessage = self::validateDeviceOSForArrayConstraintsFromSetDeviceOS($deviceOS))) {
            throw new \InvalidArgumentException($deviceOSArrayErrorMessage, __LINE__);
        }
        if (is_null($deviceOS) || (is_array($deviceOS) && empty($deviceOS))) {
            unset($this->DeviceOS);
        } else {
            $this->DeviceOS = is_array($deviceOS) ? implode(' ', $deviceOS) : null;
        }
        return $this;
    }
    /**
     * Get DeviceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getDeviceType()
    {
        return isset($this->DeviceType) ? $this->DeviceType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDeviceType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeviceType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeviceTypeForArrayConstraintsFromSetDeviceType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $adGroupPerformanceReportFilterDeviceTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\DeviceTypeReportFilter::valueIsValid($adGroupPerformanceReportFilterDeviceTypeItem)) {
                $invalidValues[] = is_object($adGroupPerformanceReportFilterDeviceTypeItem) ? get_class($adGroupPerformanceReportFilterDeviceTypeItem) : sprintf('%s(%s)', gettype($adGroupPerformanceReportFilterDeviceTypeItem), var_export($adGroupPerformanceReportFilterDeviceTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DeviceTypeReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\DeviceTypeReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeviceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\DeviceTypeReportFilter::valueIsValid()
     * @uses \EnumType\DeviceTypeReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $deviceType
     * @return \StructType\AdGroupPerformanceReportFilter
     */
    public function setDeviceType(array $deviceType = array())
    {
        // validation for constraint: list
        if ('' !== ($deviceTypeArrayErrorMessage = self::validateDeviceTypeForArrayConstraintsFromSetDeviceType($deviceType))) {
            throw new \InvalidArgumentException($deviceTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($deviceType) || (is_array($deviceType) && empty($deviceType))) {
            unset($this->DeviceType);
        } else {
            $this->DeviceType = is_array($deviceType) ? implode(' ', $deviceType) : null;
        }
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLanguage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLanguage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLanguageForArrayConstraintsFromSetLanguage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $adGroupPerformanceReportFilterLanguageItem) {
            // validation for constraint: enumeration
            if (!\EnumType\LanguageReportFilter::valueIsValid($adGroupPerformanceReportFilterLanguageItem)) {
                $invalidValues[] = is_object($adGroupPerformanceReportFilterLanguageItem) ? get_class($adGroupPerformanceReportFilterLanguageItem) : sprintf('%s(%s)', gettype($adGroupPerformanceReportFilterLanguageItem), var_export($adGroupPerformanceReportFilterLanguageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LanguageReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\LanguageReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\LanguageReportFilter::valueIsValid()
     * @uses \EnumType\LanguageReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $language
     * @return \StructType\AdGroupPerformanceReportFilter
     */
    public function setLanguage(array $language = array())
    {
        // validation for constraint: list
        if ('' !== ($languageArrayErrorMessage = self::validateLanguageForArrayConstraintsFromSetLanguage($language))) {
            throw new \InvalidArgumentException($languageArrayErrorMessage, __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = is_array($language) ? implode(' ', $language) : null;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * This method is responsible for validating the values passed to the setStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatusForArrayConstraintsFromSetStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $adGroupPerformanceReportFilterStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdGroupStatusReportFilter::valueIsValid($adGroupPerformanceReportFilterStatusItem)) {
                $invalidValues[] = is_object($adGroupPerformanceReportFilterStatusItem) ? get_class($adGroupPerformanceReportFilterStatusItem) : sprintf('%s(%s)', gettype($adGroupPerformanceReportFilterStatusItem), var_export($adGroupPerformanceReportFilterStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdGroupStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdGroupStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdGroupStatusReportFilter::valueIsValid()
     * @uses \EnumType\AdGroupStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $status
     * @return \StructType\AdGroupPerformanceReportFilter
     */
    public function setStatus(array $status = array())
    {
        // validation for constraint: list
        if ('' !== ($statusArrayErrorMessage = self::validateStatusForArrayConstraintsFromSetStatus($status))) {
            throw new \InvalidArgumentException($statusArrayErrorMessage, __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = is_array($status) ? implode(' ', $status) : null;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdGroupPerformanceReportFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
