<?php

namespace EnumType;

/**
 * This class stands for UserLocationPerformanceReportColumn EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UserLocationPerformanceReportColumn
 * @subpackage Enumerations
 */
class UserLocationPerformanceReportColumn
{
    /**
     * Constant for value 'AccountName'
     * @return string 'AccountName'
     */
    const VALUE_ACCOUNT_NAME = 'AccountName';
    /**
     * Constant for value 'AccountNumber'
     * @return string 'AccountNumber'
     */
    const VALUE_ACCOUNT_NUMBER = 'AccountNumber';
    /**
     * Constant for value 'AccountId'
     * @return string 'AccountId'
     */
    const VALUE_ACCOUNT_ID = 'AccountId';
    /**
     * Constant for value 'TimePeriod'
     * @return string 'TimePeriod'
     */
    const VALUE_TIME_PERIOD = 'TimePeriod';
    /**
     * Constant for value 'CampaignName'
     * @return string 'CampaignName'
     */
    const VALUE_CAMPAIGN_NAME = 'CampaignName';
    /**
     * Constant for value 'CampaignId'
     * @return string 'CampaignId'
     */
    const VALUE_CAMPAIGN_ID = 'CampaignId';
    /**
     * Constant for value 'AdGroupName'
     * @return string 'AdGroupName'
     */
    const VALUE_AD_GROUP_NAME = 'AdGroupName';
    /**
     * Constant for value 'AdGroupId'
     * @return string 'AdGroupId'
     */
    const VALUE_AD_GROUP_ID = 'AdGroupId';
    /**
     * Constant for value 'Country'
     * @return string 'Country'
     */
    const VALUE_COUNTRY = 'Country';
    /**
     * Constant for value 'State'
     * @return string 'State'
     */
    const VALUE_STATE = 'State';
    /**
     * Constant for value 'MetroArea'
     * @return string 'MetroArea'
     */
    const VALUE_METRO_AREA = 'MetroArea';
    /**
     * Constant for value 'CurrencyCode'
     * @return string 'CurrencyCode'
     */
    const VALUE_CURRENCY_CODE = 'CurrencyCode';
    /**
     * Constant for value 'AdDistribution'
     * @return string 'AdDistribution'
     */
    const VALUE_AD_DISTRIBUTION = 'AdDistribution';
    /**
     * Constant for value 'Impressions'
     * @return string 'Impressions'
     */
    const VALUE_IMPRESSIONS = 'Impressions';
    /**
     * Constant for value 'Clicks'
     * @return string 'Clicks'
     */
    const VALUE_CLICKS = 'Clicks';
    /**
     * Constant for value 'Ctr'
     * @return string 'Ctr'
     */
    const VALUE_CTR = 'Ctr';
    /**
     * Constant for value 'AverageCpc'
     * @return string 'AverageCpc'
     */
    const VALUE_AVERAGE_CPC = 'AverageCpc';
    /**
     * Constant for value 'Spend'
     * @return string 'Spend'
     */
    const VALUE_SPEND = 'Spend';
    /**
     * Constant for value 'AveragePosition'
     * @return string 'AveragePosition'
     */
    const VALUE_AVERAGE_POSITION = 'AveragePosition';
    /**
     * Constant for value 'ProximityTargetLocation'
     * @return string 'ProximityTargetLocation'
     */
    const VALUE_PROXIMITY_TARGET_LOCATION = 'ProximityTargetLocation';
    /**
     * Constant for value 'Radius'
     * @return string 'Radius'
     */
    const VALUE_RADIUS = 'Radius';
    /**
     * Constant for value 'Language'
     * @return string 'Language'
     */
    const VALUE_LANGUAGE = 'Language';
    /**
     * Constant for value 'City'
     * @return string 'City'
     */
    const VALUE_CITY = 'City';
    /**
     * Constant for value 'QueryIntentCountry'
     * @return string 'QueryIntentCountry'
     */
    const VALUE_QUERY_INTENT_COUNTRY = 'QueryIntentCountry';
    /**
     * Constant for value 'QueryIntentState'
     * @return string 'QueryIntentState'
     */
    const VALUE_QUERY_INTENT_STATE = 'QueryIntentState';
    /**
     * Constant for value 'QueryIntentCity'
     * @return string 'QueryIntentCity'
     */
    const VALUE_QUERY_INTENT_CITY = 'QueryIntentCity';
    /**
     * Constant for value 'QueryIntentDMA'
     * @return string 'QueryIntentDMA'
     */
    const VALUE_QUERY_INTENT_DMA = 'QueryIntentDMA';
    /**
     * Constant for value 'BidMatchType'
     * @return string 'BidMatchType'
     */
    const VALUE_BID_MATCH_TYPE = 'BidMatchType';
    /**
     * Constant for value 'DeliveredMatchType'
     * @return string 'DeliveredMatchType'
     */
    const VALUE_DELIVERED_MATCH_TYPE = 'DeliveredMatchType';
    /**
     * Constant for value 'Network'
     * @return string 'Network'
     */
    const VALUE_NETWORK = 'Network';
    /**
     * Constant for value 'TopVsOther'
     * @return string 'TopVsOther'
     */
    const VALUE_TOP_VS_OTHER = 'TopVsOther';
    /**
     * Constant for value 'DeviceType'
     * @return string 'DeviceType'
     */
    const VALUE_DEVICE_TYPE = 'DeviceType';
    /**
     * Constant for value 'DeviceOS'
     * @return string 'DeviceOS'
     */
    const VALUE_DEVICE_OS = 'DeviceOS';
    /**
     * Constant for value 'Assists'
     * @return string 'Assists'
     */
    const VALUE_ASSISTS = 'Assists';
    /**
     * Constant for value 'Conversions'
     * @return string 'Conversions'
     */
    const VALUE_CONVERSIONS = 'Conversions';
    /**
     * Constant for value 'ConversionRate'
     * @return string 'ConversionRate'
     */
    const VALUE_CONVERSION_RATE = 'ConversionRate';
    /**
     * Constant for value 'Revenue'
     * @return string 'Revenue'
     */
    const VALUE_REVENUE = 'Revenue';
    /**
     * Constant for value 'ReturnOnAdSpend'
     * @return string 'ReturnOnAdSpend'
     */
    const VALUE_RETURN_ON_AD_SPEND = 'ReturnOnAdSpend';
    /**
     * Constant for value 'CostPerConversion'
     * @return string 'CostPerConversion'
     */
    const VALUE_COST_PER_CONVERSION = 'CostPerConversion';
    /**
     * Constant for value 'CostPerAssist'
     * @return string 'CostPerAssist'
     */
    const VALUE_COST_PER_ASSIST = 'CostPerAssist';
    /**
     * Constant for value 'RevenuePerConversion'
     * @return string 'RevenuePerConversion'
     */
    const VALUE_REVENUE_PER_CONVERSION = 'RevenuePerConversion';
    /**
     * Constant for value 'RevenuePerAssist'
     * @return string 'RevenuePerAssist'
     */
    const VALUE_REVENUE_PER_ASSIST = 'RevenuePerAssist';
    /**
     * Constant for value 'County'
     * @return string 'County'
     */
    const VALUE_COUNTY = 'County';
    /**
     * Constant for value 'PostalCode'
     * @return string 'PostalCode'
     */
    const VALUE_POSTAL_CODE = 'PostalCode';
    /**
     * Constant for value 'QueryIntentCounty'
     * @return string 'QueryIntentCounty'
     */
    const VALUE_QUERY_INTENT_COUNTY = 'QueryIntentCounty';
    /**
     * Constant for value 'QueryIntentPostalCode'
     * @return string 'QueryIntentPostalCode'
     */
    const VALUE_QUERY_INTENT_POSTAL_CODE = 'QueryIntentPostalCode';
    /**
     * Constant for value 'LocationId'
     * @return string 'LocationId'
     */
    const VALUE_LOCATION_ID = 'LocationId';
    /**
     * Constant for value 'QueryIntentLocationId'
     * @return string 'QueryIntentLocationId'
     */
    const VALUE_QUERY_INTENT_LOCATION_ID = 'QueryIntentLocationId';
    /**
     * Constant for value 'AllConversions'
     * @return string 'AllConversions'
     */
    const VALUE_ALL_CONVERSIONS = 'AllConversions';
    /**
     * Constant for value 'AllRevenue'
     * @return string 'AllRevenue'
     */
    const VALUE_ALL_REVENUE = 'AllRevenue';
    /**
     * Constant for value 'AllConversionRate'
     * @return string 'AllConversionRate'
     */
    const VALUE_ALL_CONVERSION_RATE = 'AllConversionRate';
    /**
     * Constant for value 'AllCostPerConversion'
     * @return string 'AllCostPerConversion'
     */
    const VALUE_ALL_COST_PER_CONVERSION = 'AllCostPerConversion';
    /**
     * Constant for value 'AllReturnOnAdSpend'
     * @return string 'AllReturnOnAdSpend'
     */
    const VALUE_ALL_RETURN_ON_AD_SPEND = 'AllReturnOnAdSpend';
    /**
     * Constant for value 'AllRevenuePerConversion'
     * @return string 'AllRevenuePerConversion'
     */
    const VALUE_ALL_REVENUE_PER_CONVERSION = 'AllRevenuePerConversion';
    /**
     * Constant for value 'ViewThroughConversions'
     * @return string 'ViewThroughConversions'
     */
    const VALUE_VIEW_THROUGH_CONVERSIONS = 'ViewThroughConversions';
    /**
     * Constant for value 'Goal'
     * @return string 'Goal'
     */
    const VALUE_GOAL = 'Goal';
    /**
     * Constant for value 'GoalType'
     * @return string 'GoalType'
     */
    const VALUE_GOAL_TYPE = 'GoalType';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCOUNT_NAME
     * @uses self::VALUE_ACCOUNT_NUMBER
     * @uses self::VALUE_ACCOUNT_ID
     * @uses self::VALUE_TIME_PERIOD
     * @uses self::VALUE_CAMPAIGN_NAME
     * @uses self::VALUE_CAMPAIGN_ID
     * @uses self::VALUE_AD_GROUP_NAME
     * @uses self::VALUE_AD_GROUP_ID
     * @uses self::VALUE_COUNTRY
     * @uses self::VALUE_STATE
     * @uses self::VALUE_METRO_AREA
     * @uses self::VALUE_CURRENCY_CODE
     * @uses self::VALUE_AD_DISTRIBUTION
     * @uses self::VALUE_IMPRESSIONS
     * @uses self::VALUE_CLICKS
     * @uses self::VALUE_CTR
     * @uses self::VALUE_AVERAGE_CPC
     * @uses self::VALUE_SPEND
     * @uses self::VALUE_AVERAGE_POSITION
     * @uses self::VALUE_PROXIMITY_TARGET_LOCATION
     * @uses self::VALUE_RADIUS
     * @uses self::VALUE_LANGUAGE
     * @uses self::VALUE_CITY
     * @uses self::VALUE_QUERY_INTENT_COUNTRY
     * @uses self::VALUE_QUERY_INTENT_STATE
     * @uses self::VALUE_QUERY_INTENT_CITY
     * @uses self::VALUE_QUERY_INTENT_DMA
     * @uses self::VALUE_BID_MATCH_TYPE
     * @uses self::VALUE_DELIVERED_MATCH_TYPE
     * @uses self::VALUE_NETWORK
     * @uses self::VALUE_TOP_VS_OTHER
     * @uses self::VALUE_DEVICE_TYPE
     * @uses self::VALUE_DEVICE_OS
     * @uses self::VALUE_ASSISTS
     * @uses self::VALUE_CONVERSIONS
     * @uses self::VALUE_CONVERSION_RATE
     * @uses self::VALUE_REVENUE
     * @uses self::VALUE_RETURN_ON_AD_SPEND
     * @uses self::VALUE_COST_PER_CONVERSION
     * @uses self::VALUE_COST_PER_ASSIST
     * @uses self::VALUE_REVENUE_PER_CONVERSION
     * @uses self::VALUE_REVENUE_PER_ASSIST
     * @uses self::VALUE_COUNTY
     * @uses self::VALUE_POSTAL_CODE
     * @uses self::VALUE_QUERY_INTENT_COUNTY
     * @uses self::VALUE_QUERY_INTENT_POSTAL_CODE
     * @uses self::VALUE_LOCATION_ID
     * @uses self::VALUE_QUERY_INTENT_LOCATION_ID
     * @uses self::VALUE_ALL_CONVERSIONS
     * @uses self::VALUE_ALL_REVENUE
     * @uses self::VALUE_ALL_CONVERSION_RATE
     * @uses self::VALUE_ALL_COST_PER_CONVERSION
     * @uses self::VALUE_ALL_RETURN_ON_AD_SPEND
     * @uses self::VALUE_ALL_REVENUE_PER_CONVERSION
     * @uses self::VALUE_VIEW_THROUGH_CONVERSIONS
     * @uses self::VALUE_GOAL
     * @uses self::VALUE_GOAL_TYPE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCOUNT_NAME,
            self::VALUE_ACCOUNT_NUMBER,
            self::VALUE_ACCOUNT_ID,
            self::VALUE_TIME_PERIOD,
            self::VALUE_CAMPAIGN_NAME,
            self::VALUE_CAMPAIGN_ID,
            self::VALUE_AD_GROUP_NAME,
            self::VALUE_AD_GROUP_ID,
            self::VALUE_COUNTRY,
            self::VALUE_STATE,
            self::VALUE_METRO_AREA,
            self::VALUE_CURRENCY_CODE,
            self::VALUE_AD_DISTRIBUTION,
            self::VALUE_IMPRESSIONS,
            self::VALUE_CLICKS,
            self::VALUE_CTR,
            self::VALUE_AVERAGE_CPC,
            self::VALUE_SPEND,
            self::VALUE_AVERAGE_POSITION,
            self::VALUE_PROXIMITY_TARGET_LOCATION,
            self::VALUE_RADIUS,
            self::VALUE_LANGUAGE,
            self::VALUE_CITY,
            self::VALUE_QUERY_INTENT_COUNTRY,
            self::VALUE_QUERY_INTENT_STATE,
            self::VALUE_QUERY_INTENT_CITY,
            self::VALUE_QUERY_INTENT_DMA,
            self::VALUE_BID_MATCH_TYPE,
            self::VALUE_DELIVERED_MATCH_TYPE,
            self::VALUE_NETWORK,
            self::VALUE_TOP_VS_OTHER,
            self::VALUE_DEVICE_TYPE,
            self::VALUE_DEVICE_OS,
            self::VALUE_ASSISTS,
            self::VALUE_CONVERSIONS,
            self::VALUE_CONVERSION_RATE,
            self::VALUE_REVENUE,
            self::VALUE_RETURN_ON_AD_SPEND,
            self::VALUE_COST_PER_CONVERSION,
            self::VALUE_COST_PER_ASSIST,
            self::VALUE_REVENUE_PER_CONVERSION,
            self::VALUE_REVENUE_PER_ASSIST,
            self::VALUE_COUNTY,
            self::VALUE_POSTAL_CODE,
            self::VALUE_QUERY_INTENT_COUNTY,
            self::VALUE_QUERY_INTENT_POSTAL_CODE,
            self::VALUE_LOCATION_ID,
            self::VALUE_QUERY_INTENT_LOCATION_ID,
            self::VALUE_ALL_CONVERSIONS,
            self::VALUE_ALL_REVENUE,
            self::VALUE_ALL_CONVERSION_RATE,
            self::VALUE_ALL_COST_PER_CONVERSION,
            self::VALUE_ALL_RETURN_ON_AD_SPEND,
            self::VALUE_ALL_REVENUE_PER_CONVERSION,
            self::VALUE_VIEW_THROUGH_CONVERSIONS,
            self::VALUE_GOAL,
            self::VALUE_GOAL_TYPE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
