<?php

namespace EnumType;

/**
 * This class stands for ShareOfVoiceReportColumn EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ShareOfVoiceReportColumn
 * @subpackage Enumerations
 */
class ShareOfVoiceReportColumn
{
    /**
     * Constant for value 'AccountName'
     * @return string 'AccountName'
     */
    const VALUE_ACCOUNT_NAME = 'AccountName';
    /**
     * Constant for value 'TimePeriod'
     * @return string 'TimePeriod'
     */
    const VALUE_TIME_PERIOD = 'TimePeriod';
    /**
     * Constant for value 'CampaignName'
     * @return string 'CampaignName'
     */
    const VALUE_CAMPAIGN_NAME = 'CampaignName';
    /**
     * Constant for value 'AdGroupName'
     * @return string 'AdGroupName'
     */
    const VALUE_AD_GROUP_NAME = 'AdGroupName';
    /**
     * Constant for value 'Keyword'
     * @return string 'Keyword'
     */
    const VALUE_KEYWORD = 'Keyword';
    /**
     * Constant for value 'DeliveredMatchType'
     * @return string 'DeliveredMatchType'
     */
    const VALUE_DELIVERED_MATCH_TYPE = 'DeliveredMatchType';
    /**
     * Constant for value 'BidMatchType'
     * @return string 'BidMatchType'
     */
    const VALUE_BID_MATCH_TYPE = 'BidMatchType';
    /**
     * Constant for value 'Language'
     * @return string 'Language'
     */
    const VALUE_LANGUAGE = 'Language';
    /**
     * Constant for value 'AccountNumber'
     * @return string 'AccountNumber'
     */
    const VALUE_ACCOUNT_NUMBER = 'AccountNumber';
    /**
     * Constant for value 'AccountId'
     * @return string 'AccountId'
     */
    const VALUE_ACCOUNT_ID = 'AccountId';
    /**
     * Constant for value 'KeywordId'
     * @return string 'KeywordId'
     */
    const VALUE_KEYWORD_ID = 'KeywordId';
    /**
     * Constant for value 'AdGroupId'
     * @return string 'AdGroupId'
     */
    const VALUE_AD_GROUP_ID = 'AdGroupId';
    /**
     * Constant for value 'CampaignId'
     * @return string 'CampaignId'
     */
    const VALUE_CAMPAIGN_ID = 'CampaignId';
    /**
     * Constant for value 'Impressions'
     * @return string 'Impressions'
     */
    const VALUE_IMPRESSIONS = 'Impressions';
    /**
     * Constant for value 'Clicks'
     * @return string 'Clicks'
     */
    const VALUE_CLICKS = 'Clicks';
    /**
     * Constant for value 'Ctr'
     * @return string 'Ctr'
     */
    const VALUE_CTR = 'Ctr';
    /**
     * Constant for value 'AverageCpc'
     * @return string 'AverageCpc'
     */
    const VALUE_AVERAGE_CPC = 'AverageCpc';
    /**
     * Constant for value 'Spend'
     * @return string 'Spend'
     */
    const VALUE_SPEND = 'Spend';
    /**
     * Constant for value 'AveragePosition'
     * @return string 'AveragePosition'
     */
    const VALUE_AVERAGE_POSITION = 'AveragePosition';
    /**
     * Constant for value 'ImpressionSharePercent'
     * @return string 'ImpressionSharePercent'
     */
    const VALUE_IMPRESSION_SHARE_PERCENT = 'ImpressionSharePercent';
    /**
     * Constant for value 'ImpressionLostToBudgetPercent'
     * @return string 'ImpressionLostToBudgetPercent'
     */
    const VALUE_IMPRESSION_LOST_TO_BUDGET_PERCENT = 'ImpressionLostToBudgetPercent';
    /**
     * Constant for value 'ImpressionLostToRankAggPercent'
     * @return string 'ImpressionLostToRankAggPercent'
     */
    const VALUE_IMPRESSION_LOST_TO_RANK_AGG_PERCENT = 'ImpressionLostToRankAggPercent';
    /**
     * Constant for value 'CurrentMaxCpc'
     * @return string 'CurrentMaxCpc'
     */
    const VALUE_CURRENT_MAX_CPC = 'CurrentMaxCpc';
    /**
     * Constant for value 'QualityScore'
     * @return string 'QualityScore'
     */
    const VALUE_QUALITY_SCORE = 'QualityScore';
    /**
     * Constant for value 'ExpectedCtr'
     * @return string 'ExpectedCtr'
     */
    const VALUE_EXPECTED_CTR = 'ExpectedCtr';
    /**
     * Constant for value 'AdRelevance'
     * @return string 'AdRelevance'
     */
    const VALUE_AD_RELEVANCE = 'AdRelevance';
    /**
     * Constant for value 'LandingPageExperience'
     * @return string 'LandingPageExperience'
     */
    const VALUE_LANDING_PAGE_EXPERIENCE = 'LandingPageExperience';
    /**
     * Constant for value 'Conversions'
     * @return string 'Conversions'
     */
    const VALUE_CONVERSIONS = 'Conversions';
    /**
     * Constant for value 'ConversionRate'
     * @return string 'ConversionRate'
     */
    const VALUE_CONVERSION_RATE = 'ConversionRate';
    /**
     * Constant for value 'CostPerConversion'
     * @return string 'CostPerConversion'
     */
    const VALUE_COST_PER_CONVERSION = 'CostPerConversion';
    /**
     * Constant for value 'AdDistribution'
     * @return string 'AdDistribution'
     */
    const VALUE_AD_DISTRIBUTION = 'AdDistribution';
    /**
     * Constant for value 'ClickSharePercent'
     * @return string 'ClickSharePercent'
     */
    const VALUE_CLICK_SHARE_PERCENT = 'ClickSharePercent';
    /**
     * Constant for value 'DeviceType'
     * @return string 'DeviceType'
     */
    const VALUE_DEVICE_TYPE = 'DeviceType';
    /**
     * Constant for value 'Network'
     * @return string 'Network'
     */
    const VALUE_NETWORK = 'Network';
    /**
     * Constant for value 'AccountStatus'
     * @return string 'AccountStatus'
     */
    const VALUE_ACCOUNT_STATUS = 'AccountStatus';
    /**
     * Constant for value 'CampaignStatus'
     * @return string 'CampaignStatus'
     */
    const VALUE_CAMPAIGN_STATUS = 'CampaignStatus';
    /**
     * Constant for value 'AdGroupStatus'
     * @return string 'AdGroupStatus'
     */
    const VALUE_AD_GROUP_STATUS = 'AdGroupStatus';
    /**
     * Constant for value 'KeywordStatus'
     * @return string 'KeywordStatus'
     */
    const VALUE_KEYWORD_STATUS = 'KeywordStatus';
    /**
     * Constant for value 'BidStrategyType'
     * @return string 'BidStrategyType'
     */
    const VALUE_BID_STRATEGY_TYPE = 'BidStrategyType';
    /**
     * Constant for value 'KeywordLabels'
     * @return string 'KeywordLabels'
     */
    const VALUE_KEYWORD_LABELS = 'KeywordLabels';
    /**
     * Constant for value 'ExactMatchImpressionSharePercent'
     * @return string 'ExactMatchImpressionSharePercent'
     */
    const VALUE_EXACT_MATCH_IMPRESSION_SHARE_PERCENT = 'ExactMatchImpressionSharePercent';
    /**
     * Constant for value 'TopImpressionShareLostToRankPercent'
     * @return string 'TopImpressionShareLostToRankPercent'
     */
    const VALUE_TOP_IMPRESSION_SHARE_LOST_TO_RANK_PERCENT = 'TopImpressionShareLostToRankPercent';
    /**
     * Constant for value 'TopImpressionShareLostToBudgetPercent'
     * @return string 'TopImpressionShareLostToBudgetPercent'
     */
    const VALUE_TOP_IMPRESSION_SHARE_LOST_TO_BUDGET_PERCENT = 'TopImpressionShareLostToBudgetPercent';
    /**
     * Constant for value 'AbsoluteTopImpressionShareLostToRankPercent'
     * @return string 'AbsoluteTopImpressionShareLostToRankPercent'
     */
    const VALUE_ABSOLUTE_TOP_IMPRESSION_SHARE_LOST_TO_RANK_PERCENT = 'AbsoluteTopImpressionShareLostToRankPercent';
    /**
     * Constant for value 'AbsoluteTopImpressionShareLostToBudgetPercent'
     * @return string 'AbsoluteTopImpressionShareLostToBudgetPercent'
     */
    const VALUE_ABSOLUTE_TOP_IMPRESSION_SHARE_LOST_TO_BUDGET_PERCENT = 'AbsoluteTopImpressionShareLostToBudgetPercent';
    /**
     * Constant for value 'AbsoluteTopImpressionSharePercent'
     * @return string 'AbsoluteTopImpressionSharePercent'
     */
    const VALUE_ABSOLUTE_TOP_IMPRESSION_SHARE_PERCENT = 'AbsoluteTopImpressionSharePercent';
    /**
     * Constant for value 'TopImpressionSharePercent'
     * @return string 'TopImpressionSharePercent'
     */
    const VALUE_TOP_IMPRESSION_SHARE_PERCENT = 'TopImpressionSharePercent';
    /**
     * Constant for value 'AbsoluteTopImpressionRatePercent'
     * @return string 'AbsoluteTopImpressionRatePercent'
     */
    const VALUE_ABSOLUTE_TOP_IMPRESSION_RATE_PERCENT = 'AbsoluteTopImpressionRatePercent';
    /**
     * Constant for value 'TopImpressionRatePercent'
     * @return string 'TopImpressionRatePercent'
     */
    const VALUE_TOP_IMPRESSION_RATE_PERCENT = 'TopImpressionRatePercent';
    /**
     * Constant for value 'BaseCampaignId'
     * @return string 'BaseCampaignId'
     */
    const VALUE_BASE_CAMPAIGN_ID = 'BaseCampaignId';
    /**
     * Constant for value 'AllConversions'
     * @return string 'AllConversions'
     */
    const VALUE_ALL_CONVERSIONS = 'AllConversions';
    /**
     * Constant for value 'AllConversionRate'
     * @return string 'AllConversionRate'
     */
    const VALUE_ALL_CONVERSION_RATE = 'AllConversionRate';
    /**
     * Constant for value 'AllCostPerConversion'
     * @return string 'AllCostPerConversion'
     */
    const VALUE_ALL_COST_PER_CONVERSION = 'AllCostPerConversion';
    /**
     * Constant for value 'ViewThroughConversions'
     * @return string 'ViewThroughConversions'
     */
    const VALUE_VIEW_THROUGH_CONVERSIONS = 'ViewThroughConversions';
    /**
     * Constant for value 'Goal'
     * @return string 'Goal'
     */
    const VALUE_GOAL = 'Goal';
    /**
     * Constant for value 'GoalType'
     * @return string 'GoalType'
     */
    const VALUE_GOAL_TYPE = 'GoalType';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCOUNT_NAME
     * @uses self::VALUE_TIME_PERIOD
     * @uses self::VALUE_CAMPAIGN_NAME
     * @uses self::VALUE_AD_GROUP_NAME
     * @uses self::VALUE_KEYWORD
     * @uses self::VALUE_DELIVERED_MATCH_TYPE
     * @uses self::VALUE_BID_MATCH_TYPE
     * @uses self::VALUE_LANGUAGE
     * @uses self::VALUE_ACCOUNT_NUMBER
     * @uses self::VALUE_ACCOUNT_ID
     * @uses self::VALUE_KEYWORD_ID
     * @uses self::VALUE_AD_GROUP_ID
     * @uses self::VALUE_CAMPAIGN_ID
     * @uses self::VALUE_IMPRESSIONS
     * @uses self::VALUE_CLICKS
     * @uses self::VALUE_CTR
     * @uses self::VALUE_AVERAGE_CPC
     * @uses self::VALUE_SPEND
     * @uses self::VALUE_AVERAGE_POSITION
     * @uses self::VALUE_IMPRESSION_SHARE_PERCENT
     * @uses self::VALUE_IMPRESSION_LOST_TO_BUDGET_PERCENT
     * @uses self::VALUE_IMPRESSION_LOST_TO_RANK_AGG_PERCENT
     * @uses self::VALUE_CURRENT_MAX_CPC
     * @uses self::VALUE_QUALITY_SCORE
     * @uses self::VALUE_EXPECTED_CTR
     * @uses self::VALUE_AD_RELEVANCE
     * @uses self::VALUE_LANDING_PAGE_EXPERIENCE
     * @uses self::VALUE_CONVERSIONS
     * @uses self::VALUE_CONVERSION_RATE
     * @uses self::VALUE_COST_PER_CONVERSION
     * @uses self::VALUE_AD_DISTRIBUTION
     * @uses self::VALUE_CLICK_SHARE_PERCENT
     * @uses self::VALUE_DEVICE_TYPE
     * @uses self::VALUE_NETWORK
     * @uses self::VALUE_ACCOUNT_STATUS
     * @uses self::VALUE_CAMPAIGN_STATUS
     * @uses self::VALUE_AD_GROUP_STATUS
     * @uses self::VALUE_KEYWORD_STATUS
     * @uses self::VALUE_BID_STRATEGY_TYPE
     * @uses self::VALUE_KEYWORD_LABELS
     * @uses self::VALUE_EXACT_MATCH_IMPRESSION_SHARE_PERCENT
     * @uses self::VALUE_TOP_IMPRESSION_SHARE_LOST_TO_RANK_PERCENT
     * @uses self::VALUE_TOP_IMPRESSION_SHARE_LOST_TO_BUDGET_PERCENT
     * @uses self::VALUE_ABSOLUTE_TOP_IMPRESSION_SHARE_LOST_TO_RANK_PERCENT
     * @uses self::VALUE_ABSOLUTE_TOP_IMPRESSION_SHARE_LOST_TO_BUDGET_PERCENT
     * @uses self::VALUE_ABSOLUTE_TOP_IMPRESSION_SHARE_PERCENT
     * @uses self::VALUE_TOP_IMPRESSION_SHARE_PERCENT
     * @uses self::VALUE_ABSOLUTE_TOP_IMPRESSION_RATE_PERCENT
     * @uses self::VALUE_TOP_IMPRESSION_RATE_PERCENT
     * @uses self::VALUE_BASE_CAMPAIGN_ID
     * @uses self::VALUE_ALL_CONVERSIONS
     * @uses self::VALUE_ALL_CONVERSION_RATE
     * @uses self::VALUE_ALL_COST_PER_CONVERSION
     * @uses self::VALUE_VIEW_THROUGH_CONVERSIONS
     * @uses self::VALUE_GOAL
     * @uses self::VALUE_GOAL_TYPE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCOUNT_NAME,
            self::VALUE_TIME_PERIOD,
            self::VALUE_CAMPAIGN_NAME,
            self::VALUE_AD_GROUP_NAME,
            self::VALUE_KEYWORD,
            self::VALUE_DELIVERED_MATCH_TYPE,
            self::VALUE_BID_MATCH_TYPE,
            self::VALUE_LANGUAGE,
            self::VALUE_ACCOUNT_NUMBER,
            self::VALUE_ACCOUNT_ID,
            self::VALUE_KEYWORD_ID,
            self::VALUE_AD_GROUP_ID,
            self::VALUE_CAMPAIGN_ID,
            self::VALUE_IMPRESSIONS,
            self::VALUE_CLICKS,
            self::VALUE_CTR,
            self::VALUE_AVERAGE_CPC,
            self::VALUE_SPEND,
            self::VALUE_AVERAGE_POSITION,
            self::VALUE_IMPRESSION_SHARE_PERCENT,
            self::VALUE_IMPRESSION_LOST_TO_BUDGET_PERCENT,
            self::VALUE_IMPRESSION_LOST_TO_RANK_AGG_PERCENT,
            self::VALUE_CURRENT_MAX_CPC,
            self::VALUE_QUALITY_SCORE,
            self::VALUE_EXPECTED_CTR,
            self::VALUE_AD_RELEVANCE,
            self::VALUE_LANDING_PAGE_EXPERIENCE,
            self::VALUE_CONVERSIONS,
            self::VALUE_CONVERSION_RATE,
            self::VALUE_COST_PER_CONVERSION,
            self::VALUE_AD_DISTRIBUTION,
            self::VALUE_CLICK_SHARE_PERCENT,
            self::VALUE_DEVICE_TYPE,
            self::VALUE_NETWORK,
            self::VALUE_ACCOUNT_STATUS,
            self::VALUE_CAMPAIGN_STATUS,
            self::VALUE_AD_GROUP_STATUS,
            self::VALUE_KEYWORD_STATUS,
            self::VALUE_BID_STRATEGY_TYPE,
            self::VALUE_KEYWORD_LABELS,
            self::VALUE_EXACT_MATCH_IMPRESSION_SHARE_PERCENT,
            self::VALUE_TOP_IMPRESSION_SHARE_LOST_TO_RANK_PERCENT,
            self::VALUE_TOP_IMPRESSION_SHARE_LOST_TO_BUDGET_PERCENT,
            self::VALUE_ABSOLUTE_TOP_IMPRESSION_SHARE_LOST_TO_RANK_PERCENT,
            self::VALUE_ABSOLUTE_TOP_IMPRESSION_SHARE_LOST_TO_BUDGET_PERCENT,
            self::VALUE_ABSOLUTE_TOP_IMPRESSION_SHARE_PERCENT,
            self::VALUE_TOP_IMPRESSION_SHARE_PERCENT,
            self::VALUE_ABSOLUTE_TOP_IMPRESSION_RATE_PERCENT,
            self::VALUE_TOP_IMPRESSION_RATE_PERCENT,
            self::VALUE_BASE_CAMPAIGN_ID,
            self::VALUE_ALL_CONVERSIONS,
            self::VALUE_ALL_CONVERSION_RATE,
            self::VALUE_ALL_COST_PER_CONVERSION,
            self::VALUE_VIEW_THROUGH_CONVERSIONS,
            self::VALUE_GOAL,
            self::VALUE_GOAL_TYPE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
