<?php

namespace EnumType;

/**
 * This class stands for ReportTimePeriod EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReportTimePeriod
 * @subpackage Enumerations
 */
class ReportTimePeriod
{
    /**
     * Constant for value 'Today'
     * @return string 'Today'
     */
    const VALUE_TODAY = 'Today';
    /**
     * Constant for value 'Yesterday'
     * @return string 'Yesterday'
     */
    const VALUE_YESTERDAY = 'Yesterday';
    /**
     * Constant for value 'LastSevenDays'
     * @return string 'LastSevenDays'
     */
    const VALUE_LAST_SEVEN_DAYS = 'LastSevenDays';
    /**
     * Constant for value 'ThisWeek'
     * @return string 'ThisWeek'
     */
    const VALUE_THIS_WEEK = 'ThisWeek';
    /**
     * Constant for value 'LastWeek'
     * @return string 'LastWeek'
     */
    const VALUE_LAST_WEEK = 'LastWeek';
    /**
     * Constant for value 'Last14Days'
     * @return string 'Last14Days'
     */
    const VALUE_LAST_14_DAYS = 'Last14Days';
    /**
     * Constant for value 'Last30Days'
     * @return string 'Last30Days'
     */
    const VALUE_LAST_30_DAYS = 'Last30Days';
    /**
     * Constant for value 'LastFourWeeks'
     * @return string 'LastFourWeeks'
     */
    const VALUE_LAST_FOUR_WEEKS = 'LastFourWeeks';
    /**
     * Constant for value 'ThisMonth'
     * @return string 'ThisMonth'
     */
    const VALUE_THIS_MONTH = 'ThisMonth';
    /**
     * Constant for value 'LastMonth'
     * @return string 'LastMonth'
     */
    const VALUE_LAST_MONTH = 'LastMonth';
    /**
     * Constant for value 'LastThreeMonths'
     * @return string 'LastThreeMonths'
     */
    const VALUE_LAST_THREE_MONTHS = 'LastThreeMonths';
    /**
     * Constant for value 'LastSixMonths'
     * @return string 'LastSixMonths'
     */
    const VALUE_LAST_SIX_MONTHS = 'LastSixMonths';
    /**
     * Constant for value 'ThisYear'
     * @return string 'ThisYear'
     */
    const VALUE_THIS_YEAR = 'ThisYear';
    /**
     * Constant for value 'LastYear'
     * @return string 'LastYear'
     */
    const VALUE_LAST_YEAR = 'LastYear';
    /**
     * Constant for value 'ThisWeekStartingMonday'
     * @return string 'ThisWeekStartingMonday'
     */
    const VALUE_THIS_WEEK_STARTING_MONDAY = 'ThisWeekStartingMonday';
    /**
     * Constant for value 'LastWeekStartingMonday'
     * @return string 'LastWeekStartingMonday'
     */
    const VALUE_LAST_WEEK_STARTING_MONDAY = 'LastWeekStartingMonday';
    /**
     * Constant for value 'LastFourWeeksStartingMonday'
     * @return string 'LastFourWeeksStartingMonday'
     */
    const VALUE_LAST_FOUR_WEEKS_STARTING_MONDAY = 'LastFourWeeksStartingMonday';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TODAY
     * @uses self::VALUE_YESTERDAY
     * @uses self::VALUE_LAST_SEVEN_DAYS
     * @uses self::VALUE_THIS_WEEK
     * @uses self::VALUE_LAST_WEEK
     * @uses self::VALUE_LAST_14_DAYS
     * @uses self::VALUE_LAST_30_DAYS
     * @uses self::VALUE_LAST_FOUR_WEEKS
     * @uses self::VALUE_THIS_MONTH
     * @uses self::VALUE_LAST_MONTH
     * @uses self::VALUE_LAST_THREE_MONTHS
     * @uses self::VALUE_LAST_SIX_MONTHS
     * @uses self::VALUE_THIS_YEAR
     * @uses self::VALUE_LAST_YEAR
     * @uses self::VALUE_THIS_WEEK_STARTING_MONDAY
     * @uses self::VALUE_LAST_WEEK_STARTING_MONDAY
     * @uses self::VALUE_LAST_FOUR_WEEKS_STARTING_MONDAY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TODAY,
            self::VALUE_YESTERDAY,
            self::VALUE_LAST_SEVEN_DAYS,
            self::VALUE_THIS_WEEK,
            self::VALUE_LAST_WEEK,
            self::VALUE_LAST_14_DAYS,
            self::VALUE_LAST_30_DAYS,
            self::VALUE_LAST_FOUR_WEEKS,
            self::VALUE_THIS_MONTH,
            self::VALUE_LAST_MONTH,
            self::VALUE_LAST_THREE_MONTHS,
            self::VALUE_LAST_SIX_MONTHS,
            self::VALUE_THIS_YEAR,
            self::VALUE_LAST_YEAR,
            self::VALUE_THIS_WEEK_STARTING_MONDAY,
            self::VALUE_LAST_WEEK_STARTING_MONDAY,
            self::VALUE_LAST_FOUR_WEEKS_STARTING_MONDAY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
