<?php

namespace EnumType;

/**
 * This class stands for ReportAggregation EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReportAggregation
 * @subpackage Enumerations
 */
class ReportAggregation
{
    /**
     * Constant for value 'Summary'
     * @return string 'Summary'
     */
    const VALUE_SUMMARY = 'Summary';
    /**
     * Constant for value 'Hourly'
     * @return string 'Hourly'
     */
    const VALUE_HOURLY = 'Hourly';
    /**
     * Constant for value 'Daily'
     * @return string 'Daily'
     */
    const VALUE_DAILY = 'Daily';
    /**
     * Constant for value 'Weekly'
     * @return string 'Weekly'
     */
    const VALUE_WEEKLY = 'Weekly';
    /**
     * Constant for value 'Monthly'
     * @return string 'Monthly'
     */
    const VALUE_MONTHLY = 'Monthly';
    /**
     * Constant for value 'Yearly'
     * @return string 'Yearly'
     */
    const VALUE_YEARLY = 'Yearly';
    /**
     * Constant for value 'HourOfDay'
     * @return string 'HourOfDay'
     */
    const VALUE_HOUR_OF_DAY = 'HourOfDay';
    /**
     * Constant for value 'DayOfWeek'
     * @return string 'DayOfWeek'
     */
    const VALUE_DAY_OF_WEEK = 'DayOfWeek';
    /**
     * Constant for value 'WeeklyStartingMonday'
     * @return string 'WeeklyStartingMonday'
     */
    const VALUE_WEEKLY_STARTING_MONDAY = 'WeeklyStartingMonday';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUMMARY
     * @uses self::VALUE_HOURLY
     * @uses self::VALUE_DAILY
     * @uses self::VALUE_WEEKLY
     * @uses self::VALUE_MONTHLY
     * @uses self::VALUE_YEARLY
     * @uses self::VALUE_HOUR_OF_DAY
     * @uses self::VALUE_DAY_OF_WEEK
     * @uses self::VALUE_WEEKLY_STARTING_MONDAY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUMMARY,
            self::VALUE_HOURLY,
            self::VALUE_DAILY,
            self::VALUE_WEEKLY,
            self::VALUE_MONTHLY,
            self::VALUE_YEARLY,
            self::VALUE_HOUR_OF_DAY,
            self::VALUE_DAY_OF_WEEK,
            self::VALUE_WEEKLY_STARTING_MONDAY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
