<?php

namespace EnumType;

/**
 * This class stands for ProfessionalDemographicsAudienceReportColumn EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ProfessionalDemographicsAudienceReportColumn
 * @subpackage Enumerations
 */
class ProfessionalDemographicsAudienceReportColumn
{
    /**
     * Constant for value 'AccountName'
     * @return string 'AccountName'
     */
    const VALUE_ACCOUNT_NAME = 'AccountName';
    /**
     * Constant for value 'AccountNumber'
     * @return string 'AccountNumber'
     */
    const VALUE_ACCOUNT_NUMBER = 'AccountNumber';
    /**
     * Constant for value 'AccountId'
     * @return string 'AccountId'
     */
    const VALUE_ACCOUNT_ID = 'AccountId';
    /**
     * Constant for value 'TimePeriod'
     * @return string 'TimePeriod'
     */
    const VALUE_TIME_PERIOD = 'TimePeriod';
    /**
     * Constant for value 'CampaignName'
     * @return string 'CampaignName'
     */
    const VALUE_CAMPAIGN_NAME = 'CampaignName';
    /**
     * Constant for value 'CampaignId'
     * @return string 'CampaignId'
     */
    const VALUE_CAMPAIGN_ID = 'CampaignId';
    /**
     * Constant for value 'AdGroupName'
     * @return string 'AdGroupName'
     */
    const VALUE_AD_GROUP_NAME = 'AdGroupName';
    /**
     * Constant for value 'AdGroupId'
     * @return string 'AdGroupId'
     */
    const VALUE_AD_GROUP_ID = 'AdGroupId';
    /**
     * Constant for value 'CompanyName'
     * @return string 'CompanyName'
     */
    const VALUE_COMPANY_NAME = 'CompanyName';
    /**
     * Constant for value 'IndustryName'
     * @return string 'IndustryName'
     */
    const VALUE_INDUSTRY_NAME = 'IndustryName';
    /**
     * Constant for value 'JobFunctionName'
     * @return string 'JobFunctionName'
     */
    const VALUE_JOB_FUNCTION_NAME = 'JobFunctionName';
    /**
     * Constant for value 'AdDistribution'
     * @return string 'AdDistribution'
     */
    const VALUE_AD_DISTRIBUTION = 'AdDistribution';
    /**
     * Constant for value 'Impressions'
     * @return string 'Impressions'
     */
    const VALUE_IMPRESSIONS = 'Impressions';
    /**
     * Constant for value 'Clicks'
     * @return string 'Clicks'
     */
    const VALUE_CLICKS = 'Clicks';
    /**
     * Constant for value 'Spend'
     * @return string 'Spend'
     */
    const VALUE_SPEND = 'Spend';
    /**
     * Constant for value 'Conversions'
     * @return string 'Conversions'
     */
    const VALUE_CONVERSIONS = 'Conversions';
    /**
     * Constant for value 'Language'
     * @return string 'Language'
     */
    const VALUE_LANGUAGE = 'Language';
    /**
     * Constant for value 'Assists'
     * @return string 'Assists'
     */
    const VALUE_ASSISTS = 'Assists';
    /**
     * Constant for value 'Revenue'
     * @return string 'Revenue'
     */
    const VALUE_REVENUE = 'Revenue';
    /**
     * Constant for value 'AccountStatus'
     * @return string 'AccountStatus'
     */
    const VALUE_ACCOUNT_STATUS = 'AccountStatus';
    /**
     * Constant for value 'CampaignStatus'
     * @return string 'CampaignStatus'
     */
    const VALUE_CAMPAIGN_STATUS = 'CampaignStatus';
    /**
     * Constant for value 'AdGroupStatus'
     * @return string 'AdGroupStatus'
     */
    const VALUE_AD_GROUP_STATUS = 'AdGroupStatus';
    /**
     * Constant for value 'AveragePosition'
     * @return string 'AveragePosition'
     */
    const VALUE_AVERAGE_POSITION = 'AveragePosition';
    /**
     * Constant for value 'AllConversions'
     * @return string 'AllConversions'
     */
    const VALUE_ALL_CONVERSIONS = 'AllConversions';
    /**
     * Constant for value 'AllRevenue'
     * @return string 'AllRevenue'
     */
    const VALUE_ALL_REVENUE = 'AllRevenue';
    /**
     * Constant for value 'ViewThroughConversions'
     * @return string 'ViewThroughConversions'
     */
    const VALUE_VIEW_THROUGH_CONVERSIONS = 'ViewThroughConversions';
    /**
     * Constant for value 'Goal'
     * @return string 'Goal'
     */
    const VALUE_GOAL = 'Goal';
    /**
     * Constant for value 'GoalType'
     * @return string 'GoalType'
     */
    const VALUE_GOAL_TYPE = 'GoalType';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCOUNT_NAME
     * @uses self::VALUE_ACCOUNT_NUMBER
     * @uses self::VALUE_ACCOUNT_ID
     * @uses self::VALUE_TIME_PERIOD
     * @uses self::VALUE_CAMPAIGN_NAME
     * @uses self::VALUE_CAMPAIGN_ID
     * @uses self::VALUE_AD_GROUP_NAME
     * @uses self::VALUE_AD_GROUP_ID
     * @uses self::VALUE_COMPANY_NAME
     * @uses self::VALUE_INDUSTRY_NAME
     * @uses self::VALUE_JOB_FUNCTION_NAME
     * @uses self::VALUE_AD_DISTRIBUTION
     * @uses self::VALUE_IMPRESSIONS
     * @uses self::VALUE_CLICKS
     * @uses self::VALUE_SPEND
     * @uses self::VALUE_CONVERSIONS
     * @uses self::VALUE_LANGUAGE
     * @uses self::VALUE_ASSISTS
     * @uses self::VALUE_REVENUE
     * @uses self::VALUE_ACCOUNT_STATUS
     * @uses self::VALUE_CAMPAIGN_STATUS
     * @uses self::VALUE_AD_GROUP_STATUS
     * @uses self::VALUE_AVERAGE_POSITION
     * @uses self::VALUE_ALL_CONVERSIONS
     * @uses self::VALUE_ALL_REVENUE
     * @uses self::VALUE_VIEW_THROUGH_CONVERSIONS
     * @uses self::VALUE_GOAL
     * @uses self::VALUE_GOAL_TYPE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCOUNT_NAME,
            self::VALUE_ACCOUNT_NUMBER,
            self::VALUE_ACCOUNT_ID,
            self::VALUE_TIME_PERIOD,
            self::VALUE_CAMPAIGN_NAME,
            self::VALUE_CAMPAIGN_ID,
            self::VALUE_AD_GROUP_NAME,
            self::VALUE_AD_GROUP_ID,
            self::VALUE_COMPANY_NAME,
            self::VALUE_INDUSTRY_NAME,
            self::VALUE_JOB_FUNCTION_NAME,
            self::VALUE_AD_DISTRIBUTION,
            self::VALUE_IMPRESSIONS,
            self::VALUE_CLICKS,
            self::VALUE_SPEND,
            self::VALUE_CONVERSIONS,
            self::VALUE_LANGUAGE,
            self::VALUE_ASSISTS,
            self::VALUE_REVENUE,
            self::VALUE_ACCOUNT_STATUS,
            self::VALUE_CAMPAIGN_STATUS,
            self::VALUE_AD_GROUP_STATUS,
            self::VALUE_AVERAGE_POSITION,
            self::VALUE_ALL_CONVERSIONS,
            self::VALUE_ALL_REVENUE,
            self::VALUE_VIEW_THROUGH_CONVERSIONS,
            self::VALUE_GOAL,
            self::VALUE_GOAL_TYPE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
