<?php

namespace EnumType;

/**
 * This class stands for ProductNegativeKeywordConflictReportColumn EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ProductNegativeKeywordConflictReportColumn
 * @subpackage Enumerations
 */
class ProductNegativeKeywordConflictReportColumn
{
    /**
     * Constant for value 'AccountName'
     * @return string 'AccountName'
     */
    const VALUE_ACCOUNT_NAME = 'AccountName';
    /**
     * Constant for value 'AccountNumber'
     * @return string 'AccountNumber'
     */
    const VALUE_ACCOUNT_NUMBER = 'AccountNumber';
    /**
     * Constant for value 'AccountId'
     * @return string 'AccountId'
     */
    const VALUE_ACCOUNT_ID = 'AccountId';
    /**
     * Constant for value 'AccountStatus'
     * @return string 'AccountStatus'
     */
    const VALUE_ACCOUNT_STATUS = 'AccountStatus';
    /**
     * Constant for value 'CampaignName'
     * @return string 'CampaignName'
     */
    const VALUE_CAMPAIGN_NAME = 'CampaignName';
    /**
     * Constant for value 'CampaignId'
     * @return string 'CampaignId'
     */
    const VALUE_CAMPAIGN_ID = 'CampaignId';
    /**
     * Constant for value 'CampaignStatus'
     * @return string 'CampaignStatus'
     */
    const VALUE_CAMPAIGN_STATUS = 'CampaignStatus';
    /**
     * Constant for value 'AdGroupName'
     * @return string 'AdGroupName'
     */
    const VALUE_AD_GROUP_NAME = 'AdGroupName';
    /**
     * Constant for value 'AdGroupId'
     * @return string 'AdGroupId'
     */
    const VALUE_AD_GROUP_ID = 'AdGroupId';
    /**
     * Constant for value 'AdGroupStatus'
     * @return string 'AdGroupStatus'
     */
    const VALUE_AD_GROUP_STATUS = 'AdGroupStatus';
    /**
     * Constant for value 'MerchantProductId'
     * @return string 'MerchantProductId'
     */
    const VALUE_MERCHANT_PRODUCT_ID = 'MerchantProductId';
    /**
     * Constant for value 'Title'
     * @return string 'Title'
     */
    const VALUE_TITLE = 'Title';
    /**
     * Constant for value 'AdGroupCriterionId'
     * @return string 'AdGroupCriterionId'
     */
    const VALUE_AD_GROUP_CRITERION_ID = 'AdGroupCriterionId';
    /**
     * Constant for value 'ProductGroup'
     * @return string 'ProductGroup'
     */
    const VALUE_PRODUCT_GROUP = 'ProductGroup';
    /**
     * Constant for value 'NegativeKeywordId'
     * @return string 'NegativeKeywordId'
     */
    const VALUE_NEGATIVE_KEYWORD_ID = 'NegativeKeywordId';
    /**
     * Constant for value 'NegativeKeyword'
     * @return string 'NegativeKeyword'
     */
    const VALUE_NEGATIVE_KEYWORD = 'NegativeKeyword';
    /**
     * Constant for value 'NegativeKeywordListId'
     * @return string 'NegativeKeywordListId'
     */
    const VALUE_NEGATIVE_KEYWORD_LIST_ID = 'NegativeKeywordListId';
    /**
     * Constant for value 'ConflictLevel'
     * @return string 'ConflictLevel'
     */
    const VALUE_CONFLICT_LEVEL = 'ConflictLevel';
    /**
     * Constant for value 'NegativeKeywordMatchType'
     * @return string 'NegativeKeywordMatchType'
     */
    const VALUE_NEGATIVE_KEYWORD_MATCH_TYPE = 'NegativeKeywordMatchType';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCOUNT_NAME
     * @uses self::VALUE_ACCOUNT_NUMBER
     * @uses self::VALUE_ACCOUNT_ID
     * @uses self::VALUE_ACCOUNT_STATUS
     * @uses self::VALUE_CAMPAIGN_NAME
     * @uses self::VALUE_CAMPAIGN_ID
     * @uses self::VALUE_CAMPAIGN_STATUS
     * @uses self::VALUE_AD_GROUP_NAME
     * @uses self::VALUE_AD_GROUP_ID
     * @uses self::VALUE_AD_GROUP_STATUS
     * @uses self::VALUE_MERCHANT_PRODUCT_ID
     * @uses self::VALUE_TITLE
     * @uses self::VALUE_AD_GROUP_CRITERION_ID
     * @uses self::VALUE_PRODUCT_GROUP
     * @uses self::VALUE_NEGATIVE_KEYWORD_ID
     * @uses self::VALUE_NEGATIVE_KEYWORD
     * @uses self::VALUE_NEGATIVE_KEYWORD_LIST_ID
     * @uses self::VALUE_CONFLICT_LEVEL
     * @uses self::VALUE_NEGATIVE_KEYWORD_MATCH_TYPE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCOUNT_NAME,
            self::VALUE_ACCOUNT_NUMBER,
            self::VALUE_ACCOUNT_ID,
            self::VALUE_ACCOUNT_STATUS,
            self::VALUE_CAMPAIGN_NAME,
            self::VALUE_CAMPAIGN_ID,
            self::VALUE_CAMPAIGN_STATUS,
            self::VALUE_AD_GROUP_NAME,
            self::VALUE_AD_GROUP_ID,
            self::VALUE_AD_GROUP_STATUS,
            self::VALUE_MERCHANT_PRODUCT_ID,
            self::VALUE_TITLE,
            self::VALUE_AD_GROUP_CRITERION_ID,
            self::VALUE_PRODUCT_GROUP,
            self::VALUE_NEGATIVE_KEYWORD_ID,
            self::VALUE_NEGATIVE_KEYWORD,
            self::VALUE_NEGATIVE_KEYWORD_LIST_ID,
            self::VALUE_CONFLICT_LEVEL,
            self::VALUE_NEGATIVE_KEYWORD_MATCH_TYPE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
