<?php

namespace EnumType;

/**
 * This class stands for ProductMatchCountReportColumn EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ProductMatchCountReportColumn
 * @subpackage Enumerations
 */
class ProductMatchCountReportColumn
{
    /**
     * Constant for value 'CustomerId'
     * @return string 'CustomerId'
     */
    const VALUE_CUSTOMER_ID = 'CustomerId';
    /**
     * Constant for value 'CustomerName'
     * @return string 'CustomerName'
     */
    const VALUE_CUSTOMER_NAME = 'CustomerName';
    /**
     * Constant for value 'AccountId'
     * @return string 'AccountId'
     */
    const VALUE_ACCOUNT_ID = 'AccountId';
    /**
     * Constant for value 'AccountNumber'
     * @return string 'AccountNumber'
     */
    const VALUE_ACCOUNT_NUMBER = 'AccountNumber';
    /**
     * Constant for value 'AccountName'
     * @return string 'AccountName'
     */
    const VALUE_ACCOUNT_NAME = 'AccountName';
    /**
     * Constant for value 'CampaignId'
     * @return string 'CampaignId'
     */
    const VALUE_CAMPAIGN_ID = 'CampaignId';
    /**
     * Constant for value 'CampaignName'
     * @return string 'CampaignName'
     */
    const VALUE_CAMPAIGN_NAME = 'CampaignName';
    /**
     * Constant for value 'AdGroupId'
     * @return string 'AdGroupId'
     */
    const VALUE_AD_GROUP_ID = 'AdGroupId';
    /**
     * Constant for value 'AdGroupName'
     * @return string 'AdGroupName'
     */
    const VALUE_AD_GROUP_NAME = 'AdGroupName';
    /**
     * Constant for value 'ProductGroup'
     * @return string 'ProductGroup'
     */
    const VALUE_PRODUCT_GROUP = 'ProductGroup';
    /**
     * Constant for value 'PartitionType'
     * @return string 'PartitionType'
     */
    const VALUE_PARTITION_TYPE = 'PartitionType';
    /**
     * Constant for value 'AdGroupCriterionId'
     * @return string 'AdGroupCriterionId'
     */
    const VALUE_AD_GROUP_CRITERION_ID = 'AdGroupCriterionId';
    /**
     * Constant for value 'MatchedProductsAtCampaign'
     * @return string 'MatchedProductsAtCampaign'
     */
    const VALUE_MATCHED_PRODUCTS_AT_CAMPAIGN = 'MatchedProductsAtCampaign';
    /**
     * Constant for value 'MatchedProductsAtAdGroup'
     * @return string 'MatchedProductsAtAdGroup'
     */
    const VALUE_MATCHED_PRODUCTS_AT_AD_GROUP = 'MatchedProductsAtAdGroup';
    /**
     * Constant for value 'MatchedProductsAtProductGroup'
     * @return string 'MatchedProductsAtProductGroup'
     */
    const VALUE_MATCHED_PRODUCTS_AT_PRODUCT_GROUP = 'MatchedProductsAtProductGroup';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CUSTOMER_ID
     * @uses self::VALUE_CUSTOMER_NAME
     * @uses self::VALUE_ACCOUNT_ID
     * @uses self::VALUE_ACCOUNT_NUMBER
     * @uses self::VALUE_ACCOUNT_NAME
     * @uses self::VALUE_CAMPAIGN_ID
     * @uses self::VALUE_CAMPAIGN_NAME
     * @uses self::VALUE_AD_GROUP_ID
     * @uses self::VALUE_AD_GROUP_NAME
     * @uses self::VALUE_PRODUCT_GROUP
     * @uses self::VALUE_PARTITION_TYPE
     * @uses self::VALUE_AD_GROUP_CRITERION_ID
     * @uses self::VALUE_MATCHED_PRODUCTS_AT_CAMPAIGN
     * @uses self::VALUE_MATCHED_PRODUCTS_AT_AD_GROUP
     * @uses self::VALUE_MATCHED_PRODUCTS_AT_PRODUCT_GROUP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CUSTOMER_ID,
            self::VALUE_CUSTOMER_NAME,
            self::VALUE_ACCOUNT_ID,
            self::VALUE_ACCOUNT_NUMBER,
            self::VALUE_ACCOUNT_NAME,
            self::VALUE_CAMPAIGN_ID,
            self::VALUE_CAMPAIGN_NAME,
            self::VALUE_AD_GROUP_ID,
            self::VALUE_AD_GROUP_NAME,
            self::VALUE_PRODUCT_GROUP,
            self::VALUE_PARTITION_TYPE,
            self::VALUE_AD_GROUP_CRITERION_ID,
            self::VALUE_MATCHED_PRODUCTS_AT_CAMPAIGN,
            self::VALUE_MATCHED_PRODUCTS_AT_AD_GROUP,
            self::VALUE_MATCHED_PRODUCTS_AT_PRODUCT_GROUP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
