<?php

namespace EnumType;

/**
 * This class stands for CallDetailReportColumn EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CallDetailReportColumn
 * @subpackage Enumerations
 */
class CallDetailReportColumn
{
    /**
     * Constant for value 'AccountName'
     * @return string 'AccountName'
     */
    const VALUE_ACCOUNT_NAME = 'AccountName';
    /**
     * Constant for value 'CampaignName'
     * @return string 'CampaignName'
     */
    const VALUE_CAMPAIGN_NAME = 'CampaignName';
    /**
     * Constant for value 'AdGroupName'
     * @return string 'AdGroupName'
     */
    const VALUE_AD_GROUP_NAME = 'AdGroupName';
    /**
     * Constant for value 'StartTime'
     * @return string 'StartTime'
     */
    const VALUE_START_TIME = 'StartTime';
    /**
     * Constant for value 'EndTime'
     * @return string 'EndTime'
     */
    const VALUE_END_TIME = 'EndTime';
    /**
     * Constant for value 'Duration'
     * @return string 'Duration'
     */
    const VALUE_DURATION = 'Duration';
    /**
     * Constant for value 'AreaCode'
     * @return string 'AreaCode'
     */
    const VALUE_AREA_CODE = 'AreaCode';
    /**
     * Constant for value 'City'
     * @return string 'City'
     */
    const VALUE_CITY = 'City';
    /**
     * Constant for value 'State'
     * @return string 'State'
     */
    const VALUE_STATE = 'State';
    /**
     * Constant for value 'AccountId'
     * @return string 'AccountId'
     */
    const VALUE_ACCOUNT_ID = 'AccountId';
    /**
     * Constant for value 'CampaignId'
     * @return string 'CampaignId'
     */
    const VALUE_CAMPAIGN_ID = 'CampaignId';
    /**
     * Constant for value 'AdGroupId'
     * @return string 'AdGroupId'
     */
    const VALUE_AD_GROUP_ID = 'AdGroupId';
    /**
     * Constant for value 'AccountStatus'
     * @return string 'AccountStatus'
     */
    const VALUE_ACCOUNT_STATUS = 'AccountStatus';
    /**
     * Constant for value 'CampaignStatus'
     * @return string 'CampaignStatus'
     */
    const VALUE_CAMPAIGN_STATUS = 'CampaignStatus';
    /**
     * Constant for value 'AdGroupStatus'
     * @return string 'AdGroupStatus'
     */
    const VALUE_AD_GROUP_STATUS = 'AdGroupStatus';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCOUNT_NAME
     * @uses self::VALUE_CAMPAIGN_NAME
     * @uses self::VALUE_AD_GROUP_NAME
     * @uses self::VALUE_START_TIME
     * @uses self::VALUE_END_TIME
     * @uses self::VALUE_DURATION
     * @uses self::VALUE_AREA_CODE
     * @uses self::VALUE_CITY
     * @uses self::VALUE_STATE
     * @uses self::VALUE_ACCOUNT_ID
     * @uses self::VALUE_CAMPAIGN_ID
     * @uses self::VALUE_AD_GROUP_ID
     * @uses self::VALUE_ACCOUNT_STATUS
     * @uses self::VALUE_CAMPAIGN_STATUS
     * @uses self::VALUE_AD_GROUP_STATUS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCOUNT_NAME,
            self::VALUE_CAMPAIGN_NAME,
            self::VALUE_AD_GROUP_NAME,
            self::VALUE_START_TIME,
            self::VALUE_END_TIME,
            self::VALUE_DURATION,
            self::VALUE_AREA_CODE,
            self::VALUE_CITY,
            self::VALUE_STATE,
            self::VALUE_ACCOUNT_ID,
            self::VALUE_CAMPAIGN_ID,
            self::VALUE_AD_GROUP_ID,
            self::VALUE_ACCOUNT_STATUS,
            self::VALUE_CAMPAIGN_STATUS,
            self::VALUE_AD_GROUP_STATUS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
