<?php

namespace EnumType;

/**
 * This class stands for BudgetSummaryReportColumn EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BudgetSummaryReportColumn
 * @subpackage Enumerations
 */
class BudgetSummaryReportColumn
{
    /**
     * Constant for value 'AccountName'
     * @return string 'AccountName'
     */
    const VALUE_ACCOUNT_NAME = 'AccountName';
    /**
     * Constant for value 'AccountNumber'
     * @return string 'AccountNumber'
     */
    const VALUE_ACCOUNT_NUMBER = 'AccountNumber';
    /**
     * Constant for value 'AccountId'
     * @return string 'AccountId'
     */
    const VALUE_ACCOUNT_ID = 'AccountId';
    /**
     * Constant for value 'CampaignName'
     * @return string 'CampaignName'
     */
    const VALUE_CAMPAIGN_NAME = 'CampaignName';
    /**
     * Constant for value 'CampaignId'
     * @return string 'CampaignId'
     */
    const VALUE_CAMPAIGN_ID = 'CampaignId';
    /**
     * Constant for value 'Date'
     * @return string 'Date'
     */
    const VALUE_DATE = 'Date';
    /**
     * Constant for value 'CurrencyCode'
     * @return string 'CurrencyCode'
     */
    const VALUE_CURRENCY_CODE = 'CurrencyCode';
    /**
     * Constant for value 'MonthlyBudget'
     * @return string 'MonthlyBudget'
     */
    const VALUE_MONTHLY_BUDGET = 'MonthlyBudget';
    /**
     * Constant for value 'DailySpend'
     * @return string 'DailySpend'
     */
    const VALUE_DAILY_SPEND = 'DailySpend';
    /**
     * Constant for value 'MonthToDateSpend'
     * @return string 'MonthToDateSpend'
     */
    const VALUE_MONTH_TO_DATE_SPEND = 'MonthToDateSpend';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCOUNT_NAME
     * @uses self::VALUE_ACCOUNT_NUMBER
     * @uses self::VALUE_ACCOUNT_ID
     * @uses self::VALUE_CAMPAIGN_NAME
     * @uses self::VALUE_CAMPAIGN_ID
     * @uses self::VALUE_DATE
     * @uses self::VALUE_CURRENCY_CODE
     * @uses self::VALUE_MONTHLY_BUDGET
     * @uses self::VALUE_DAILY_SPEND
     * @uses self::VALUE_MONTH_TO_DATE_SPEND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCOUNT_NAME,
            self::VALUE_ACCOUNT_NUMBER,
            self::VALUE_ACCOUNT_ID,
            self::VALUE_CAMPAIGN_NAME,
            self::VALUE_CAMPAIGN_ID,
            self::VALUE_DATE,
            self::VALUE_CURRENCY_CODE,
            self::VALUE_MONTHLY_BUDGET,
            self::VALUE_DAILY_SPEND,
            self::VALUE_MONTH_TO_DATE_SPEND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
