<?php

namespace EnumType;

/**
 * This class stands for BidMatchTypeReportFilter EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BidMatchTypeReportFilter
 * @subpackage Enumerations
 */
class BidMatchTypeReportFilter
{
    /**
     * Constant for value 'Exact'
     * @return string 'Exact'
     */
    const VALUE_EXACT = 'Exact';
    /**
     * Constant for value 'Phrase'
     * @return string 'Phrase'
     */
    const VALUE_PHRASE = 'Phrase';
    /**
     * Constant for value 'Broad'
     * @return string 'Broad'
     */
    const VALUE_BROAD = 'Broad';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EXACT
     * @uses self::VALUE_PHRASE
     * @uses self::VALUE_BROAD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EXACT,
            self::VALUE_PHRASE,
            self::VALUE_BROAD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
