<?php

namespace EnumType;

/**
 * This class stands for AudiencePerformanceReportColumn EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AudiencePerformanceReportColumn
 * @subpackage Enumerations
 */
class AudiencePerformanceReportColumn
{
    /**
     * Constant for value 'AccountName'
     * @return string 'AccountName'
     */
    const VALUE_ACCOUNT_NAME = 'AccountName';
    /**
     * Constant for value 'AccountNumber'
     * @return string 'AccountNumber'
     */
    const VALUE_ACCOUNT_NUMBER = 'AccountNumber';
    /**
     * Constant for value 'AccountId'
     * @return string 'AccountId'
     */
    const VALUE_ACCOUNT_ID = 'AccountId';
    /**
     * Constant for value 'TimePeriod'
     * @return string 'TimePeriod'
     */
    const VALUE_TIME_PERIOD = 'TimePeriod';
    /**
     * Constant for value 'CampaignName'
     * @return string 'CampaignName'
     */
    const VALUE_CAMPAIGN_NAME = 'CampaignName';
    /**
     * Constant for value 'CampaignId'
     * @return string 'CampaignId'
     */
    const VALUE_CAMPAIGN_ID = 'CampaignId';
    /**
     * Constant for value 'AdGroupName'
     * @return string 'AdGroupName'
     */
    const VALUE_AD_GROUP_NAME = 'AdGroupName';
    /**
     * Constant for value 'AdGroupId'
     * @return string 'AdGroupId'
     */
    const VALUE_AD_GROUP_ID = 'AdGroupId';
    /**
     * Constant for value 'AudienceId'
     * @return string 'AudienceId'
     */
    const VALUE_AUDIENCE_ID = 'AudienceId';
    /**
     * Constant for value 'AudienceName'
     * @return string 'AudienceName'
     */
    const VALUE_AUDIENCE_NAME = 'AudienceName';
    /**
     * Constant for value 'AssociationStatus'
     * @return string 'AssociationStatus'
     */
    const VALUE_ASSOCIATION_STATUS = 'AssociationStatus';
    /**
     * Constant for value 'BidAdjustment'
     * @return string 'BidAdjustment'
     */
    const VALUE_BID_ADJUSTMENT = 'BidAdjustment';
    /**
     * Constant for value 'TargetingSetting'
     * @return string 'TargetingSetting'
     */
    const VALUE_TARGETING_SETTING = 'TargetingSetting';
    /**
     * Constant for value 'Impressions'
     * @return string 'Impressions'
     */
    const VALUE_IMPRESSIONS = 'Impressions';
    /**
     * Constant for value 'Clicks'
     * @return string 'Clicks'
     */
    const VALUE_CLICKS = 'Clicks';
    /**
     * Constant for value 'Ctr'
     * @return string 'Ctr'
     */
    const VALUE_CTR = 'Ctr';
    /**
     * Constant for value 'AverageCpc'
     * @return string 'AverageCpc'
     */
    const VALUE_AVERAGE_CPC = 'AverageCpc';
    /**
     * Constant for value 'Spend'
     * @return string 'Spend'
     */
    const VALUE_SPEND = 'Spend';
    /**
     * Constant for value 'AveragePosition'
     * @return string 'AveragePosition'
     */
    const VALUE_AVERAGE_POSITION = 'AveragePosition';
    /**
     * Constant for value 'Conversions'
     * @return string 'Conversions'
     */
    const VALUE_CONVERSIONS = 'Conversions';
    /**
     * Constant for value 'ConversionRate'
     * @return string 'ConversionRate'
     */
    const VALUE_CONVERSION_RATE = 'ConversionRate';
    /**
     * Constant for value 'CostPerConversion'
     * @return string 'CostPerConversion'
     */
    const VALUE_COST_PER_CONVERSION = 'CostPerConversion';
    /**
     * Constant for value 'Revenue'
     * @return string 'Revenue'
     */
    const VALUE_REVENUE = 'Revenue';
    /**
     * Constant for value 'ReturnOnAdSpend'
     * @return string 'ReturnOnAdSpend'
     */
    const VALUE_RETURN_ON_AD_SPEND = 'ReturnOnAdSpend';
    /**
     * Constant for value 'RevenuePerConversion'
     * @return string 'RevenuePerConversion'
     */
    const VALUE_REVENUE_PER_CONVERSION = 'RevenuePerConversion';
    /**
     * Constant for value 'AccountStatus'
     * @return string 'AccountStatus'
     */
    const VALUE_ACCOUNT_STATUS = 'AccountStatus';
    /**
     * Constant for value 'CampaignStatus'
     * @return string 'CampaignStatus'
     */
    const VALUE_CAMPAIGN_STATUS = 'CampaignStatus';
    /**
     * Constant for value 'AdGroupStatus'
     * @return string 'AdGroupStatus'
     */
    const VALUE_AD_GROUP_STATUS = 'AdGroupStatus';
    /**
     * Constant for value 'AudienceType'
     * @return string 'AudienceType'
     */
    const VALUE_AUDIENCE_TYPE = 'AudienceType';
    /**
     * Constant for value 'BaseCampaignId'
     * @return string 'BaseCampaignId'
     */
    const VALUE_BASE_CAMPAIGN_ID = 'BaseCampaignId';
    /**
     * Constant for value 'AllConversions'
     * @return string 'AllConversions'
     */
    const VALUE_ALL_CONVERSIONS = 'AllConversions';
    /**
     * Constant for value 'AllRevenue'
     * @return string 'AllRevenue'
     */
    const VALUE_ALL_REVENUE = 'AllRevenue';
    /**
     * Constant for value 'AllConversionRate'
     * @return string 'AllConversionRate'
     */
    const VALUE_ALL_CONVERSION_RATE = 'AllConversionRate';
    /**
     * Constant for value 'AllCostPerConversion'
     * @return string 'AllCostPerConversion'
     */
    const VALUE_ALL_COST_PER_CONVERSION = 'AllCostPerConversion';
    /**
     * Constant for value 'AllReturnOnAdSpend'
     * @return string 'AllReturnOnAdSpend'
     */
    const VALUE_ALL_RETURN_ON_AD_SPEND = 'AllReturnOnAdSpend';
    /**
     * Constant for value 'AllRevenuePerConversion'
     * @return string 'AllRevenuePerConversion'
     */
    const VALUE_ALL_REVENUE_PER_CONVERSION = 'AllRevenuePerConversion';
    /**
     * Constant for value 'AssociationId'
     * @return string 'AssociationId'
     */
    const VALUE_ASSOCIATION_ID = 'AssociationId';
    /**
     * Constant for value 'AssociationLevel'
     * @return string 'AssociationLevel'
     */
    const VALUE_ASSOCIATION_LEVEL = 'AssociationLevel';
    /**
     * Constant for value 'ViewThroughConversions'
     * @return string 'ViewThroughConversions'
     */
    const VALUE_VIEW_THROUGH_CONVERSIONS = 'ViewThroughConversions';
    /**
     * Constant for value 'Goal'
     * @return string 'Goal'
     */
    const VALUE_GOAL = 'Goal';
    /**
     * Constant for value 'GoalType'
     * @return string 'GoalType'
     */
    const VALUE_GOAL_TYPE = 'GoalType';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCOUNT_NAME
     * @uses self::VALUE_ACCOUNT_NUMBER
     * @uses self::VALUE_ACCOUNT_ID
     * @uses self::VALUE_TIME_PERIOD
     * @uses self::VALUE_CAMPAIGN_NAME
     * @uses self::VALUE_CAMPAIGN_ID
     * @uses self::VALUE_AD_GROUP_NAME
     * @uses self::VALUE_AD_GROUP_ID
     * @uses self::VALUE_AUDIENCE_ID
     * @uses self::VALUE_AUDIENCE_NAME
     * @uses self::VALUE_ASSOCIATION_STATUS
     * @uses self::VALUE_BID_ADJUSTMENT
     * @uses self::VALUE_TARGETING_SETTING
     * @uses self::VALUE_IMPRESSIONS
     * @uses self::VALUE_CLICKS
     * @uses self::VALUE_CTR
     * @uses self::VALUE_AVERAGE_CPC
     * @uses self::VALUE_SPEND
     * @uses self::VALUE_AVERAGE_POSITION
     * @uses self::VALUE_CONVERSIONS
     * @uses self::VALUE_CONVERSION_RATE
     * @uses self::VALUE_COST_PER_CONVERSION
     * @uses self::VALUE_REVENUE
     * @uses self::VALUE_RETURN_ON_AD_SPEND
     * @uses self::VALUE_REVENUE_PER_CONVERSION
     * @uses self::VALUE_ACCOUNT_STATUS
     * @uses self::VALUE_CAMPAIGN_STATUS
     * @uses self::VALUE_AD_GROUP_STATUS
     * @uses self::VALUE_AUDIENCE_TYPE
     * @uses self::VALUE_BASE_CAMPAIGN_ID
     * @uses self::VALUE_ALL_CONVERSIONS
     * @uses self::VALUE_ALL_REVENUE
     * @uses self::VALUE_ALL_CONVERSION_RATE
     * @uses self::VALUE_ALL_COST_PER_CONVERSION
     * @uses self::VALUE_ALL_RETURN_ON_AD_SPEND
     * @uses self::VALUE_ALL_REVENUE_PER_CONVERSION
     * @uses self::VALUE_ASSOCIATION_ID
     * @uses self::VALUE_ASSOCIATION_LEVEL
     * @uses self::VALUE_VIEW_THROUGH_CONVERSIONS
     * @uses self::VALUE_GOAL
     * @uses self::VALUE_GOAL_TYPE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCOUNT_NAME,
            self::VALUE_ACCOUNT_NUMBER,
            self::VALUE_ACCOUNT_ID,
            self::VALUE_TIME_PERIOD,
            self::VALUE_CAMPAIGN_NAME,
            self::VALUE_CAMPAIGN_ID,
            self::VALUE_AD_GROUP_NAME,
            self::VALUE_AD_GROUP_ID,
            self::VALUE_AUDIENCE_ID,
            self::VALUE_AUDIENCE_NAME,
            self::VALUE_ASSOCIATION_STATUS,
            self::VALUE_BID_ADJUSTMENT,
            self::VALUE_TARGETING_SETTING,
            self::VALUE_IMPRESSIONS,
            self::VALUE_CLICKS,
            self::VALUE_CTR,
            self::VALUE_AVERAGE_CPC,
            self::VALUE_SPEND,
            self::VALUE_AVERAGE_POSITION,
            self::VALUE_CONVERSIONS,
            self::VALUE_CONVERSION_RATE,
            self::VALUE_COST_PER_CONVERSION,
            self::VALUE_REVENUE,
            self::VALUE_RETURN_ON_AD_SPEND,
            self::VALUE_REVENUE_PER_CONVERSION,
            self::VALUE_ACCOUNT_STATUS,
            self::VALUE_CAMPAIGN_STATUS,
            self::VALUE_AD_GROUP_STATUS,
            self::VALUE_AUDIENCE_TYPE,
            self::VALUE_BASE_CAMPAIGN_ID,
            self::VALUE_ALL_CONVERSIONS,
            self::VALUE_ALL_REVENUE,
            self::VALUE_ALL_CONVERSION_RATE,
            self::VALUE_ALL_COST_PER_CONVERSION,
            self::VALUE_ALL_RETURN_ON_AD_SPEND,
            self::VALUE_ALL_REVENUE_PER_CONVERSION,
            self::VALUE_ASSOCIATION_ID,
            self::VALUE_ASSOCIATION_LEVEL,
            self::VALUE_VIEW_THROUGH_CONVERSIONS,
            self::VALUE_GOAL,
            self::VALUE_GOAL_TYPE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
