<?php

namespace EnumType;

/**
 * This class stands for AccountPerformanceReportColumn EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AccountPerformanceReportColumn
 * @subpackage Enumerations
 */
class AccountPerformanceReportColumn
{
    /**
     * Constant for value 'AccountName'
     * @return string 'AccountName'
     */
    const VALUE_ACCOUNT_NAME = 'AccountName';
    /**
     * Constant for value 'AccountNumber'
     * @return string 'AccountNumber'
     */
    const VALUE_ACCOUNT_NUMBER = 'AccountNumber';
    /**
     * Constant for value 'AccountId'
     * @return string 'AccountId'
     */
    const VALUE_ACCOUNT_ID = 'AccountId';
    /**
     * Constant for value 'TimePeriod'
     * @return string 'TimePeriod'
     */
    const VALUE_TIME_PERIOD = 'TimePeriod';
    /**
     * Constant for value 'CurrencyCode'
     * @return string 'CurrencyCode'
     */
    const VALUE_CURRENCY_CODE = 'CurrencyCode';
    /**
     * Constant for value 'AdDistribution'
     * @return string 'AdDistribution'
     */
    const VALUE_AD_DISTRIBUTION = 'AdDistribution';
    /**
     * Constant for value 'Impressions'
     * @return string 'Impressions'
     */
    const VALUE_IMPRESSIONS = 'Impressions';
    /**
     * Constant for value 'Clicks'
     * @return string 'Clicks'
     */
    const VALUE_CLICKS = 'Clicks';
    /**
     * Constant for value 'Ctr'
     * @return string 'Ctr'
     */
    const VALUE_CTR = 'Ctr';
    /**
     * Constant for value 'AverageCpc'
     * @return string 'AverageCpc'
     */
    const VALUE_AVERAGE_CPC = 'AverageCpc';
    /**
     * Constant for value 'Spend'
     * @return string 'Spend'
     */
    const VALUE_SPEND = 'Spend';
    /**
     * Constant for value 'AveragePosition'
     * @return string 'AveragePosition'
     */
    const VALUE_AVERAGE_POSITION = 'AveragePosition';
    /**
     * Constant for value 'Conversions'
     * @return string 'Conversions'
     */
    const VALUE_CONVERSIONS = 'Conversions';
    /**
     * Constant for value 'ConversionRate'
     * @return string 'ConversionRate'
     */
    const VALUE_CONVERSION_RATE = 'ConversionRate';
    /**
     * Constant for value 'CostPerConversion'
     * @return string 'CostPerConversion'
     */
    const VALUE_COST_PER_CONVERSION = 'CostPerConversion';
    /**
     * Constant for value 'LowQualityClicks'
     * @return string 'LowQualityClicks'
     */
    const VALUE_LOW_QUALITY_CLICKS = 'LowQualityClicks';
    /**
     * Constant for value 'LowQualityClicksPercent'
     * @return string 'LowQualityClicksPercent'
     */
    const VALUE_LOW_QUALITY_CLICKS_PERCENT = 'LowQualityClicksPercent';
    /**
     * Constant for value 'LowQualityImpressions'
     * @return string 'LowQualityImpressions'
     */
    const VALUE_LOW_QUALITY_IMPRESSIONS = 'LowQualityImpressions';
    /**
     * Constant for value 'LowQualityImpressionsPercent'
     * @return string 'LowQualityImpressionsPercent'
     */
    const VALUE_LOW_QUALITY_IMPRESSIONS_PERCENT = 'LowQualityImpressionsPercent';
    /**
     * Constant for value 'LowQualityConversions'
     * @return string 'LowQualityConversions'
     */
    const VALUE_LOW_QUALITY_CONVERSIONS = 'LowQualityConversions';
    /**
     * Constant for value 'LowQualityConversionRate'
     * @return string 'LowQualityConversionRate'
     */
    const VALUE_LOW_QUALITY_CONVERSION_RATE = 'LowQualityConversionRate';
    /**
     * Constant for value 'DeviceType'
     * @return string 'DeviceType'
     */
    const VALUE_DEVICE_TYPE = 'DeviceType';
    /**
     * Constant for value 'DeviceOS'
     * @return string 'DeviceOS'
     */
    const VALUE_DEVICE_OS = 'DeviceOS';
    /**
     * Constant for value 'ImpressionSharePercent'
     * @return string 'ImpressionSharePercent'
     */
    const VALUE_IMPRESSION_SHARE_PERCENT = 'ImpressionSharePercent';
    /**
     * Constant for value 'ImpressionLostToBudgetPercent'
     * @return string 'ImpressionLostToBudgetPercent'
     */
    const VALUE_IMPRESSION_LOST_TO_BUDGET_PERCENT = 'ImpressionLostToBudgetPercent';
    /**
     * Constant for value 'ImpressionLostToRankAggPercent'
     * @return string 'ImpressionLostToRankAggPercent'
     */
    const VALUE_IMPRESSION_LOST_TO_RANK_AGG_PERCENT = 'ImpressionLostToRankAggPercent';
    /**
     * Constant for value 'PhoneImpressions'
     * @return string 'PhoneImpressions'
     */
    const VALUE_PHONE_IMPRESSIONS = 'PhoneImpressions';
    /**
     * Constant for value 'PhoneCalls'
     * @return string 'PhoneCalls'
     */
    const VALUE_PHONE_CALLS = 'PhoneCalls';
    /**
     * Constant for value 'Ptr'
     * @return string 'Ptr'
     */
    const VALUE_PTR = 'Ptr';
    /**
     * Constant for value 'Network'
     * @return string 'Network'
     */
    const VALUE_NETWORK = 'Network';
    /**
     * Constant for value 'TopVsOther'
     * @return string 'TopVsOther'
     */
    const VALUE_TOP_VS_OTHER = 'TopVsOther';
    /**
     * Constant for value 'BidMatchType'
     * @return string 'BidMatchType'
     */
    const VALUE_BID_MATCH_TYPE = 'BidMatchType';
    /**
     * Constant for value 'DeliveredMatchType'
     * @return string 'DeliveredMatchType'
     */
    const VALUE_DELIVERED_MATCH_TYPE = 'DeliveredMatchType';
    /**
     * Constant for value 'Assists'
     * @return string 'Assists'
     */
    const VALUE_ASSISTS = 'Assists';
    /**
     * Constant for value 'Revenue'
     * @return string 'Revenue'
     */
    const VALUE_REVENUE = 'Revenue';
    /**
     * Constant for value 'ReturnOnAdSpend'
     * @return string 'ReturnOnAdSpend'
     */
    const VALUE_RETURN_ON_AD_SPEND = 'ReturnOnAdSpend';
    /**
     * Constant for value 'CostPerAssist'
     * @return string 'CostPerAssist'
     */
    const VALUE_COST_PER_ASSIST = 'CostPerAssist';
    /**
     * Constant for value 'RevenuePerConversion'
     * @return string 'RevenuePerConversion'
     */
    const VALUE_REVENUE_PER_CONVERSION = 'RevenuePerConversion';
    /**
     * Constant for value 'RevenuePerAssist'
     * @return string 'RevenuePerAssist'
     */
    const VALUE_REVENUE_PER_ASSIST = 'RevenuePerAssist';
    /**
     * Constant for value 'AccountStatus'
     * @return string 'AccountStatus'
     */
    const VALUE_ACCOUNT_STATUS = 'AccountStatus';
    /**
     * Constant for value 'LowQualityGeneralClicks'
     * @return string 'LowQualityGeneralClicks'
     */
    const VALUE_LOW_QUALITY_GENERAL_CLICKS = 'LowQualityGeneralClicks';
    /**
     * Constant for value 'LowQualitySophisticatedClicks'
     * @return string 'LowQualitySophisticatedClicks'
     */
    const VALUE_LOW_QUALITY_SOPHISTICATED_CLICKS = 'LowQualitySophisticatedClicks';
    /**
     * Constant for value 'ExactMatchImpressionSharePercent'
     * @return string 'ExactMatchImpressionSharePercent'
     */
    const VALUE_EXACT_MATCH_IMPRESSION_SHARE_PERCENT = 'ExactMatchImpressionSharePercent';
    /**
     * Constant for value 'CustomerId'
     * @return string 'CustomerId'
     */
    const VALUE_CUSTOMER_ID = 'CustomerId';
    /**
     * Constant for value 'CustomerName'
     * @return string 'CustomerName'
     */
    const VALUE_CUSTOMER_NAME = 'CustomerName';
    /**
     * Constant for value 'ClickSharePercent'
     * @return string 'ClickSharePercent'
     */
    const VALUE_CLICK_SHARE_PERCENT = 'ClickSharePercent';
    /**
     * Constant for value 'AbsoluteTopImpressionSharePercent'
     * @return string 'AbsoluteTopImpressionSharePercent'
     */
    const VALUE_ABSOLUTE_TOP_IMPRESSION_SHARE_PERCENT = 'AbsoluteTopImpressionSharePercent';
    /**
     * Constant for value 'TopImpressionShareLostToRankPercent'
     * @return string 'TopImpressionShareLostToRankPercent'
     */
    const VALUE_TOP_IMPRESSION_SHARE_LOST_TO_RANK_PERCENT = 'TopImpressionShareLostToRankPercent';
    /**
     * Constant for value 'TopImpressionShareLostToBudgetPercent'
     * @return string 'TopImpressionShareLostToBudgetPercent'
     */
    const VALUE_TOP_IMPRESSION_SHARE_LOST_TO_BUDGET_PERCENT = 'TopImpressionShareLostToBudgetPercent';
    /**
     * Constant for value 'AbsoluteTopImpressionShareLostToRankPercent'
     * @return string 'AbsoluteTopImpressionShareLostToRankPercent'
     */
    const VALUE_ABSOLUTE_TOP_IMPRESSION_SHARE_LOST_TO_RANK_PERCENT = 'AbsoluteTopImpressionShareLostToRankPercent';
    /**
     * Constant for value 'AbsoluteTopImpressionShareLostToBudgetPercent'
     * @return string 'AbsoluteTopImpressionShareLostToBudgetPercent'
     */
    const VALUE_ABSOLUTE_TOP_IMPRESSION_SHARE_LOST_TO_BUDGET_PERCENT = 'AbsoluteTopImpressionShareLostToBudgetPercent';
    /**
     * Constant for value 'TopImpressionSharePercent'
     * @return string 'TopImpressionSharePercent'
     */
    const VALUE_TOP_IMPRESSION_SHARE_PERCENT = 'TopImpressionSharePercent';
    /**
     * Constant for value 'AbsoluteTopImpressionRatePercent'
     * @return string 'AbsoluteTopImpressionRatePercent'
     */
    const VALUE_ABSOLUTE_TOP_IMPRESSION_RATE_PERCENT = 'AbsoluteTopImpressionRatePercent';
    /**
     * Constant for value 'TopImpressionRatePercent'
     * @return string 'TopImpressionRatePercent'
     */
    const VALUE_TOP_IMPRESSION_RATE_PERCENT = 'TopImpressionRatePercent';
    /**
     * Constant for value 'AllConversions'
     * @return string 'AllConversions'
     */
    const VALUE_ALL_CONVERSIONS = 'AllConversions';
    /**
     * Constant for value 'AllRevenue'
     * @return string 'AllRevenue'
     */
    const VALUE_ALL_REVENUE = 'AllRevenue';
    /**
     * Constant for value 'AllConversionRate'
     * @return string 'AllConversionRate'
     */
    const VALUE_ALL_CONVERSION_RATE = 'AllConversionRate';
    /**
     * Constant for value 'AllCostPerConversion'
     * @return string 'AllCostPerConversion'
     */
    const VALUE_ALL_COST_PER_CONVERSION = 'AllCostPerConversion';
    /**
     * Constant for value 'AllReturnOnAdSpend'
     * @return string 'AllReturnOnAdSpend'
     */
    const VALUE_ALL_RETURN_ON_AD_SPEND = 'AllReturnOnAdSpend';
    /**
     * Constant for value 'AllRevenuePerConversion'
     * @return string 'AllRevenuePerConversion'
     */
    const VALUE_ALL_REVENUE_PER_CONVERSION = 'AllRevenuePerConversion';
    /**
     * Constant for value 'ViewThroughConversions'
     * @return string 'ViewThroughConversions'
     */
    const VALUE_VIEW_THROUGH_CONVERSIONS = 'ViewThroughConversions';
    /**
     * Constant for value 'Goal'
     * @return string 'Goal'
     */
    const VALUE_GOAL = 'Goal';
    /**
     * Constant for value 'GoalType'
     * @return string 'GoalType'
     */
    const VALUE_GOAL_TYPE = 'GoalType';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCOUNT_NAME
     * @uses self::VALUE_ACCOUNT_NUMBER
     * @uses self::VALUE_ACCOUNT_ID
     * @uses self::VALUE_TIME_PERIOD
     * @uses self::VALUE_CURRENCY_CODE
     * @uses self::VALUE_AD_DISTRIBUTION
     * @uses self::VALUE_IMPRESSIONS
     * @uses self::VALUE_CLICKS
     * @uses self::VALUE_CTR
     * @uses self::VALUE_AVERAGE_CPC
     * @uses self::VALUE_SPEND
     * @uses self::VALUE_AVERAGE_POSITION
     * @uses self::VALUE_CONVERSIONS
     * @uses self::VALUE_CONVERSION_RATE
     * @uses self::VALUE_COST_PER_CONVERSION
     * @uses self::VALUE_LOW_QUALITY_CLICKS
     * @uses self::VALUE_LOW_QUALITY_CLICKS_PERCENT
     * @uses self::VALUE_LOW_QUALITY_IMPRESSIONS
     * @uses self::VALUE_LOW_QUALITY_IMPRESSIONS_PERCENT
     * @uses self::VALUE_LOW_QUALITY_CONVERSIONS
     * @uses self::VALUE_LOW_QUALITY_CONVERSION_RATE
     * @uses self::VALUE_DEVICE_TYPE
     * @uses self::VALUE_DEVICE_OS
     * @uses self::VALUE_IMPRESSION_SHARE_PERCENT
     * @uses self::VALUE_IMPRESSION_LOST_TO_BUDGET_PERCENT
     * @uses self::VALUE_IMPRESSION_LOST_TO_RANK_AGG_PERCENT
     * @uses self::VALUE_PHONE_IMPRESSIONS
     * @uses self::VALUE_PHONE_CALLS
     * @uses self::VALUE_PTR
     * @uses self::VALUE_NETWORK
     * @uses self::VALUE_TOP_VS_OTHER
     * @uses self::VALUE_BID_MATCH_TYPE
     * @uses self::VALUE_DELIVERED_MATCH_TYPE
     * @uses self::VALUE_ASSISTS
     * @uses self::VALUE_REVENUE
     * @uses self::VALUE_RETURN_ON_AD_SPEND
     * @uses self::VALUE_COST_PER_ASSIST
     * @uses self::VALUE_REVENUE_PER_CONVERSION
     * @uses self::VALUE_REVENUE_PER_ASSIST
     * @uses self::VALUE_ACCOUNT_STATUS
     * @uses self::VALUE_LOW_QUALITY_GENERAL_CLICKS
     * @uses self::VALUE_LOW_QUALITY_SOPHISTICATED_CLICKS
     * @uses self::VALUE_EXACT_MATCH_IMPRESSION_SHARE_PERCENT
     * @uses self::VALUE_CUSTOMER_ID
     * @uses self::VALUE_CUSTOMER_NAME
     * @uses self::VALUE_CLICK_SHARE_PERCENT
     * @uses self::VALUE_ABSOLUTE_TOP_IMPRESSION_SHARE_PERCENT
     * @uses self::VALUE_TOP_IMPRESSION_SHARE_LOST_TO_RANK_PERCENT
     * @uses self::VALUE_TOP_IMPRESSION_SHARE_LOST_TO_BUDGET_PERCENT
     * @uses self::VALUE_ABSOLUTE_TOP_IMPRESSION_SHARE_LOST_TO_RANK_PERCENT
     * @uses self::VALUE_ABSOLUTE_TOP_IMPRESSION_SHARE_LOST_TO_BUDGET_PERCENT
     * @uses self::VALUE_TOP_IMPRESSION_SHARE_PERCENT
     * @uses self::VALUE_ABSOLUTE_TOP_IMPRESSION_RATE_PERCENT
     * @uses self::VALUE_TOP_IMPRESSION_RATE_PERCENT
     * @uses self::VALUE_ALL_CONVERSIONS
     * @uses self::VALUE_ALL_REVENUE
     * @uses self::VALUE_ALL_CONVERSION_RATE
     * @uses self::VALUE_ALL_COST_PER_CONVERSION
     * @uses self::VALUE_ALL_RETURN_ON_AD_SPEND
     * @uses self::VALUE_ALL_REVENUE_PER_CONVERSION
     * @uses self::VALUE_VIEW_THROUGH_CONVERSIONS
     * @uses self::VALUE_GOAL
     * @uses self::VALUE_GOAL_TYPE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCOUNT_NAME,
            self::VALUE_ACCOUNT_NUMBER,
            self::VALUE_ACCOUNT_ID,
            self::VALUE_TIME_PERIOD,
            self::VALUE_CURRENCY_CODE,
            self::VALUE_AD_DISTRIBUTION,
            self::VALUE_IMPRESSIONS,
            self::VALUE_CLICKS,
            self::VALUE_CTR,
            self::VALUE_AVERAGE_CPC,
            self::VALUE_SPEND,
            self::VALUE_AVERAGE_POSITION,
            self::VALUE_CONVERSIONS,
            self::VALUE_CONVERSION_RATE,
            self::VALUE_COST_PER_CONVERSION,
            self::VALUE_LOW_QUALITY_CLICKS,
            self::VALUE_LOW_QUALITY_CLICKS_PERCENT,
            self::VALUE_LOW_QUALITY_IMPRESSIONS,
            self::VALUE_LOW_QUALITY_IMPRESSIONS_PERCENT,
            self::VALUE_LOW_QUALITY_CONVERSIONS,
            self::VALUE_LOW_QUALITY_CONVERSION_RATE,
            self::VALUE_DEVICE_TYPE,
            self::VALUE_DEVICE_OS,
            self::VALUE_IMPRESSION_SHARE_PERCENT,
            self::VALUE_IMPRESSION_LOST_TO_BUDGET_PERCENT,
            self::VALUE_IMPRESSION_LOST_TO_RANK_AGG_PERCENT,
            self::VALUE_PHONE_IMPRESSIONS,
            self::VALUE_PHONE_CALLS,
            self::VALUE_PTR,
            self::VALUE_NETWORK,
            self::VALUE_TOP_VS_OTHER,
            self::VALUE_BID_MATCH_TYPE,
            self::VALUE_DELIVERED_MATCH_TYPE,
            self::VALUE_ASSISTS,
            self::VALUE_REVENUE,
            self::VALUE_RETURN_ON_AD_SPEND,
            self::VALUE_COST_PER_ASSIST,
            self::VALUE_REVENUE_PER_CONVERSION,
            self::VALUE_REVENUE_PER_ASSIST,
            self::VALUE_ACCOUNT_STATUS,
            self::VALUE_LOW_QUALITY_GENERAL_CLICKS,
            self::VALUE_LOW_QUALITY_SOPHISTICATED_CLICKS,
            self::VALUE_EXACT_MATCH_IMPRESSION_SHARE_PERCENT,
            self::VALUE_CUSTOMER_ID,
            self::VALUE_CUSTOMER_NAME,
            self::VALUE_CLICK_SHARE_PERCENT,
            self::VALUE_ABSOLUTE_TOP_IMPRESSION_SHARE_PERCENT,
            self::VALUE_TOP_IMPRESSION_SHARE_LOST_TO_RANK_PERCENT,
            self::VALUE_TOP_IMPRESSION_SHARE_LOST_TO_BUDGET_PERCENT,
            self::VALUE_ABSOLUTE_TOP_IMPRESSION_SHARE_LOST_TO_RANK_PERCENT,
            self::VALUE_ABSOLUTE_TOP_IMPRESSION_SHARE_LOST_TO_BUDGET_PERCENT,
            self::VALUE_TOP_IMPRESSION_SHARE_PERCENT,
            self::VALUE_ABSOLUTE_TOP_IMPRESSION_RATE_PERCENT,
            self::VALUE_TOP_IMPRESSION_RATE_PERCENT,
            self::VALUE_ALL_CONVERSIONS,
            self::VALUE_ALL_REVENUE,
            self::VALUE_ALL_CONVERSION_RATE,
            self::VALUE_ALL_COST_PER_CONVERSION,
            self::VALUE_ALL_RETURN_ON_AD_SPEND,
            self::VALUE_ALL_REVENUE_PER_CONVERSION,
            self::VALUE_VIEW_THROUGH_CONVERSIONS,
            self::VALUE_GOAL,
            self::VALUE_GOAL_TYPE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
