<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserLocationPerformanceReportFilter StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UserLocationPerformanceReportFilter
 * @subpackage Structs
 */
class UserLocationPerformanceReportFilter extends AbstractStructBase
{
    /**
     * The AdDistribution
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AdDistribution;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $CountryCode;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $Language;
    /**
     * Constructor method for UserLocationPerformanceReportFilter
     * @uses UserLocationPerformanceReportFilter::setAdDistribution()
     * @uses UserLocationPerformanceReportFilter::setCountryCode()
     * @uses UserLocationPerformanceReportFilter::setLanguage()
     * @param string[] $adDistribution
     * @param \ArrayType\ArrayOfstring $countryCode
     * @param string[] $language
     */
    public function __construct(array $adDistribution = array(), \ArrayType\ArrayOfstring $countryCode = null, array $language = array())
    {
        $this
            ->setAdDistribution($adDistribution)
            ->setCountryCode($countryCode)
            ->setLanguage($language);
    }
    /**
     * Get AdDistribution value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdDistribution()
    {
        return isset($this->AdDistribution) ? $this->AdDistribution : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdDistribution method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdDistribution method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdDistributionForArrayConstraintsFromSetAdDistribution(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $userLocationPerformanceReportFilterAdDistributionItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdDistributionReportFilter::valueIsValid($userLocationPerformanceReportFilterAdDistributionItem)) {
                $invalidValues[] = is_object($userLocationPerformanceReportFilterAdDistributionItem) ? get_class($userLocationPerformanceReportFilterAdDistributionItem) : sprintf('%s(%s)', gettype($userLocationPerformanceReportFilterAdDistributionItem), var_export($userLocationPerformanceReportFilterAdDistributionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdDistributionReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdDistributionReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdDistribution value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdDistributionReportFilter::valueIsValid()
     * @uses \EnumType\AdDistributionReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $adDistribution
     * @return \StructType\UserLocationPerformanceReportFilter
     */
    public function setAdDistribution(array $adDistribution = array())
    {
        // validation for constraint: list
        if ('' !== ($adDistributionArrayErrorMessage = self::validateAdDistributionForArrayConstraintsFromSetAdDistribution($adDistribution))) {
            throw new \InvalidArgumentException($adDistributionArrayErrorMessage, __LINE__);
        }
        if (is_null($adDistribution) || (is_array($adDistribution) && empty($adDistribution))) {
            unset($this->AdDistribution);
        } else {
            $this->AdDistribution = is_array($adDistribution) ? implode(' ', $adDistribution) : null;
        }
        return $this;
    }
    /**
     * Get CountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getCountryCode()
    {
        return isset($this->CountryCode) ? $this->CountryCode : null;
    }
    /**
     * Set CountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $countryCode
     * @return \StructType\UserLocationPerformanceReportFilter
     */
    public function setCountryCode(\ArrayType\ArrayOfstring $countryCode = null)
    {
        if (is_null($countryCode) || (is_array($countryCode) && empty($countryCode))) {
            unset($this->CountryCode);
        } else {
            $this->CountryCode = $countryCode;
        }
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLanguage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLanguage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLanguageForArrayConstraintsFromSetLanguage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $userLocationPerformanceReportFilterLanguageItem) {
            // validation for constraint: enumeration
            if (!\EnumType\LanguageReportFilter::valueIsValid($userLocationPerformanceReportFilterLanguageItem)) {
                $invalidValues[] = is_object($userLocationPerformanceReportFilterLanguageItem) ? get_class($userLocationPerformanceReportFilterLanguageItem) : sprintf('%s(%s)', gettype($userLocationPerformanceReportFilterLanguageItem), var_export($userLocationPerformanceReportFilterLanguageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LanguageReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\LanguageReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\LanguageReportFilter::valueIsValid()
     * @uses \EnumType\LanguageReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $language
     * @return \StructType\UserLocationPerformanceReportFilter
     */
    public function setLanguage(array $language = array())
    {
        // validation for constraint: list
        if ('' !== ($languageArrayErrorMessage = self::validateLanguageForArrayConstraintsFromSetLanguage($language))) {
            throw new \InvalidArgumentException($languageArrayErrorMessage, __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = is_array($language) ? implode(' ', $language) : null;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserLocationPerformanceReportFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
