<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShareOfVoiceReportFilter StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ShareOfVoiceReportFilter
 * @subpackage Structs
 */
class ShareOfVoiceReportFilter extends AbstractStructBase
{
    /**
     * The AccountStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AccountStatus;
    /**
     * The AdDistribution
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AdDistribution;
    /**
     * The AdGroupStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AdGroupStatus;
    /**
     * The BidMatchType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $BidMatchType;
    /**
     * The BidStrategyType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $BidStrategyType;
    /**
     * The CampaignStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $CampaignStatus;
    /**
     * The DeliveredMatchType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $DeliveredMatchType;
    /**
     * The DeviceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $DeviceType;
    /**
     * The KeywordStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $KeywordStatus;
    /**
     * The Keywords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $Keywords;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $Language;
    /**
     * Constructor method for ShareOfVoiceReportFilter
     * @uses ShareOfVoiceReportFilter::setAccountStatus()
     * @uses ShareOfVoiceReportFilter::setAdDistribution()
     * @uses ShareOfVoiceReportFilter::setAdGroupStatus()
     * @uses ShareOfVoiceReportFilter::setBidMatchType()
     * @uses ShareOfVoiceReportFilter::setBidStrategyType()
     * @uses ShareOfVoiceReportFilter::setCampaignStatus()
     * @uses ShareOfVoiceReportFilter::setDeliveredMatchType()
     * @uses ShareOfVoiceReportFilter::setDeviceType()
     * @uses ShareOfVoiceReportFilter::setKeywordStatus()
     * @uses ShareOfVoiceReportFilter::setKeywords()
     * @uses ShareOfVoiceReportFilter::setLanguage()
     * @param string[] $accountStatus
     * @param string[] $adDistribution
     * @param string[] $adGroupStatus
     * @param string[] $bidMatchType
     * @param string[] $bidStrategyType
     * @param string[] $campaignStatus
     * @param string[] $deliveredMatchType
     * @param string[] $deviceType
     * @param string[] $keywordStatus
     * @param \ArrayType\ArrayOfstring $keywords
     * @param string[] $language
     */
    public function __construct(array $accountStatus = array(), array $adDistribution = array(), array $adGroupStatus = array(), array $bidMatchType = array(), array $bidStrategyType = array(), array $campaignStatus = array(), array $deliveredMatchType = array(), array $deviceType = array(), array $keywordStatus = array(), \ArrayType\ArrayOfstring $keywords = null, array $language = array())
    {
        $this
            ->setAccountStatus($accountStatus)
            ->setAdDistribution($adDistribution)
            ->setAdGroupStatus($adGroupStatus)
            ->setBidMatchType($bidMatchType)
            ->setBidStrategyType($bidStrategyType)
            ->setCampaignStatus($campaignStatus)
            ->setDeliveredMatchType($deliveredMatchType)
            ->setDeviceType($deviceType)
            ->setKeywordStatus($keywordStatus)
            ->setKeywords($keywords)
            ->setLanguage($language);
    }
    /**
     * Get AccountStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAccountStatus()
    {
        return isset($this->AccountStatus) ? $this->AccountStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountStatusForArrayConstraintsFromSetAccountStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shareOfVoiceReportFilterAccountStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AccountStatusReportFilter::valueIsValid($shareOfVoiceReportFilterAccountStatusItem)) {
                $invalidValues[] = is_object($shareOfVoiceReportFilterAccountStatusItem) ? get_class($shareOfVoiceReportFilterAccountStatusItem) : sprintf('%s(%s)', gettype($shareOfVoiceReportFilterAccountStatusItem), var_export($shareOfVoiceReportFilterAccountStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AccountStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccountStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AccountStatusReportFilter::valueIsValid()
     * @uses \EnumType\AccountStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accountStatus
     * @return \StructType\ShareOfVoiceReportFilter
     */
    public function setAccountStatus(array $accountStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($accountStatusArrayErrorMessage = self::validateAccountStatusForArrayConstraintsFromSetAccountStatus($accountStatus))) {
            throw new \InvalidArgumentException($accountStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($accountStatus) || (is_array($accountStatus) && empty($accountStatus))) {
            unset($this->AccountStatus);
        } else {
            $this->AccountStatus = is_array($accountStatus) ? implode(' ', $accountStatus) : null;
        }
        return $this;
    }
    /**
     * Get AdDistribution value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdDistribution()
    {
        return isset($this->AdDistribution) ? $this->AdDistribution : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdDistribution method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdDistribution method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdDistributionForArrayConstraintsFromSetAdDistribution(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shareOfVoiceReportFilterAdDistributionItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdDistributionReportFilter::valueIsValid($shareOfVoiceReportFilterAdDistributionItem)) {
                $invalidValues[] = is_object($shareOfVoiceReportFilterAdDistributionItem) ? get_class($shareOfVoiceReportFilterAdDistributionItem) : sprintf('%s(%s)', gettype($shareOfVoiceReportFilterAdDistributionItem), var_export($shareOfVoiceReportFilterAdDistributionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdDistributionReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdDistributionReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdDistribution value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdDistributionReportFilter::valueIsValid()
     * @uses \EnumType\AdDistributionReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $adDistribution
     * @return \StructType\ShareOfVoiceReportFilter
     */
    public function setAdDistribution(array $adDistribution = array())
    {
        // validation for constraint: list
        if ('' !== ($adDistributionArrayErrorMessage = self::validateAdDistributionForArrayConstraintsFromSetAdDistribution($adDistribution))) {
            throw new \InvalidArgumentException($adDistributionArrayErrorMessage, __LINE__);
        }
        if (is_null($adDistribution) || (is_array($adDistribution) && empty($adDistribution))) {
            unset($this->AdDistribution);
        } else {
            $this->AdDistribution = is_array($adDistribution) ? implode(' ', $adDistribution) : null;
        }
        return $this;
    }
    /**
     * Get AdGroupStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdGroupStatus()
    {
        return isset($this->AdGroupStatus) ? $this->AdGroupStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdGroupStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdGroupStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdGroupStatusForArrayConstraintsFromSetAdGroupStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shareOfVoiceReportFilterAdGroupStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdGroupStatusReportFilter::valueIsValid($shareOfVoiceReportFilterAdGroupStatusItem)) {
                $invalidValues[] = is_object($shareOfVoiceReportFilterAdGroupStatusItem) ? get_class($shareOfVoiceReportFilterAdGroupStatusItem) : sprintf('%s(%s)', gettype($shareOfVoiceReportFilterAdGroupStatusItem), var_export($shareOfVoiceReportFilterAdGroupStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdGroupStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdGroupStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdGroupStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdGroupStatusReportFilter::valueIsValid()
     * @uses \EnumType\AdGroupStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $adGroupStatus
     * @return \StructType\ShareOfVoiceReportFilter
     */
    public function setAdGroupStatus(array $adGroupStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($adGroupStatusArrayErrorMessage = self::validateAdGroupStatusForArrayConstraintsFromSetAdGroupStatus($adGroupStatus))) {
            throw new \InvalidArgumentException($adGroupStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($adGroupStatus) || (is_array($adGroupStatus) && empty($adGroupStatus))) {
            unset($this->AdGroupStatus);
        } else {
            $this->AdGroupStatus = is_array($adGroupStatus) ? implode(' ', $adGroupStatus) : null;
        }
        return $this;
    }
    /**
     * Get BidMatchType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getBidMatchType()
    {
        return isset($this->BidMatchType) ? $this->BidMatchType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBidMatchType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBidMatchType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBidMatchTypeForArrayConstraintsFromSetBidMatchType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shareOfVoiceReportFilterBidMatchTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\BidMatchTypeReportFilter::valueIsValid($shareOfVoiceReportFilterBidMatchTypeItem)) {
                $invalidValues[] = is_object($shareOfVoiceReportFilterBidMatchTypeItem) ? get_class($shareOfVoiceReportFilterBidMatchTypeItem) : sprintf('%s(%s)', gettype($shareOfVoiceReportFilterBidMatchTypeItem), var_export($shareOfVoiceReportFilterBidMatchTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BidMatchTypeReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\BidMatchTypeReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BidMatchType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\BidMatchTypeReportFilter::valueIsValid()
     * @uses \EnumType\BidMatchTypeReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $bidMatchType
     * @return \StructType\ShareOfVoiceReportFilter
     */
    public function setBidMatchType(array $bidMatchType = array())
    {
        // validation for constraint: list
        if ('' !== ($bidMatchTypeArrayErrorMessage = self::validateBidMatchTypeForArrayConstraintsFromSetBidMatchType($bidMatchType))) {
            throw new \InvalidArgumentException($bidMatchTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($bidMatchType) || (is_array($bidMatchType) && empty($bidMatchType))) {
            unset($this->BidMatchType);
        } else {
            $this->BidMatchType = is_array($bidMatchType) ? implode(' ', $bidMatchType) : null;
        }
        return $this;
    }
    /**
     * Get BidStrategyType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getBidStrategyType()
    {
        return isset($this->BidStrategyType) ? $this->BidStrategyType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBidStrategyType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBidStrategyType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBidStrategyTypeForArrayConstraintsFromSetBidStrategyType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shareOfVoiceReportFilterBidStrategyTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\BidStrategyTypeReportFilter::valueIsValid($shareOfVoiceReportFilterBidStrategyTypeItem)) {
                $invalidValues[] = is_object($shareOfVoiceReportFilterBidStrategyTypeItem) ? get_class($shareOfVoiceReportFilterBidStrategyTypeItem) : sprintf('%s(%s)', gettype($shareOfVoiceReportFilterBidStrategyTypeItem), var_export($shareOfVoiceReportFilterBidStrategyTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BidStrategyTypeReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\BidStrategyTypeReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BidStrategyType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\BidStrategyTypeReportFilter::valueIsValid()
     * @uses \EnumType\BidStrategyTypeReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $bidStrategyType
     * @return \StructType\ShareOfVoiceReportFilter
     */
    public function setBidStrategyType(array $bidStrategyType = array())
    {
        // validation for constraint: list
        if ('' !== ($bidStrategyTypeArrayErrorMessage = self::validateBidStrategyTypeForArrayConstraintsFromSetBidStrategyType($bidStrategyType))) {
            throw new \InvalidArgumentException($bidStrategyTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($bidStrategyType) || (is_array($bidStrategyType) && empty($bidStrategyType))) {
            unset($this->BidStrategyType);
        } else {
            $this->BidStrategyType = is_array($bidStrategyType) ? implode(' ', $bidStrategyType) : null;
        }
        return $this;
    }
    /**
     * Get CampaignStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getCampaignStatus()
    {
        return isset($this->CampaignStatus) ? $this->CampaignStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCampaignStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCampaignStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCampaignStatusForArrayConstraintsFromSetCampaignStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shareOfVoiceReportFilterCampaignStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\CampaignStatusReportFilter::valueIsValid($shareOfVoiceReportFilterCampaignStatusItem)) {
                $invalidValues[] = is_object($shareOfVoiceReportFilterCampaignStatusItem) ? get_class($shareOfVoiceReportFilterCampaignStatusItem) : sprintf('%s(%s)', gettype($shareOfVoiceReportFilterCampaignStatusItem), var_export($shareOfVoiceReportFilterCampaignStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CampaignStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\CampaignStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CampaignStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\CampaignStatusReportFilter::valueIsValid()
     * @uses \EnumType\CampaignStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $campaignStatus
     * @return \StructType\ShareOfVoiceReportFilter
     */
    public function setCampaignStatus(array $campaignStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($campaignStatusArrayErrorMessage = self::validateCampaignStatusForArrayConstraintsFromSetCampaignStatus($campaignStatus))) {
            throw new \InvalidArgumentException($campaignStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($campaignStatus) || (is_array($campaignStatus) && empty($campaignStatus))) {
            unset($this->CampaignStatus);
        } else {
            $this->CampaignStatus = is_array($campaignStatus) ? implode(' ', $campaignStatus) : null;
        }
        return $this;
    }
    /**
     * Get DeliveredMatchType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getDeliveredMatchType()
    {
        return isset($this->DeliveredMatchType) ? $this->DeliveredMatchType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDeliveredMatchType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeliveredMatchType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliveredMatchTypeForArrayConstraintsFromSetDeliveredMatchType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shareOfVoiceReportFilterDeliveredMatchTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\DeliveredMatchTypeReportFilter::valueIsValid($shareOfVoiceReportFilterDeliveredMatchTypeItem)) {
                $invalidValues[] = is_object($shareOfVoiceReportFilterDeliveredMatchTypeItem) ? get_class($shareOfVoiceReportFilterDeliveredMatchTypeItem) : sprintf('%s(%s)', gettype($shareOfVoiceReportFilterDeliveredMatchTypeItem), var_export($shareOfVoiceReportFilterDeliveredMatchTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DeliveredMatchTypeReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\DeliveredMatchTypeReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeliveredMatchType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\DeliveredMatchTypeReportFilter::valueIsValid()
     * @uses \EnumType\DeliveredMatchTypeReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $deliveredMatchType
     * @return \StructType\ShareOfVoiceReportFilter
     */
    public function setDeliveredMatchType(array $deliveredMatchType = array())
    {
        // validation for constraint: list
        if ('' !== ($deliveredMatchTypeArrayErrorMessage = self::validateDeliveredMatchTypeForArrayConstraintsFromSetDeliveredMatchType($deliveredMatchType))) {
            throw new \InvalidArgumentException($deliveredMatchTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($deliveredMatchType) || (is_array($deliveredMatchType) && empty($deliveredMatchType))) {
            unset($this->DeliveredMatchType);
        } else {
            $this->DeliveredMatchType = is_array($deliveredMatchType) ? implode(' ', $deliveredMatchType) : null;
        }
        return $this;
    }
    /**
     * Get DeviceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getDeviceType()
    {
        return isset($this->DeviceType) ? $this->DeviceType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDeviceType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeviceType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeviceTypeForArrayConstraintsFromSetDeviceType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shareOfVoiceReportFilterDeviceTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\DeviceTypeReportFilter::valueIsValid($shareOfVoiceReportFilterDeviceTypeItem)) {
                $invalidValues[] = is_object($shareOfVoiceReportFilterDeviceTypeItem) ? get_class($shareOfVoiceReportFilterDeviceTypeItem) : sprintf('%s(%s)', gettype($shareOfVoiceReportFilterDeviceTypeItem), var_export($shareOfVoiceReportFilterDeviceTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DeviceTypeReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\DeviceTypeReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeviceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\DeviceTypeReportFilter::valueIsValid()
     * @uses \EnumType\DeviceTypeReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $deviceType
     * @return \StructType\ShareOfVoiceReportFilter
     */
    public function setDeviceType(array $deviceType = array())
    {
        // validation for constraint: list
        if ('' !== ($deviceTypeArrayErrorMessage = self::validateDeviceTypeForArrayConstraintsFromSetDeviceType($deviceType))) {
            throw new \InvalidArgumentException($deviceTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($deviceType) || (is_array($deviceType) && empty($deviceType))) {
            unset($this->DeviceType);
        } else {
            $this->DeviceType = is_array($deviceType) ? implode(' ', $deviceType) : null;
        }
        return $this;
    }
    /**
     * Get KeywordStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getKeywordStatus()
    {
        return isset($this->KeywordStatus) ? $this->KeywordStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setKeywordStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKeywordStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKeywordStatusForArrayConstraintsFromSetKeywordStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shareOfVoiceReportFilterKeywordStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\KeywordStatusReportFilter::valueIsValid($shareOfVoiceReportFilterKeywordStatusItem)) {
                $invalidValues[] = is_object($shareOfVoiceReportFilterKeywordStatusItem) ? get_class($shareOfVoiceReportFilterKeywordStatusItem) : sprintf('%s(%s)', gettype($shareOfVoiceReportFilterKeywordStatusItem), var_export($shareOfVoiceReportFilterKeywordStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KeywordStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\KeywordStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set KeywordStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\KeywordStatusReportFilter::valueIsValid()
     * @uses \EnumType\KeywordStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $keywordStatus
     * @return \StructType\ShareOfVoiceReportFilter
     */
    public function setKeywordStatus(array $keywordStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($keywordStatusArrayErrorMessage = self::validateKeywordStatusForArrayConstraintsFromSetKeywordStatus($keywordStatus))) {
            throw new \InvalidArgumentException($keywordStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($keywordStatus) || (is_array($keywordStatus) && empty($keywordStatus))) {
            unset($this->KeywordStatus);
        } else {
            $this->KeywordStatus = is_array($keywordStatus) ? implode(' ', $keywordStatus) : null;
        }
        return $this;
    }
    /**
     * Get Keywords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getKeywords()
    {
        return isset($this->Keywords) ? $this->Keywords : null;
    }
    /**
     * Set Keywords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $keywords
     * @return \StructType\ShareOfVoiceReportFilter
     */
    public function setKeywords(\ArrayType\ArrayOfstring $keywords = null)
    {
        if (is_null($keywords) || (is_array($keywords) && empty($keywords))) {
            unset($this->Keywords);
        } else {
            $this->Keywords = $keywords;
        }
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLanguage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLanguage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLanguageForArrayConstraintsFromSetLanguage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shareOfVoiceReportFilterLanguageItem) {
            // validation for constraint: enumeration
            if (!\EnumType\LanguageReportFilter::valueIsValid($shareOfVoiceReportFilterLanguageItem)) {
                $invalidValues[] = is_object($shareOfVoiceReportFilterLanguageItem) ? get_class($shareOfVoiceReportFilterLanguageItem) : sprintf('%s(%s)', gettype($shareOfVoiceReportFilterLanguageItem), var_export($shareOfVoiceReportFilterLanguageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LanguageReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\LanguageReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\LanguageReportFilter::valueIsValid()
     * @uses \EnumType\LanguageReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $language
     * @return \StructType\ShareOfVoiceReportFilter
     */
    public function setLanguage(array $language = array())
    {
        // validation for constraint: list
        if ('' !== ($languageArrayErrorMessage = self::validateLanguageForArrayConstraintsFromSetLanguage($language))) {
            throw new \InvalidArgumentException($languageArrayErrorMessage, __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = is_array($language) ? implode(' ', $language) : null;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShareOfVoiceReportFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
