<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NegativeKeywordConflictReportFilter StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:NegativeKeywordConflictReportFilter
 * @subpackage Structs
 */
class NegativeKeywordConflictReportFilter extends AbstractStructBase
{
    /**
     * The AccountStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AccountStatus;
    /**
     * The AdGroupStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AdGroupStatus;
    /**
     * The CampaignStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $CampaignStatus;
    /**
     * The KeywordStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $KeywordStatus;
    /**
     * Constructor method for NegativeKeywordConflictReportFilter
     * @uses NegativeKeywordConflictReportFilter::setAccountStatus()
     * @uses NegativeKeywordConflictReportFilter::setAdGroupStatus()
     * @uses NegativeKeywordConflictReportFilter::setCampaignStatus()
     * @uses NegativeKeywordConflictReportFilter::setKeywordStatus()
     * @param string[] $accountStatus
     * @param string[] $adGroupStatus
     * @param string[] $campaignStatus
     * @param string[] $keywordStatus
     */
    public function __construct(array $accountStatus = array(), array $adGroupStatus = array(), array $campaignStatus = array(), array $keywordStatus = array())
    {
        $this
            ->setAccountStatus($accountStatus)
            ->setAdGroupStatus($adGroupStatus)
            ->setCampaignStatus($campaignStatus)
            ->setKeywordStatus($keywordStatus);
    }
    /**
     * Get AccountStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAccountStatus()
    {
        return isset($this->AccountStatus) ? $this->AccountStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountStatusForArrayConstraintsFromSetAccountStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $negativeKeywordConflictReportFilterAccountStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AccountStatusReportFilter::valueIsValid($negativeKeywordConflictReportFilterAccountStatusItem)) {
                $invalidValues[] = is_object($negativeKeywordConflictReportFilterAccountStatusItem) ? get_class($negativeKeywordConflictReportFilterAccountStatusItem) : sprintf('%s(%s)', gettype($negativeKeywordConflictReportFilterAccountStatusItem), var_export($negativeKeywordConflictReportFilterAccountStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AccountStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccountStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AccountStatusReportFilter::valueIsValid()
     * @uses \EnumType\AccountStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accountStatus
     * @return \StructType\NegativeKeywordConflictReportFilter
     */
    public function setAccountStatus(array $accountStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($accountStatusArrayErrorMessage = self::validateAccountStatusForArrayConstraintsFromSetAccountStatus($accountStatus))) {
            throw new \InvalidArgumentException($accountStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($accountStatus) || (is_array($accountStatus) && empty($accountStatus))) {
            unset($this->AccountStatus);
        } else {
            $this->AccountStatus = is_array($accountStatus) ? implode(' ', $accountStatus) : null;
        }
        return $this;
    }
    /**
     * Get AdGroupStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdGroupStatus()
    {
        return isset($this->AdGroupStatus) ? $this->AdGroupStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdGroupStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdGroupStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdGroupStatusForArrayConstraintsFromSetAdGroupStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $negativeKeywordConflictReportFilterAdGroupStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdGroupStatusReportFilter::valueIsValid($negativeKeywordConflictReportFilterAdGroupStatusItem)) {
                $invalidValues[] = is_object($negativeKeywordConflictReportFilterAdGroupStatusItem) ? get_class($negativeKeywordConflictReportFilterAdGroupStatusItem) : sprintf('%s(%s)', gettype($negativeKeywordConflictReportFilterAdGroupStatusItem), var_export($negativeKeywordConflictReportFilterAdGroupStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdGroupStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdGroupStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdGroupStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdGroupStatusReportFilter::valueIsValid()
     * @uses \EnumType\AdGroupStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $adGroupStatus
     * @return \StructType\NegativeKeywordConflictReportFilter
     */
    public function setAdGroupStatus(array $adGroupStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($adGroupStatusArrayErrorMessage = self::validateAdGroupStatusForArrayConstraintsFromSetAdGroupStatus($adGroupStatus))) {
            throw new \InvalidArgumentException($adGroupStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($adGroupStatus) || (is_array($adGroupStatus) && empty($adGroupStatus))) {
            unset($this->AdGroupStatus);
        } else {
            $this->AdGroupStatus = is_array($adGroupStatus) ? implode(' ', $adGroupStatus) : null;
        }
        return $this;
    }
    /**
     * Get CampaignStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getCampaignStatus()
    {
        return isset($this->CampaignStatus) ? $this->CampaignStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCampaignStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCampaignStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCampaignStatusForArrayConstraintsFromSetCampaignStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $negativeKeywordConflictReportFilterCampaignStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\CampaignStatusReportFilter::valueIsValid($negativeKeywordConflictReportFilterCampaignStatusItem)) {
                $invalidValues[] = is_object($negativeKeywordConflictReportFilterCampaignStatusItem) ? get_class($negativeKeywordConflictReportFilterCampaignStatusItem) : sprintf('%s(%s)', gettype($negativeKeywordConflictReportFilterCampaignStatusItem), var_export($negativeKeywordConflictReportFilterCampaignStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CampaignStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\CampaignStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CampaignStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\CampaignStatusReportFilter::valueIsValid()
     * @uses \EnumType\CampaignStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $campaignStatus
     * @return \StructType\NegativeKeywordConflictReportFilter
     */
    public function setCampaignStatus(array $campaignStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($campaignStatusArrayErrorMessage = self::validateCampaignStatusForArrayConstraintsFromSetCampaignStatus($campaignStatus))) {
            throw new \InvalidArgumentException($campaignStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($campaignStatus) || (is_array($campaignStatus) && empty($campaignStatus))) {
            unset($this->CampaignStatus);
        } else {
            $this->CampaignStatus = is_array($campaignStatus) ? implode(' ', $campaignStatus) : null;
        }
        return $this;
    }
    /**
     * Get KeywordStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getKeywordStatus()
    {
        return isset($this->KeywordStatus) ? $this->KeywordStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setKeywordStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKeywordStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKeywordStatusForArrayConstraintsFromSetKeywordStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $negativeKeywordConflictReportFilterKeywordStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\KeywordStatusReportFilter::valueIsValid($negativeKeywordConflictReportFilterKeywordStatusItem)) {
                $invalidValues[] = is_object($negativeKeywordConflictReportFilterKeywordStatusItem) ? get_class($negativeKeywordConflictReportFilterKeywordStatusItem) : sprintf('%s(%s)', gettype($negativeKeywordConflictReportFilterKeywordStatusItem), var_export($negativeKeywordConflictReportFilterKeywordStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KeywordStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\KeywordStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set KeywordStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\KeywordStatusReportFilter::valueIsValid()
     * @uses \EnumType\KeywordStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $keywordStatus
     * @return \StructType\NegativeKeywordConflictReportFilter
     */
    public function setKeywordStatus(array $keywordStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($keywordStatusArrayErrorMessage = self::validateKeywordStatusForArrayConstraintsFromSetKeywordStatus($keywordStatus))) {
            throw new \InvalidArgumentException($keywordStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($keywordStatus) || (is_array($keywordStatus) && empty($keywordStatus))) {
            unset($this->KeywordStatus);
        } else {
            $this->KeywordStatus = is_array($keywordStatus) ? implode(' ', $keywordStatus) : null;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NegativeKeywordConflictReportFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
