<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KeywordPerformanceReportRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:KeywordPerformanceReportRequest
 * @subpackage Structs
 */
class KeywordPerformanceReportRequest extends ReportRequest
{
    /**
     * The Aggregation
     * @var string
     */
    public $Aggregation;
    /**
     * The Columns
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfKeywordPerformanceReportColumn
     */
    public $Columns;
    /**
     * The Filter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\KeywordPerformanceReportFilter
     */
    public $Filter;
    /**
     * The MaxRows
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaxRows;
    /**
     * The Scope
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\AccountThroughAdGroupReportScope
     */
    public $Scope;
    /**
     * The Sort
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfKeywordPerformanceReportSort
     */
    public $Sort;
    /**
     * The Time
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReportTime
     */
    public $Time;
    /**
     * Constructor method for KeywordPerformanceReportRequest
     * @uses KeywordPerformanceReportRequest::setAggregation()
     * @uses KeywordPerformanceReportRequest::setColumns()
     * @uses KeywordPerformanceReportRequest::setFilter()
     * @uses KeywordPerformanceReportRequest::setMaxRows()
     * @uses KeywordPerformanceReportRequest::setScope()
     * @uses KeywordPerformanceReportRequest::setSort()
     * @uses KeywordPerformanceReportRequest::setTime()
     * @param string $aggregation
     * @param \ArrayType\ArrayOfKeywordPerformanceReportColumn $columns
     * @param \StructType\KeywordPerformanceReportFilter $filter
     * @param int $maxRows
     * @param \StructType\AccountThroughAdGroupReportScope $scope
     * @param \ArrayType\ArrayOfKeywordPerformanceReportSort $sort
     * @param \StructType\ReportTime $time
     */
    public function __construct($aggregation = null, \ArrayType\ArrayOfKeywordPerformanceReportColumn $columns = null, \StructType\KeywordPerformanceReportFilter $filter = null, $maxRows = null, \StructType\AccountThroughAdGroupReportScope $scope = null, \ArrayType\ArrayOfKeywordPerformanceReportSort $sort = null, \StructType\ReportTime $time = null)
    {
        $this
            ->setAggregation($aggregation)
            ->setColumns($columns)
            ->setFilter($filter)
            ->setMaxRows($maxRows)
            ->setScope($scope)
            ->setSort($sort)
            ->setTime($time);
    }
    /**
     * Get Aggregation value
     * @return string|null
     */
    public function getAggregation()
    {
        return $this->Aggregation;
    }
    /**
     * Set Aggregation value
     * @uses \EnumType\ReportAggregation::valueIsValid()
     * @uses \EnumType\ReportAggregation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $aggregation
     * @return \StructType\KeywordPerformanceReportRequest
     */
    public function setAggregation($aggregation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReportAggregation::valueIsValid($aggregation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ReportAggregation', is_array($aggregation) ? implode(', ', $aggregation) : var_export($aggregation, true), implode(', ', \EnumType\ReportAggregation::getValidValues())), __LINE__);
        }
        $this->Aggregation = $aggregation;
        return $this;
    }
    /**
     * Get Columns value
     * @return \ArrayType\ArrayOfKeywordPerformanceReportColumn|null
     */
    public function getColumns()
    {
        return $this->Columns;
    }
    /**
     * Set Columns value
     * @param \ArrayType\ArrayOfKeywordPerformanceReportColumn $columns
     * @return \StructType\KeywordPerformanceReportRequest
     */
    public function setColumns(\ArrayType\ArrayOfKeywordPerformanceReportColumn $columns = null)
    {
        $this->Columns = $columns;
        return $this;
    }
    /**
     * Get Filter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\KeywordPerformanceReportFilter|null
     */
    public function getFilter()
    {
        return isset($this->Filter) ? $this->Filter : null;
    }
    /**
     * Set Filter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\KeywordPerformanceReportFilter $filter
     * @return \StructType\KeywordPerformanceReportRequest
     */
    public function setFilter(\StructType\KeywordPerformanceReportFilter $filter = null)
    {
        if (is_null($filter) || (is_array($filter) && empty($filter))) {
            unset($this->Filter);
        } else {
            $this->Filter = $filter;
        }
        return $this;
    }
    /**
     * Get MaxRows value
     * @return int|null
     */
    public function getMaxRows()
    {
        return $this->MaxRows;
    }
    /**
     * Set MaxRows value
     * @param int $maxRows
     * @return \StructType\KeywordPerformanceReportRequest
     */
    public function setMaxRows($maxRows = null)
    {
        // validation for constraint: int
        if (!is_null($maxRows) && !(is_int($maxRows) || ctype_digit($maxRows))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxRows, true), gettype($maxRows)), __LINE__);
        }
        $this->MaxRows = $maxRows;
        return $this;
    }
    /**
     * Get Scope value
     * @return \StructType\AccountThroughAdGroupReportScope|null
     */
    public function getScope()
    {
        return $this->Scope;
    }
    /**
     * Set Scope value
     * @param \StructType\AccountThroughAdGroupReportScope $scope
     * @return \StructType\KeywordPerformanceReportRequest
     */
    public function setScope(\StructType\AccountThroughAdGroupReportScope $scope = null)
    {
        $this->Scope = $scope;
        return $this;
    }
    /**
     * Get Sort value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfKeywordPerformanceReportSort|null
     */
    public function getSort()
    {
        return isset($this->Sort) ? $this->Sort : null;
    }
    /**
     * Set Sort value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfKeywordPerformanceReportSort $sort
     * @return \StructType\KeywordPerformanceReportRequest
     */
    public function setSort(\ArrayType\ArrayOfKeywordPerformanceReportSort $sort = null)
    {
        if (is_null($sort) || (is_array($sort) && empty($sort))) {
            unset($this->Sort);
        } else {
            $this->Sort = $sort;
        }
        return $this;
    }
    /**
     * Get Time value
     * @return \StructType\ReportTime|null
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * Set Time value
     * @param \StructType\ReportTime $time
     * @return \StructType\KeywordPerformanceReportRequest
     */
    public function setTime(\StructType\ReportTime $time = null)
    {
        $this->Time = $time;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KeywordPerformanceReportRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
