<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DestinationUrlPerformanceReportFilter StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DestinationUrlPerformanceReportFilter
 * @subpackage Structs
 */
class DestinationUrlPerformanceReportFilter extends AbstractStructBase
{
    /**
     * The AccountStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AccountStatus;
    /**
     * The AdDistribution
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AdDistribution;
    /**
     * The AdGroupStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AdGroupStatus;
    /**
     * The AdStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AdStatus;
    /**
     * The CampaignStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $CampaignStatus;
    /**
     * The DeviceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $DeviceType;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $Language;
    /**
     * Constructor method for DestinationUrlPerformanceReportFilter
     * @uses DestinationUrlPerformanceReportFilter::setAccountStatus()
     * @uses DestinationUrlPerformanceReportFilter::setAdDistribution()
     * @uses DestinationUrlPerformanceReportFilter::setAdGroupStatus()
     * @uses DestinationUrlPerformanceReportFilter::setAdStatus()
     * @uses DestinationUrlPerformanceReportFilter::setCampaignStatus()
     * @uses DestinationUrlPerformanceReportFilter::setDeviceType()
     * @uses DestinationUrlPerformanceReportFilter::setLanguage()
     * @param string[] $accountStatus
     * @param string[] $adDistribution
     * @param string[] $adGroupStatus
     * @param string[] $adStatus
     * @param string[] $campaignStatus
     * @param string[] $deviceType
     * @param string[] $language
     */
    public function __construct(array $accountStatus = array(), array $adDistribution = array(), array $adGroupStatus = array(), array $adStatus = array(), array $campaignStatus = array(), array $deviceType = array(), array $language = array())
    {
        $this
            ->setAccountStatus($accountStatus)
            ->setAdDistribution($adDistribution)
            ->setAdGroupStatus($adGroupStatus)
            ->setAdStatus($adStatus)
            ->setCampaignStatus($campaignStatus)
            ->setDeviceType($deviceType)
            ->setLanguage($language);
    }
    /**
     * Get AccountStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAccountStatus()
    {
        return isset($this->AccountStatus) ? $this->AccountStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountStatusForArrayConstraintsFromSetAccountStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $destinationUrlPerformanceReportFilterAccountStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AccountStatusReportFilter::valueIsValid($destinationUrlPerformanceReportFilterAccountStatusItem)) {
                $invalidValues[] = is_object($destinationUrlPerformanceReportFilterAccountStatusItem) ? get_class($destinationUrlPerformanceReportFilterAccountStatusItem) : sprintf('%s(%s)', gettype($destinationUrlPerformanceReportFilterAccountStatusItem), var_export($destinationUrlPerformanceReportFilterAccountStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AccountStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccountStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AccountStatusReportFilter::valueIsValid()
     * @uses \EnumType\AccountStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accountStatus
     * @return \StructType\DestinationUrlPerformanceReportFilter
     */
    public function setAccountStatus(array $accountStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($accountStatusArrayErrorMessage = self::validateAccountStatusForArrayConstraintsFromSetAccountStatus($accountStatus))) {
            throw new \InvalidArgumentException($accountStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($accountStatus) || (is_array($accountStatus) && empty($accountStatus))) {
            unset($this->AccountStatus);
        } else {
            $this->AccountStatus = is_array($accountStatus) ? implode(' ', $accountStatus) : null;
        }
        return $this;
    }
    /**
     * Get AdDistribution value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdDistribution()
    {
        return isset($this->AdDistribution) ? $this->AdDistribution : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdDistribution method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdDistribution method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdDistributionForArrayConstraintsFromSetAdDistribution(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $destinationUrlPerformanceReportFilterAdDistributionItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdDistributionReportFilter::valueIsValid($destinationUrlPerformanceReportFilterAdDistributionItem)) {
                $invalidValues[] = is_object($destinationUrlPerformanceReportFilterAdDistributionItem) ? get_class($destinationUrlPerformanceReportFilterAdDistributionItem) : sprintf('%s(%s)', gettype($destinationUrlPerformanceReportFilterAdDistributionItem), var_export($destinationUrlPerformanceReportFilterAdDistributionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdDistributionReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdDistributionReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdDistribution value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdDistributionReportFilter::valueIsValid()
     * @uses \EnumType\AdDistributionReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $adDistribution
     * @return \StructType\DestinationUrlPerformanceReportFilter
     */
    public function setAdDistribution(array $adDistribution = array())
    {
        // validation for constraint: list
        if ('' !== ($adDistributionArrayErrorMessage = self::validateAdDistributionForArrayConstraintsFromSetAdDistribution($adDistribution))) {
            throw new \InvalidArgumentException($adDistributionArrayErrorMessage, __LINE__);
        }
        if (is_null($adDistribution) || (is_array($adDistribution) && empty($adDistribution))) {
            unset($this->AdDistribution);
        } else {
            $this->AdDistribution = is_array($adDistribution) ? implode(' ', $adDistribution) : null;
        }
        return $this;
    }
    /**
     * Get AdGroupStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdGroupStatus()
    {
        return isset($this->AdGroupStatus) ? $this->AdGroupStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdGroupStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdGroupStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdGroupStatusForArrayConstraintsFromSetAdGroupStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $destinationUrlPerformanceReportFilterAdGroupStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdGroupStatusReportFilter::valueIsValid($destinationUrlPerformanceReportFilterAdGroupStatusItem)) {
                $invalidValues[] = is_object($destinationUrlPerformanceReportFilterAdGroupStatusItem) ? get_class($destinationUrlPerformanceReportFilterAdGroupStatusItem) : sprintf('%s(%s)', gettype($destinationUrlPerformanceReportFilterAdGroupStatusItem), var_export($destinationUrlPerformanceReportFilterAdGroupStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdGroupStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdGroupStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdGroupStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdGroupStatusReportFilter::valueIsValid()
     * @uses \EnumType\AdGroupStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $adGroupStatus
     * @return \StructType\DestinationUrlPerformanceReportFilter
     */
    public function setAdGroupStatus(array $adGroupStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($adGroupStatusArrayErrorMessage = self::validateAdGroupStatusForArrayConstraintsFromSetAdGroupStatus($adGroupStatus))) {
            throw new \InvalidArgumentException($adGroupStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($adGroupStatus) || (is_array($adGroupStatus) && empty($adGroupStatus))) {
            unset($this->AdGroupStatus);
        } else {
            $this->AdGroupStatus = is_array($adGroupStatus) ? implode(' ', $adGroupStatus) : null;
        }
        return $this;
    }
    /**
     * Get AdStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdStatus()
    {
        return isset($this->AdStatus) ? $this->AdStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdStatusForArrayConstraintsFromSetAdStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $destinationUrlPerformanceReportFilterAdStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdStatusReportFilter::valueIsValid($destinationUrlPerformanceReportFilterAdStatusItem)) {
                $invalidValues[] = is_object($destinationUrlPerformanceReportFilterAdStatusItem) ? get_class($destinationUrlPerformanceReportFilterAdStatusItem) : sprintf('%s(%s)', gettype($destinationUrlPerformanceReportFilterAdStatusItem), var_export($destinationUrlPerformanceReportFilterAdStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdStatusReportFilter::valueIsValid()
     * @uses \EnumType\AdStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $adStatus
     * @return \StructType\DestinationUrlPerformanceReportFilter
     */
    public function setAdStatus(array $adStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($adStatusArrayErrorMessage = self::validateAdStatusForArrayConstraintsFromSetAdStatus($adStatus))) {
            throw new \InvalidArgumentException($adStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($adStatus) || (is_array($adStatus) && empty($adStatus))) {
            unset($this->AdStatus);
        } else {
            $this->AdStatus = is_array($adStatus) ? implode(' ', $adStatus) : null;
        }
        return $this;
    }
    /**
     * Get CampaignStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getCampaignStatus()
    {
        return isset($this->CampaignStatus) ? $this->CampaignStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCampaignStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCampaignStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCampaignStatusForArrayConstraintsFromSetCampaignStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $destinationUrlPerformanceReportFilterCampaignStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\CampaignStatusReportFilter::valueIsValid($destinationUrlPerformanceReportFilterCampaignStatusItem)) {
                $invalidValues[] = is_object($destinationUrlPerformanceReportFilterCampaignStatusItem) ? get_class($destinationUrlPerformanceReportFilterCampaignStatusItem) : sprintf('%s(%s)', gettype($destinationUrlPerformanceReportFilterCampaignStatusItem), var_export($destinationUrlPerformanceReportFilterCampaignStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CampaignStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\CampaignStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CampaignStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\CampaignStatusReportFilter::valueIsValid()
     * @uses \EnumType\CampaignStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $campaignStatus
     * @return \StructType\DestinationUrlPerformanceReportFilter
     */
    public function setCampaignStatus(array $campaignStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($campaignStatusArrayErrorMessage = self::validateCampaignStatusForArrayConstraintsFromSetCampaignStatus($campaignStatus))) {
            throw new \InvalidArgumentException($campaignStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($campaignStatus) || (is_array($campaignStatus) && empty($campaignStatus))) {
            unset($this->CampaignStatus);
        } else {
            $this->CampaignStatus = is_array($campaignStatus) ? implode(' ', $campaignStatus) : null;
        }
        return $this;
    }
    /**
     * Get DeviceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getDeviceType()
    {
        return isset($this->DeviceType) ? $this->DeviceType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDeviceType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeviceType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeviceTypeForArrayConstraintsFromSetDeviceType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $destinationUrlPerformanceReportFilterDeviceTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\DeviceTypeReportFilter::valueIsValid($destinationUrlPerformanceReportFilterDeviceTypeItem)) {
                $invalidValues[] = is_object($destinationUrlPerformanceReportFilterDeviceTypeItem) ? get_class($destinationUrlPerformanceReportFilterDeviceTypeItem) : sprintf('%s(%s)', gettype($destinationUrlPerformanceReportFilterDeviceTypeItem), var_export($destinationUrlPerformanceReportFilterDeviceTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DeviceTypeReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\DeviceTypeReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeviceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\DeviceTypeReportFilter::valueIsValid()
     * @uses \EnumType\DeviceTypeReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $deviceType
     * @return \StructType\DestinationUrlPerformanceReportFilter
     */
    public function setDeviceType(array $deviceType = array())
    {
        // validation for constraint: list
        if ('' !== ($deviceTypeArrayErrorMessage = self::validateDeviceTypeForArrayConstraintsFromSetDeviceType($deviceType))) {
            throw new \InvalidArgumentException($deviceTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($deviceType) || (is_array($deviceType) && empty($deviceType))) {
            unset($this->DeviceType);
        } else {
            $this->DeviceType = is_array($deviceType) ? implode(' ', $deviceType) : null;
        }
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLanguage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLanguage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLanguageForArrayConstraintsFromSetLanguage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $destinationUrlPerformanceReportFilterLanguageItem) {
            // validation for constraint: enumeration
            if (!\EnumType\LanguageReportFilter::valueIsValid($destinationUrlPerformanceReportFilterLanguageItem)) {
                $invalidValues[] = is_object($destinationUrlPerformanceReportFilterLanguageItem) ? get_class($destinationUrlPerformanceReportFilterLanguageItem) : sprintf('%s(%s)', gettype($destinationUrlPerformanceReportFilterLanguageItem), var_export($destinationUrlPerformanceReportFilterLanguageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LanguageReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\LanguageReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\LanguageReportFilter::valueIsValid()
     * @uses \EnumType\LanguageReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $language
     * @return \StructType\DestinationUrlPerformanceReportFilter
     */
    public function setLanguage(array $language = array())
    {
        // validation for constraint: list
        if ('' !== ($languageArrayErrorMessage = self::validateLanguageForArrayConstraintsFromSetLanguage($language))) {
            throw new \InvalidArgumentException($languageArrayErrorMessage, __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = is_array($language) ? implode(' ', $language) : null;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DestinationUrlPerformanceReportFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
