<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DSAAutoTargetPerformanceReportFilter StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DSAAutoTargetPerformanceReportFilter
 * @subpackage Structs
 */
class DSAAutoTargetPerformanceReportFilter extends AbstractStructBase
{
    /**
     * The AccountStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AccountStatus;
    /**
     * The AdGroupStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AdGroupStatus;
    /**
     * The BidStrategyType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $BidStrategyType;
    /**
     * The CampaignStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $CampaignStatus;
    /**
     * The DynamicAdTargetStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $DynamicAdTargetStatus;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $Language;
    /**
     * Constructor method for DSAAutoTargetPerformanceReportFilter
     * @uses DSAAutoTargetPerformanceReportFilter::setAccountStatus()
     * @uses DSAAutoTargetPerformanceReportFilter::setAdGroupStatus()
     * @uses DSAAutoTargetPerformanceReportFilter::setBidStrategyType()
     * @uses DSAAutoTargetPerformanceReportFilter::setCampaignStatus()
     * @uses DSAAutoTargetPerformanceReportFilter::setDynamicAdTargetStatus()
     * @uses DSAAutoTargetPerformanceReportFilter::setLanguage()
     * @param string[] $accountStatus
     * @param string[] $adGroupStatus
     * @param string[] $bidStrategyType
     * @param string[] $campaignStatus
     * @param string[] $dynamicAdTargetStatus
     * @param string[] $language
     */
    public function __construct(array $accountStatus = array(), array $adGroupStatus = array(), array $bidStrategyType = array(), array $campaignStatus = array(), array $dynamicAdTargetStatus = array(), array $language = array())
    {
        $this
            ->setAccountStatus($accountStatus)
            ->setAdGroupStatus($adGroupStatus)
            ->setBidStrategyType($bidStrategyType)
            ->setCampaignStatus($campaignStatus)
            ->setDynamicAdTargetStatus($dynamicAdTargetStatus)
            ->setLanguage($language);
    }
    /**
     * Get AccountStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAccountStatus()
    {
        return isset($this->AccountStatus) ? $this->AccountStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountStatusForArrayConstraintsFromSetAccountStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dSAAutoTargetPerformanceReportFilterAccountStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AccountStatusReportFilter::valueIsValid($dSAAutoTargetPerformanceReportFilterAccountStatusItem)) {
                $invalidValues[] = is_object($dSAAutoTargetPerformanceReportFilterAccountStatusItem) ? get_class($dSAAutoTargetPerformanceReportFilterAccountStatusItem) : sprintf('%s(%s)', gettype($dSAAutoTargetPerformanceReportFilterAccountStatusItem), var_export($dSAAutoTargetPerformanceReportFilterAccountStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AccountStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccountStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AccountStatusReportFilter::valueIsValid()
     * @uses \EnumType\AccountStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accountStatus
     * @return \StructType\DSAAutoTargetPerformanceReportFilter
     */
    public function setAccountStatus(array $accountStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($accountStatusArrayErrorMessage = self::validateAccountStatusForArrayConstraintsFromSetAccountStatus($accountStatus))) {
            throw new \InvalidArgumentException($accountStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($accountStatus) || (is_array($accountStatus) && empty($accountStatus))) {
            unset($this->AccountStatus);
        } else {
            $this->AccountStatus = is_array($accountStatus) ? implode(' ', $accountStatus) : null;
        }
        return $this;
    }
    /**
     * Get AdGroupStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdGroupStatus()
    {
        return isset($this->AdGroupStatus) ? $this->AdGroupStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdGroupStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdGroupStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdGroupStatusForArrayConstraintsFromSetAdGroupStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dSAAutoTargetPerformanceReportFilterAdGroupStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdGroupStatusReportFilter::valueIsValid($dSAAutoTargetPerformanceReportFilterAdGroupStatusItem)) {
                $invalidValues[] = is_object($dSAAutoTargetPerformanceReportFilterAdGroupStatusItem) ? get_class($dSAAutoTargetPerformanceReportFilterAdGroupStatusItem) : sprintf('%s(%s)', gettype($dSAAutoTargetPerformanceReportFilterAdGroupStatusItem), var_export($dSAAutoTargetPerformanceReportFilterAdGroupStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdGroupStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdGroupStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdGroupStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdGroupStatusReportFilter::valueIsValid()
     * @uses \EnumType\AdGroupStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $adGroupStatus
     * @return \StructType\DSAAutoTargetPerformanceReportFilter
     */
    public function setAdGroupStatus(array $adGroupStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($adGroupStatusArrayErrorMessage = self::validateAdGroupStatusForArrayConstraintsFromSetAdGroupStatus($adGroupStatus))) {
            throw new \InvalidArgumentException($adGroupStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($adGroupStatus) || (is_array($adGroupStatus) && empty($adGroupStatus))) {
            unset($this->AdGroupStatus);
        } else {
            $this->AdGroupStatus = is_array($adGroupStatus) ? implode(' ', $adGroupStatus) : null;
        }
        return $this;
    }
    /**
     * Get BidStrategyType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getBidStrategyType()
    {
        return isset($this->BidStrategyType) ? $this->BidStrategyType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBidStrategyType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBidStrategyType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBidStrategyTypeForArrayConstraintsFromSetBidStrategyType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dSAAutoTargetPerformanceReportFilterBidStrategyTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\BidStrategyTypeReportFilter::valueIsValid($dSAAutoTargetPerformanceReportFilterBidStrategyTypeItem)) {
                $invalidValues[] = is_object($dSAAutoTargetPerformanceReportFilterBidStrategyTypeItem) ? get_class($dSAAutoTargetPerformanceReportFilterBidStrategyTypeItem) : sprintf('%s(%s)', gettype($dSAAutoTargetPerformanceReportFilterBidStrategyTypeItem), var_export($dSAAutoTargetPerformanceReportFilterBidStrategyTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BidStrategyTypeReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\BidStrategyTypeReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BidStrategyType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\BidStrategyTypeReportFilter::valueIsValid()
     * @uses \EnumType\BidStrategyTypeReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $bidStrategyType
     * @return \StructType\DSAAutoTargetPerformanceReportFilter
     */
    public function setBidStrategyType(array $bidStrategyType = array())
    {
        // validation for constraint: list
        if ('' !== ($bidStrategyTypeArrayErrorMessage = self::validateBidStrategyTypeForArrayConstraintsFromSetBidStrategyType($bidStrategyType))) {
            throw new \InvalidArgumentException($bidStrategyTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($bidStrategyType) || (is_array($bidStrategyType) && empty($bidStrategyType))) {
            unset($this->BidStrategyType);
        } else {
            $this->BidStrategyType = is_array($bidStrategyType) ? implode(' ', $bidStrategyType) : null;
        }
        return $this;
    }
    /**
     * Get CampaignStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getCampaignStatus()
    {
        return isset($this->CampaignStatus) ? $this->CampaignStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCampaignStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCampaignStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCampaignStatusForArrayConstraintsFromSetCampaignStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dSAAutoTargetPerformanceReportFilterCampaignStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\CampaignStatusReportFilter::valueIsValid($dSAAutoTargetPerformanceReportFilterCampaignStatusItem)) {
                $invalidValues[] = is_object($dSAAutoTargetPerformanceReportFilterCampaignStatusItem) ? get_class($dSAAutoTargetPerformanceReportFilterCampaignStatusItem) : sprintf('%s(%s)', gettype($dSAAutoTargetPerformanceReportFilterCampaignStatusItem), var_export($dSAAutoTargetPerformanceReportFilterCampaignStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CampaignStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\CampaignStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CampaignStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\CampaignStatusReportFilter::valueIsValid()
     * @uses \EnumType\CampaignStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $campaignStatus
     * @return \StructType\DSAAutoTargetPerformanceReportFilter
     */
    public function setCampaignStatus(array $campaignStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($campaignStatusArrayErrorMessage = self::validateCampaignStatusForArrayConstraintsFromSetCampaignStatus($campaignStatus))) {
            throw new \InvalidArgumentException($campaignStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($campaignStatus) || (is_array($campaignStatus) && empty($campaignStatus))) {
            unset($this->CampaignStatus);
        } else {
            $this->CampaignStatus = is_array($campaignStatus) ? implode(' ', $campaignStatus) : null;
        }
        return $this;
    }
    /**
     * Get DynamicAdTargetStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getDynamicAdTargetStatus()
    {
        return isset($this->DynamicAdTargetStatus) ? $this->DynamicAdTargetStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDynamicAdTargetStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDynamicAdTargetStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDynamicAdTargetStatusForArrayConstraintsFromSetDynamicAdTargetStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dSAAutoTargetPerformanceReportFilterDynamicAdTargetStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\DynamicAdTargetStatusReportFilter::valueIsValid($dSAAutoTargetPerformanceReportFilterDynamicAdTargetStatusItem)) {
                $invalidValues[] = is_object($dSAAutoTargetPerformanceReportFilterDynamicAdTargetStatusItem) ? get_class($dSAAutoTargetPerformanceReportFilterDynamicAdTargetStatusItem) : sprintf('%s(%s)', gettype($dSAAutoTargetPerformanceReportFilterDynamicAdTargetStatusItem), var_export($dSAAutoTargetPerformanceReportFilterDynamicAdTargetStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DynamicAdTargetStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\DynamicAdTargetStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DynamicAdTargetStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\DynamicAdTargetStatusReportFilter::valueIsValid()
     * @uses \EnumType\DynamicAdTargetStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $dynamicAdTargetStatus
     * @return \StructType\DSAAutoTargetPerformanceReportFilter
     */
    public function setDynamicAdTargetStatus(array $dynamicAdTargetStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($dynamicAdTargetStatusArrayErrorMessage = self::validateDynamicAdTargetStatusForArrayConstraintsFromSetDynamicAdTargetStatus($dynamicAdTargetStatus))) {
            throw new \InvalidArgumentException($dynamicAdTargetStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($dynamicAdTargetStatus) || (is_array($dynamicAdTargetStatus) && empty($dynamicAdTargetStatus))) {
            unset($this->DynamicAdTargetStatus);
        } else {
            $this->DynamicAdTargetStatus = is_array($dynamicAdTargetStatus) ? implode(' ', $dynamicAdTargetStatus) : null;
        }
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLanguage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLanguage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLanguageForArrayConstraintsFromSetLanguage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dSAAutoTargetPerformanceReportFilterLanguageItem) {
            // validation for constraint: enumeration
            if (!\EnumType\LanguageReportFilter::valueIsValid($dSAAutoTargetPerformanceReportFilterLanguageItem)) {
                $invalidValues[] = is_object($dSAAutoTargetPerformanceReportFilterLanguageItem) ? get_class($dSAAutoTargetPerformanceReportFilterLanguageItem) : sprintf('%s(%s)', gettype($dSAAutoTargetPerformanceReportFilterLanguageItem), var_export($dSAAutoTargetPerformanceReportFilterLanguageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LanguageReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\LanguageReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\LanguageReportFilter::valueIsValid()
     * @uses \EnumType\LanguageReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $language
     * @return \StructType\DSAAutoTargetPerformanceReportFilter
     */
    public function setLanguage(array $language = array())
    {
        // validation for constraint: list
        if ('' !== ($languageArrayErrorMessage = self::validateLanguageForArrayConstraintsFromSetLanguage($language))) {
            throw new \InvalidArgumentException($languageArrayErrorMessage, __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = is_array($language) ? implode(' ', $language) : null;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DSAAutoTargetPerformanceReportFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
