<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApiFaultDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ApiFaultDetail
 * @subpackage Structs
 */
class ApiFaultDetail extends ApplicationFault
{
    /**
     * The BatchErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $BatchErrors;
    /**
     * The OperationErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfOperationError
     */
    public $OperationErrors;
    /**
     * Constructor method for ApiFaultDetail
     * @uses ApiFaultDetail::setBatchErrors()
     * @uses ApiFaultDetail::setOperationErrors()
     * @param \ArrayType\ArrayOfBatchError $batchErrors
     * @param \ArrayType\ArrayOfOperationError $operationErrors
     */
    public function __construct(\ArrayType\ArrayOfBatchError $batchErrors = null, \ArrayType\ArrayOfOperationError $operationErrors = null)
    {
        $this
            ->setBatchErrors($batchErrors)
            ->setOperationErrors($operationErrors);
    }
    /**
     * Get BatchErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getBatchErrors()
    {
        return isset($this->BatchErrors) ? $this->BatchErrors : null;
    }
    /**
     * Set BatchErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $batchErrors
     * @return \StructType\ApiFaultDetail
     */
    public function setBatchErrors(\ArrayType\ArrayOfBatchError $batchErrors = null)
    {
        if (is_null($batchErrors) || (is_array($batchErrors) && empty($batchErrors))) {
            unset($this->BatchErrors);
        } else {
            $this->BatchErrors = $batchErrors;
        }
        return $this;
    }
    /**
     * Get OperationErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfOperationError|null
     */
    public function getOperationErrors()
    {
        return isset($this->OperationErrors) ? $this->OperationErrors : null;
    }
    /**
     * Set OperationErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfOperationError $operationErrors
     * @return \StructType\ApiFaultDetail
     */
    public function setOperationErrors(\ArrayType\ArrayOfOperationError $operationErrors = null)
    {
        if (is_null($operationErrors) || (is_array($operationErrors) && empty($operationErrors))) {
            unset($this->OperationErrors);
        } else {
            $this->OperationErrors = $operationErrors;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ApiFaultDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
