<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountPerformanceReportFilter StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AccountPerformanceReportFilter
 * @subpackage Structs
 */
class AccountPerformanceReportFilter extends AbstractStructBase
{
    /**
     * The AccountStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AccountStatus;
    /**
     * The AdDistribution
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AdDistribution;
    /**
     * The DeviceOS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $DeviceOS;
    /**
     * The DeviceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $DeviceType;
    /**
     * Constructor method for AccountPerformanceReportFilter
     * @uses AccountPerformanceReportFilter::setAccountStatus()
     * @uses AccountPerformanceReportFilter::setAdDistribution()
     * @uses AccountPerformanceReportFilter::setDeviceOS()
     * @uses AccountPerformanceReportFilter::setDeviceType()
     * @param string[] $accountStatus
     * @param string[] $adDistribution
     * @param string[] $deviceOS
     * @param string[] $deviceType
     */
    public function __construct(array $accountStatus = array(), array $adDistribution = array(), array $deviceOS = array(), array $deviceType = array())
    {
        $this
            ->setAccountStatus($accountStatus)
            ->setAdDistribution($adDistribution)
            ->setDeviceOS($deviceOS)
            ->setDeviceType($deviceType);
    }
    /**
     * Get AccountStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAccountStatus()
    {
        return isset($this->AccountStatus) ? $this->AccountStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountStatusForArrayConstraintsFromSetAccountStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountPerformanceReportFilterAccountStatusItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AccountStatusReportFilter::valueIsValid($accountPerformanceReportFilterAccountStatusItem)) {
                $invalidValues[] = is_object($accountPerformanceReportFilterAccountStatusItem) ? get_class($accountPerformanceReportFilterAccountStatusItem) : sprintf('%s(%s)', gettype($accountPerformanceReportFilterAccountStatusItem), var_export($accountPerformanceReportFilterAccountStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountStatusReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AccountStatusReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccountStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AccountStatusReportFilter::valueIsValid()
     * @uses \EnumType\AccountStatusReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accountStatus
     * @return \StructType\AccountPerformanceReportFilter
     */
    public function setAccountStatus(array $accountStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($accountStatusArrayErrorMessage = self::validateAccountStatusForArrayConstraintsFromSetAccountStatus($accountStatus))) {
            throw new \InvalidArgumentException($accountStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($accountStatus) || (is_array($accountStatus) && empty($accountStatus))) {
            unset($this->AccountStatus);
        } else {
            $this->AccountStatus = is_array($accountStatus) ? implode(' ', $accountStatus) : null;
        }
        return $this;
    }
    /**
     * Get AdDistribution value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAdDistribution()
    {
        return isset($this->AdDistribution) ? $this->AdDistribution : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdDistribution method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdDistribution method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdDistributionForArrayConstraintsFromSetAdDistribution(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountPerformanceReportFilterAdDistributionItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdDistributionReportFilter::valueIsValid($accountPerformanceReportFilterAdDistributionItem)) {
                $invalidValues[] = is_object($accountPerformanceReportFilterAdDistributionItem) ? get_class($accountPerformanceReportFilterAdDistributionItem) : sprintf('%s(%s)', gettype($accountPerformanceReportFilterAdDistributionItem), var_export($accountPerformanceReportFilterAdDistributionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdDistributionReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdDistributionReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdDistribution value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdDistributionReportFilter::valueIsValid()
     * @uses \EnumType\AdDistributionReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $adDistribution
     * @return \StructType\AccountPerformanceReportFilter
     */
    public function setAdDistribution(array $adDistribution = array())
    {
        // validation for constraint: list
        if ('' !== ($adDistributionArrayErrorMessage = self::validateAdDistributionForArrayConstraintsFromSetAdDistribution($adDistribution))) {
            throw new \InvalidArgumentException($adDistributionArrayErrorMessage, __LINE__);
        }
        if (is_null($adDistribution) || (is_array($adDistribution) && empty($adDistribution))) {
            unset($this->AdDistribution);
        } else {
            $this->AdDistribution = is_array($adDistribution) ? implode(' ', $adDistribution) : null;
        }
        return $this;
    }
    /**
     * Get DeviceOS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getDeviceOS()
    {
        return isset($this->DeviceOS) ? $this->DeviceOS : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDeviceOS method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeviceOS method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeviceOSForArrayConstraintsFromSetDeviceOS(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountPerformanceReportFilterDeviceOSItem) {
            // validation for constraint: enumeration
            if (!\EnumType\DeviceOSReportFilter::valueIsValid($accountPerformanceReportFilterDeviceOSItem)) {
                $invalidValues[] = is_object($accountPerformanceReportFilterDeviceOSItem) ? get_class($accountPerformanceReportFilterDeviceOSItem) : sprintf('%s(%s)', gettype($accountPerformanceReportFilterDeviceOSItem), var_export($accountPerformanceReportFilterDeviceOSItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DeviceOSReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\DeviceOSReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeviceOS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\DeviceOSReportFilter::valueIsValid()
     * @uses \EnumType\DeviceOSReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $deviceOS
     * @return \StructType\AccountPerformanceReportFilter
     */
    public function setDeviceOS(array $deviceOS = array())
    {
        // validation for constraint: list
        if ('' !== ($deviceOSArrayErrorMessage = self::validateDeviceOSForArrayConstraintsFromSetDeviceOS($deviceOS))) {
            throw new \InvalidArgumentException($deviceOSArrayErrorMessage, __LINE__);
        }
        if (is_null($deviceOS) || (is_array($deviceOS) && empty($deviceOS))) {
            unset($this->DeviceOS);
        } else {
            $this->DeviceOS = is_array($deviceOS) ? implode(' ', $deviceOS) : null;
        }
        return $this;
    }
    /**
     * Get DeviceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getDeviceType()
    {
        return isset($this->DeviceType) ? $this->DeviceType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDeviceType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeviceType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeviceTypeForArrayConstraintsFromSetDeviceType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountPerformanceReportFilterDeviceTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\DeviceTypeReportFilter::valueIsValid($accountPerformanceReportFilterDeviceTypeItem)) {
                $invalidValues[] = is_object($accountPerformanceReportFilterDeviceTypeItem) ? get_class($accountPerformanceReportFilterDeviceTypeItem) : sprintf('%s(%s)', gettype($accountPerformanceReportFilterDeviceTypeItem), var_export($accountPerformanceReportFilterDeviceTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DeviceTypeReportFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\DeviceTypeReportFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeviceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\DeviceTypeReportFilter::valueIsValid()
     * @uses \EnumType\DeviceTypeReportFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $deviceType
     * @return \StructType\AccountPerformanceReportFilter
     */
    public function setDeviceType(array $deviceType = array())
    {
        // validation for constraint: list
        if ('' !== ($deviceTypeArrayErrorMessage = self::validateDeviceTypeForArrayConstraintsFromSetDeviceType($deviceType))) {
            throw new \InvalidArgumentException($deviceTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($deviceType) || (is_array($deviceType) && empty($deviceType))) {
            unset($this->DeviceType);
        } else {
            $this->DeviceType = is_array($deviceType) ? implode(' ', $deviceType) : null;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountPerformanceReportFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
