<?php

namespace EnumType;

/**
 * This class stands for DeviceOSReportFilter EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeviceOSReportFilter
 * @subpackage Enumerations
 */
class DeviceOSReportFilter
{
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Constant for value 'Windows'
     * @return string 'Windows'
     */
    const VALUE_WINDOWS = 'Windows';
    /**
     * Constant for value 'iOS'
     * @return string 'iOS'
     */
    const VALUE_I_OS = 'iOS';
    /**
     * Constant for value 'Android'
     * @return string 'Android'
     */
    const VALUE_ANDROID = 'Android';
    /**
     * Constant for value 'BlackBerry'
     * @return string 'BlackBerry'
     */
    const VALUE_BLACK_BERRY = 'BlackBerry';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_WINDOWS
     * @uses self::VALUE_I_OS
     * @uses self::VALUE_ANDROID
     * @uses self::VALUE_BLACK_BERRY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OTHER,
            self::VALUE_WINDOWS,
            self::VALUE_I_OS,
            self::VALUE_ANDROID,
            self::VALUE_BLACK_BERRY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
