<?php

namespace EnumType;

/**
 * This class stands for ChangeTypeReportFilter EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ChangeTypeReportFilter
 * @subpackage Enumerations
 */
class ChangeTypeReportFilter
{
    /**
     * Constant for value 'Added'
     * @return string 'Added'
     */
    const VALUE_ADDED = 'Added';
    /**
     * Constant for value 'Deleted'
     * @return string 'Deleted'
     */
    const VALUE_DELETED = 'Deleted';
    /**
     * Constant for value 'Changed'
     * @return string 'Changed'
     */
    const VALUE_CHANGED = 'Changed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADDED
     * @uses self::VALUE_DELETED
     * @uses self::VALUE_CHANGED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADDED,
            self::VALUE_DELETED,
            self::VALUE_CHANGED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
