<?php

namespace EnumType;

/**
 * This class stands for CampaignStatusReportFilter EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CampaignStatusReportFilter
 * @subpackage Enumerations
 */
class CampaignStatusReportFilter
{
    /**
     * Constant for value 'Active'
     * @return string 'Active'
     */
    const VALUE_ACTIVE = 'Active';
    /**
     * Constant for value 'Deleted'
     * @return string 'Deleted'
     */
    const VALUE_DELETED = 'Deleted';
    /**
     * Constant for value 'Paused'
     * @return string 'Paused'
     */
    const VALUE_PAUSED = 'Paused';
    /**
     * Constant for value 'BudgetPaused'
     * @return string 'BudgetPaused'
     */
    const VALUE_BUDGET_PAUSED = 'BudgetPaused';
    /**
     * Constant for value 'Suspended'
     * @return string 'Suspended'
     */
    const VALUE_SUSPENDED = 'Suspended';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACTIVE
     * @uses self::VALUE_DELETED
     * @uses self::VALUE_PAUSED
     * @uses self::VALUE_BUDGET_PAUSED
     * @uses self::VALUE_SUSPENDED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACTIVE,
            self::VALUE_DELETED,
            self::VALUE_PAUSED,
            self::VALUE_BUDGET_PAUSED,
            self::VALUE_SUSPENDED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
