<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitStay StructType
 * @subpackage Structs
 */
class UnitStay extends UnitStayType
{
    /**
     * The ResGuestRPHs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH
     */
    public $ResGuestRPHs;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCommentTypeComment
     */
    public $Comments;
    /**
     * The SpecialRequests
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSpecialRequestTypeSpecialRequest
     */
    public $SpecialRequests;
    /**
     * The ServiceRPHs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfServiceRPHsTypeServiceRPH
     */
    public $ServiceRPHs;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Reference
     */
    public $Reference;
    /**
     * The IndexNumber
     * @var int
     */
    public $IndexNumber;
    /**
     * The UnitRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UnitRef
     */
    public $UnitRef;
    /**
     * The StayDateRange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DateTimeSpanType
     */
    public $StayDateRange;
    /**
     * The GuestCounts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GuestCountType
     */
    public $GuestCounts;
    /**
     * The DepositPayments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DepositPayments
     */
    public $DepositPayments;
    /**
     * The CancelPenalties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CancelPenalties
     */
    public $CancelPenalties;
    /**
     * The BasicUnitInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BasicUnitInfo
     */
    public $BasicUnitInfo;
    /**
     * The RentalAgreement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RentalAgreement
     */
    public $RentalAgreement;
    /**
     * The Pets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PetsPoliciesType
     */
    public $Pets;
    /**
     * The AdditionalCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AdditionalCharges
     */
    public $AdditionalCharges;
    /**
     * The AvailableOnlyIndicator
     * @var bool
     */
    public $AvailableOnlyIndicator;
    /**
     * Constructor method for UnitStay
     * @uses UnitStay::setResGuestRPHs()
     * @uses UnitStay::setComments()
     * @uses UnitStay::setSpecialRequests()
     * @uses UnitStay::setServiceRPHs()
     * @uses UnitStay::setReference()
     * @uses UnitStay::setIndexNumber()
     * @uses UnitStay::setUnitRef()
     * @uses UnitStay::setStayDateRange()
     * @uses UnitStay::setGuestCounts()
     * @uses UnitStay::setDepositPayments()
     * @uses UnitStay::setCancelPenalties()
     * @uses UnitStay::setBasicUnitInfo()
     * @uses UnitStay::setRentalAgreement()
     * @uses UnitStay::setPets()
     * @uses UnitStay::setAdditionalCharges()
     * @uses UnitStay::setAvailableOnlyIndicator()
     * @param \ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH $resGuestRPHs
     * @param \ArrayType\ArrayOfCommentTypeComment $comments
     * @param \ArrayType\ArrayOfSpecialRequestTypeSpecialRequest $specialRequests
     * @param \ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs
     * @param \StructType\Reference $reference
     * @param int $indexNumber
     * @param \StructType\UnitRef $unitRef
     * @param \StructType\DateTimeSpanType $stayDateRange
     * @param \StructType\GuestCountType $guestCounts
     * @param \StructType\DepositPayments $depositPayments
     * @param \StructType\CancelPenalties $cancelPenalties
     * @param \StructType\BasicUnitInfo $basicUnitInfo
     * @param \StructType\RentalAgreement $rentalAgreement
     * @param \StructType\PetsPoliciesType $pets
     * @param \StructType\AdditionalCharges $additionalCharges
     * @param bool $availableOnlyIndicator
     */
    public function __construct(\ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH $resGuestRPHs = null, \ArrayType\ArrayOfCommentTypeComment $comments = null, \ArrayType\ArrayOfSpecialRequestTypeSpecialRequest $specialRequests = null, \ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs = null, \StructType\Reference $reference = null, $indexNumber = null, \StructType\UnitRef $unitRef = null, \StructType\DateTimeSpanType $stayDateRange = null, \StructType\GuestCountType $guestCounts = null, \StructType\DepositPayments $depositPayments = null, \StructType\CancelPenalties $cancelPenalties = null, \StructType\BasicUnitInfo $basicUnitInfo = null, \StructType\RentalAgreement $rentalAgreement = null, \StructType\PetsPoliciesType $pets = null, \StructType\AdditionalCharges $additionalCharges = null, $availableOnlyIndicator = null)
    {
        $this
            ->setResGuestRPHs($resGuestRPHs)
            ->setComments($comments)
            ->setSpecialRequests($specialRequests)
            ->setServiceRPHs($serviceRPHs)
            ->setReference($reference)
            ->setIndexNumber($indexNumber)
            ->setUnitRef($unitRef)
            ->setStayDateRange($stayDateRange)
            ->setGuestCounts($guestCounts)
            ->setDepositPayments($depositPayments)
            ->setCancelPenalties($cancelPenalties)
            ->setBasicUnitInfo($basicUnitInfo)
            ->setRentalAgreement($rentalAgreement)
            ->setPets($pets)
            ->setAdditionalCharges($additionalCharges)
            ->setAvailableOnlyIndicator($availableOnlyIndicator);
    }
    /**
     * Get ResGuestRPHs value
     * @return \ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH|null
     */
    public function getResGuestRPHs()
    {
        return $this->ResGuestRPHs;
    }
    /**
     * Set ResGuestRPHs value
     * @param \ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH $resGuestRPHs
     * @return \StructType\UnitStay
     */
    public function setResGuestRPHs(\ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH $resGuestRPHs = null)
    {
        $this->ResGuestRPHs = $resGuestRPHs;
        return $this;
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfCommentTypeComment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfCommentTypeComment $comments
     * @return \StructType\UnitStay
     */
    public function setComments(\ArrayType\ArrayOfCommentTypeComment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get SpecialRequests value
     * @return \ArrayType\ArrayOfSpecialRequestTypeSpecialRequest|null
     */
    public function getSpecialRequests()
    {
        return $this->SpecialRequests;
    }
    /**
     * Set SpecialRequests value
     * @param \ArrayType\ArrayOfSpecialRequestTypeSpecialRequest $specialRequests
     * @return \StructType\UnitStay
     */
    public function setSpecialRequests(\ArrayType\ArrayOfSpecialRequestTypeSpecialRequest $specialRequests = null)
    {
        $this->SpecialRequests = $specialRequests;
        return $this;
    }
    /**
     * Get ServiceRPHs value
     * @return \ArrayType\ArrayOfServiceRPHsTypeServiceRPH|null
     */
    public function getServiceRPHs()
    {
        return $this->ServiceRPHs;
    }
    /**
     * Set ServiceRPHs value
     * @param \ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs
     * @return \StructType\UnitStay
     */
    public function setServiceRPHs(\ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs = null)
    {
        $this->ServiceRPHs = $serviceRPHs;
        return $this;
    }
    /**
     * Get Reference value
     * @return \StructType\Reference|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \StructType\Reference $reference
     * @return \StructType\UnitStay
     */
    public function setReference(\StructType\Reference $reference = null)
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get IndexNumber value
     * @return int|null
     */
    public function getIndexNumber()
    {
        return $this->IndexNumber;
    }
    /**
     * Set IndexNumber value
     * @param int $indexNumber
     * @return \StructType\UnitStay
     */
    public function setIndexNumber($indexNumber = null)
    {
        // validation for constraint: int
        if (!is_null($indexNumber) && !(is_int($indexNumber) || ctype_digit($indexNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($indexNumber, true), gettype($indexNumber)), __LINE__);
        }
        $this->IndexNumber = $indexNumber;
        return $this;
    }
    /**
     * Get UnitRef value
     * @return \StructType\UnitRef|null
     */
    public function getUnitRef()
    {
        return $this->UnitRef;
    }
    /**
     * Set UnitRef value
     * @param \StructType\UnitRef $unitRef
     * @return \StructType\UnitStay
     */
    public function setUnitRef(\StructType\UnitRef $unitRef = null)
    {
        $this->UnitRef = $unitRef;
        return $this;
    }
    /**
     * Get StayDateRange value
     * @return \StructType\DateTimeSpanType|null
     */
    public function getStayDateRange()
    {
        return $this->StayDateRange;
    }
    /**
     * Set StayDateRange value
     * @param \StructType\DateTimeSpanType $stayDateRange
     * @return \StructType\UnitStay
     */
    public function setStayDateRange(\StructType\DateTimeSpanType $stayDateRange = null)
    {
        $this->StayDateRange = $stayDateRange;
        return $this;
    }
    /**
     * Get GuestCounts value
     * @return \StructType\GuestCountType|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \StructType\GuestCountType $guestCounts
     * @return \StructType\UnitStay
     */
    public function setGuestCounts(\StructType\GuestCountType $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get DepositPayments value
     * @return \StructType\DepositPayments|null
     */
    public function getDepositPayments()
    {
        return $this->DepositPayments;
    }
    /**
     * Set DepositPayments value
     * @param \StructType\DepositPayments $depositPayments
     * @return \StructType\UnitStay
     */
    public function setDepositPayments(\StructType\DepositPayments $depositPayments = null)
    {
        $this->DepositPayments = $depositPayments;
        return $this;
    }
    /**
     * Get CancelPenalties value
     * @return \StructType\CancelPenalties|null
     */
    public function getCancelPenalties()
    {
        return $this->CancelPenalties;
    }
    /**
     * Set CancelPenalties value
     * @param \StructType\CancelPenalties $cancelPenalties
     * @return \StructType\UnitStay
     */
    public function setCancelPenalties(\StructType\CancelPenalties $cancelPenalties = null)
    {
        $this->CancelPenalties = $cancelPenalties;
        return $this;
    }
    /**
     * Get BasicUnitInfo value
     * @return \StructType\BasicUnitInfo|null
     */
    public function getBasicUnitInfo()
    {
        return $this->BasicUnitInfo;
    }
    /**
     * Set BasicUnitInfo value
     * @param \StructType\BasicUnitInfo $basicUnitInfo
     * @return \StructType\UnitStay
     */
    public function setBasicUnitInfo(\StructType\BasicUnitInfo $basicUnitInfo = null)
    {
        $this->BasicUnitInfo = $basicUnitInfo;
        return $this;
    }
    /**
     * Get RentalAgreement value
     * @return \StructType\RentalAgreement|null
     */
    public function getRentalAgreement()
    {
        return $this->RentalAgreement;
    }
    /**
     * Set RentalAgreement value
     * @param \StructType\RentalAgreement $rentalAgreement
     * @return \StructType\UnitStay
     */
    public function setRentalAgreement(\StructType\RentalAgreement $rentalAgreement = null)
    {
        $this->RentalAgreement = $rentalAgreement;
        return $this;
    }
    /**
     * Get Pets value
     * @return \StructType\PetsPoliciesType|null
     */
    public function getPets()
    {
        return $this->Pets;
    }
    /**
     * Set Pets value
     * @param \StructType\PetsPoliciesType $pets
     * @return \StructType\UnitStay
     */
    public function setPets(\StructType\PetsPoliciesType $pets = null)
    {
        $this->Pets = $pets;
        return $this;
    }
    /**
     * Get AdditionalCharges value
     * @return \StructType\AdditionalCharges|null
     */
    public function getAdditionalCharges()
    {
        return $this->AdditionalCharges;
    }
    /**
     * Set AdditionalCharges value
     * @param \StructType\AdditionalCharges $additionalCharges
     * @return \StructType\UnitStay
     */
    public function setAdditionalCharges(\StructType\AdditionalCharges $additionalCharges = null)
    {
        $this->AdditionalCharges = $additionalCharges;
        return $this;
    }
    /**
     * Get AvailableOnlyIndicator value
     * @return bool|null
     */
    public function getAvailableOnlyIndicator()
    {
        return $this->AvailableOnlyIndicator;
    }
    /**
     * Set AvailableOnlyIndicator value
     * @param bool $availableOnlyIndicator
     * @return \StructType\UnitStay
     */
    public function setAvailableOnlyIndicator($availableOnlyIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableOnlyIndicator) && !is_bool($availableOnlyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableOnlyIndicator, true), gettype($availableOnlyIndicator)), __LINE__);
        }
        $this->AvailableOnlyIndicator = $availableOnlyIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnitStay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
