<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://test.misiv.intra.misiv.fr/wsdl/ws_interface.php?v=3',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://test.misiv.intra.misiv.fr/wsdl/ws_interface.php?v=3',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Info ServiceType
 */
$info = new \ServiceType\Info($options);
/**
 * Sample call for InfoImmat operation/method
 */
if ($info->InfoImmat(new \StructType\InfoImmat_Req()) !== false) {
    print_r($info->getResult());
} else {
    print_r($info->getLastError());
}
/**
 * Sample call for InfoVIN operation/method
 */
if ($info->InfoVIN(new \StructType\InfoVIN_Req()) !== false) {
    print_r($info->getResult());
} else {
    print_r($info->getLastError());
}
/**
 * Sample call for InfoCoC operation/method
 */
if ($info->InfoCoC(new \StructType\InfoCoC_Req()) !== false) {
    print_r($info->getResult());
} else {
    print_r($info->getLastError());
}
/**
 * Samples for Editer ServiceType
 */
$editer = new \ServiceType\Editer($options);
/**
 * Sample call for Editer operation/method
 */
if ($editer->Editer(new \StructType\Editer_Req()) !== false) {
    print_r($editer->getResult());
} else {
    print_r($editer->getLastError());
}
/**
 * Samples for Chercher ServiceType
 */
$chercher = new \ServiceType\Chercher($options);
/**
 * Sample call for Chercher operation/method
 */
if ($chercher->Chercher(new \StructType\Chercher_Req()) !== false) {
    print_r($chercher->getResult());
} else {
    print_r($chercher->getLastError());
}
/**
 * Samples for Ouvrir ServiceType
 */
$ouvrir = new \ServiceType\Ouvrir($options);
/**
 * Sample call for Ouvrir operation/method
 */
if ($ouvrir->Ouvrir(new \StructType\Ouvrir_Req()) !== false) {
    print_r($ouvrir->getResult());
} else {
    print_r($ouvrir->getLastError());
}
/**
 * Samples for Sauver ServiceType
 */
$sauver = new \ServiceType\Sauver($options);
/**
 * Sample call for Sauver operation/method
 */
if ($sauver->Sauver(new \StructType\Sauver_Req()) !== false) {
    print_r($sauver->getResult());
} else {
    print_r($sauver->getLastError());
}
/**
 * Samples for Envoyer ServiceType
 */
$envoyer = new \ServiceType\Envoyer($options);
/**
 * Sample call for Envoyer operation/method
 */
if ($envoyer->Envoyer(new \StructType\Envoyer_Req()) !== false) {
    print_r($envoyer->getResult());
} else {
    print_r($envoyer->getLastError());
}
/**
 * Samples for Assistant ServiceType
 */
$assistant = new \ServiceType\Assistant($options);
/**
 * Sample call for AssistantImport operation/method
 */
if ($assistant->AssistantImport(new \StructType\AssistantImport_Req()) !== false) {
    print_r($assistant->getResult());
} else {
    print_r($assistant->getLastError());
}
/**
 * Samples for Archiver ServiceType
 */
$archiver = new \ServiceType\Archiver($options);
/**
 * Sample call for Archiver operation/method
 */
if ($archiver->Archiver(new \StructType\Archiver_Req()) !== false) {
    print_r($archiver->getResult());
} else {
    print_r($archiver->getLastError());
}
/**
 * Samples for Rechercher ServiceType
 */
$rechercher = new \ServiceType\Rechercher($options);
/**
 * Sample call for RechercherArchive operation/method
 */
if ($rechercher->RechercherArchive(new \StructType\RechercherArchive_Req()) !== false) {
    print_r($rechercher->getResult());
} else {
    print_r($rechercher->getLastError());
}
/**
 * Samples for Lire ServiceType
 */
$lire = new \ServiceType\Lire($options);
/**
 * Sample call for LireArchive operation/method
 */
if ($lire->LireArchive(new \StructType\LireArchive_Req()) !== false) {
    print_r($lire->getResult());
} else {
    print_r($lire->getLastError());
}
/**
 * Samples for Controle ServiceType
 */
$controle = new \ServiceType\Controle($options);
/**
 * Sample call for ControleSIV operation/method
 */
if ($controle->ControleSIV(new \StructType\ControleSIV_Req()) !== false) {
    print_r($controle->getResult());
} else {
    print_r($controle->getLastError());
}
/**
 * Samples for Importer ServiceType
 */
$importer = new \ServiceType\Importer($options);
/**
 * Sample call for Importer operation/method
 */
if ($importer->Importer(new \StructType\Importer_Req()) !== false) {
    print_r($importer->getResult());
} else {
    print_r($importer->getLastError());
}
