<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Importer ServiceType
 * @subpackage Services
 */
class Importer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Importer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Importer_Req $importerRepMsg
     * @return \StructType\Importer_Rep|bool
     */
    public function Importer(\StructType\Importer_Req $importerRepMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->Importer($importerRepMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Importer_Rep
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
