<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Titulaire StructType
 * @subpackage Structs
 */
class Titulaire extends AbstractStructBase
{
    /**
     * The NomPrenom
     * Meta information extracted from the WSDL
     * - choice: NomPrenom | PersonneMorale | NomPrenom | PersonneMorale | NomPrenom | RaisonSociale | NomPrenom | RaisonSociale | NomPrenom | RaisonSociale | NomPrenom | RaisonSociale | NomPrenom | RaisonSociale | NomPrenom | PersonneMorale | NomPrenom |
     * PersonneMorale | NomPrenom | RaisonSociale | NomPrenom | RaisonSociale | NomPrenom | RaisonSociale | NomPrenom | RaisonSociale | NomPrenom | RaisonSociale | NomPrenom | RaisonSociale | NomPrenom | PersonneMorale
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NomPrenom;
    /**
     * The PersonneMorale
     * Meta information extracted from the WSDL
     * - choice: NomPrenom | PersonneMorale | NomPrenom | PersonneMorale | NomPrenom | PersonneMorale | NomPrenom | PersonneMorale | NomPrenom | PersonneMorale | PersonnePhysique | PersonneMorale | PersonnePhysique | PersonneMorale
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PersonneMorale
     */
    public $PersonneMorale;
    /**
     * The RaisonSociale
     * Meta information extracted from the WSDL
     * - choice: NomPrenom | RaisonSociale | NomPrenom | RaisonSociale | NomPrenom | RaisonSociale | NomPrenom | RaisonSociale | NomPrenom | RaisonSociale | NomPrenom | RaisonSociale | NomPrenom | RaisonSociale | NomPrenom | RaisonSociale | NomPrenom |
     * RaisonSociale | NomPrenom | RaisonSociale | NomPrenom | RaisonSociale
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RaisonSociale;
    /**
     * The AgrementVHU
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AgrementVHU;
    /**
     * The PersonnePhysique
     * Meta information extracted from the WSDL
     * - choice: PersonnePhysique | PersonneMorale | PersonnePhysique | PersonneMorale
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PersonnePhysique
     */
    public $PersonnePhysique;
    /**
     * The AncienneAdresse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeAdresse
     */
    public $AncienneAdresse;
    /**
     * The NouvelleAdresse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeAdresse
     */
    public $NouvelleAdresse;
    /**
     * The Adresse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeAdresse
     */
    public $Adresse;
    /**
     * The DroitOpposition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $DroitOpposition;
    /**
     * The SIRET
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 14
     * - maxOccurs: 1
     * - minLength: 9
     * - minOccurs: 0
     * - pattern: [0-9]{9,14}
     * @var string
     */
    public $SIRET;
    /**
     * The SocieteCommerciale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SocieteCommerciale;
    /**
     * The SIREN
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 9
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{9}
     * @var string
     */
    public $SIREN;
    /**
     * The TelephonePortable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TelephonePortable;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Telephone;
    /**
     * Constructor method for Titulaire
     * @uses Titulaire::setNomPrenom()
     * @uses Titulaire::setPersonneMorale()
     * @uses Titulaire::setRaisonSociale()
     * @uses Titulaire::setAgrementVHU()
     * @uses Titulaire::setPersonnePhysique()
     * @uses Titulaire::setAncienneAdresse()
     * @uses Titulaire::setNouvelleAdresse()
     * @uses Titulaire::setAdresse()
     * @uses Titulaire::setDroitOpposition()
     * @uses Titulaire::setSIRET()
     * @uses Titulaire::setSocieteCommerciale()
     * @uses Titulaire::setSIREN()
     * @uses Titulaire::setTelephonePortable()
     * @uses Titulaire::setTelephone()
     * @param string $nomPrenom
     * @param \StructType\PersonneMorale $personneMorale
     * @param string $raisonSociale
     * @param string $agrementVHU
     * @param \StructType\PersonnePhysique $personnePhysique
     * @param \StructType\TypeAdresse $ancienneAdresse
     * @param \StructType\TypeAdresse $nouvelleAdresse
     * @param \StructType\TypeAdresse $adresse
     * @param bool $droitOpposition
     * @param string $sIRET
     * @param bool $societeCommerciale
     * @param string $sIREN
     * @param string $telephonePortable
     * @param string $telephone
     */
    public function __construct($nomPrenom = null, \StructType\PersonneMorale $personneMorale = null, $raisonSociale = null, $agrementVHU = null, \StructType\PersonnePhysique $personnePhysique = null, \StructType\TypeAdresse $ancienneAdresse = null, \StructType\TypeAdresse $nouvelleAdresse = null, \StructType\TypeAdresse $adresse = null, $droitOpposition = null, $sIRET = null, $societeCommerciale = null, $sIREN = null, $telephonePortable = null, $telephone = null)
    {
        $this
            ->setNomPrenom($nomPrenom)
            ->setPersonneMorale($personneMorale)
            ->setRaisonSociale($raisonSociale)
            ->setAgrementVHU($agrementVHU)
            ->setPersonnePhysique($personnePhysique)
            ->setAncienneAdresse($ancienneAdresse)
            ->setNouvelleAdresse($nouvelleAdresse)
            ->setAdresse($adresse)
            ->setDroitOpposition($droitOpposition)
            ->setSIRET($sIRET)
            ->setSocieteCommerciale($societeCommerciale)
            ->setSIREN($sIREN)
            ->setTelephonePortable($telephonePortable)
            ->setTelephone($telephone);
    }
    /**
     * Get NomPrenom value
     * @return string
     */
    public function getNomPrenom()
    {
        return isset($this->NomPrenom) ? $this->NomPrenom : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNomPrenom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNomPrenom method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNomPrenomForChoiceConstraintsFromSetNomPrenom($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PersonneMorale',
            'PersonneMorale',
            'RaisonSociale',
            'RaisonSociale',
            'RaisonSociale',
            'RaisonSociale',
            'RaisonSociale',
            'PersonneMorale',
            'PersonneMorale',
            'RaisonSociale',
            'RaisonSociale',
            'RaisonSociale',
            'RaisonSociale',
            'RaisonSociale',
            'RaisonSociale',
            'PersonneMorale',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property NomPrenom can\'t be set as the property %s is already set. Only one property must be set among these properties: NomPrenom, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set NomPrenom value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $nomPrenom
     * @return \StructType\Titulaire
     */
    public function setNomPrenom($nomPrenom = null)
    {
        // validation for constraint: string
        if (!is_null($nomPrenom) && !is_string($nomPrenom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomPrenom, true), gettype($nomPrenom)), __LINE__);
        }
        // validation for constraint: choice(NomPrenom, PersonneMorale, NomPrenom, PersonneMorale, NomPrenom, RaisonSociale, NomPrenom, RaisonSociale, NomPrenom, RaisonSociale, NomPrenom, RaisonSociale, NomPrenom, RaisonSociale, NomPrenom, PersonneMorale, NomPrenom, PersonneMorale, NomPrenom, RaisonSociale, NomPrenom, RaisonSociale, NomPrenom, RaisonSociale, NomPrenom, RaisonSociale, NomPrenom, RaisonSociale, NomPrenom, RaisonSociale, NomPrenom, PersonneMorale)
        if ('' !== ($nomPrenomChoiceErrorMessage = self::validateNomPrenomForChoiceConstraintsFromSetNomPrenom($nomPrenom))) {
            throw new \InvalidArgumentException($nomPrenomChoiceErrorMessage, __LINE__);
        }
        if (is_null($nomPrenom) || (is_array($nomPrenom) && empty($nomPrenom))) {
            unset($this->NomPrenom);
        } else {
            $this->NomPrenom = $nomPrenom;
        }
        return $this;
    }
    /**
     * Get PersonneMorale value
     * @return \StructType\PersonneMorale
     */
    public function getPersonneMorale()
    {
        return isset($this->PersonneMorale) ? $this->PersonneMorale : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPersonneMorale method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonneMorale method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePersonneMoraleForChoiceConstraintsFromSetPersonneMorale($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'NomPrenom',
            'NomPrenom',
            'NomPrenom',
            'NomPrenom',
            'NomPrenom',
            'PersonnePhysique',
            'PersonnePhysique',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PersonneMorale can\'t be set as the property %s is already set. Only one property must be set among these properties: PersonneMorale, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PersonneMorale value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PersonneMorale $personneMorale
     * @return \StructType\Titulaire
     */
    public function setPersonneMorale(\StructType\PersonneMorale $personneMorale = null)
    {
        // validation for constraint: choice(NomPrenom, PersonneMorale, NomPrenom, PersonneMorale, NomPrenom, PersonneMorale, NomPrenom, PersonneMorale, NomPrenom, PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique, PersonneMorale)
        if ('' !== ($personneMoraleChoiceErrorMessage = self::validatePersonneMoraleForChoiceConstraintsFromSetPersonneMorale($personneMorale))) {
            throw new \InvalidArgumentException($personneMoraleChoiceErrorMessage, __LINE__);
        }
        if (is_null($personneMorale) || (is_array($personneMorale) && empty($personneMorale))) {
            unset($this->PersonneMorale);
        } else {
            $this->PersonneMorale = $personneMorale;
        }
        return $this;
    }
    /**
     * Get RaisonSociale value
     * @return string
     */
    public function getRaisonSociale()
    {
        return isset($this->RaisonSociale) ? $this->RaisonSociale : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRaisonSociale method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRaisonSociale method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRaisonSocialeForChoiceConstraintsFromSetRaisonSociale($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'NomPrenom',
            'NomPrenom',
            'NomPrenom',
            'NomPrenom',
            'NomPrenom',
            'NomPrenom',
            'NomPrenom',
            'NomPrenom',
            'NomPrenom',
            'NomPrenom',
            'NomPrenom',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RaisonSociale can\'t be set as the property %s is already set. Only one property must be set among these properties: RaisonSociale, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set RaisonSociale value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $raisonSociale
     * @return \StructType\Titulaire
     */
    public function setRaisonSociale($raisonSociale = null)
    {
        // validation for constraint: string
        if (!is_null($raisonSociale) && !is_string($raisonSociale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($raisonSociale, true), gettype($raisonSociale)), __LINE__);
        }
        // validation for constraint: choice(NomPrenom, RaisonSociale, NomPrenom, RaisonSociale, NomPrenom, RaisonSociale, NomPrenom, RaisonSociale, NomPrenom, RaisonSociale, NomPrenom, RaisonSociale, NomPrenom, RaisonSociale, NomPrenom, RaisonSociale, NomPrenom, RaisonSociale, NomPrenom, RaisonSociale, NomPrenom, RaisonSociale)
        if ('' !== ($raisonSocialeChoiceErrorMessage = self::validateRaisonSocialeForChoiceConstraintsFromSetRaisonSociale($raisonSociale))) {
            throw new \InvalidArgumentException($raisonSocialeChoiceErrorMessage, __LINE__);
        }
        if (is_null($raisonSociale) || (is_array($raisonSociale) && empty($raisonSociale))) {
            unset($this->RaisonSociale);
        } else {
            $this->RaisonSociale = $raisonSociale;
        }
        return $this;
    }
    /**
     * Get AgrementVHU value
     * @return string
     */
    public function getAgrementVHU()
    {
        return $this->AgrementVHU;
    }
    /**
     * Set AgrementVHU value
     * @param string $agrementVHU
     * @return \StructType\Titulaire
     */
    public function setAgrementVHU($agrementVHU = null)
    {
        // validation for constraint: string
        if (!is_null($agrementVHU) && !is_string($agrementVHU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agrementVHU, true), gettype($agrementVHU)), __LINE__);
        }
        $this->AgrementVHU = $agrementVHU;
        return $this;
    }
    /**
     * Get PersonnePhysique value
     * @return \StructType\PersonnePhysique
     */
    public function getPersonnePhysique()
    {
        return isset($this->PersonnePhysique) ? $this->PersonnePhysique : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPersonnePhysique method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonnePhysique method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePersonnePhysiqueForChoiceConstraintsFromSetPersonnePhysique($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PersonneMorale',
            'PersonneMorale',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PersonnePhysique can\'t be set as the property %s is already set. Only one property must be set among these properties: PersonnePhysique, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PersonnePhysique value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PersonnePhysique $personnePhysique
     * @return \StructType\Titulaire
     */
    public function setPersonnePhysique(\StructType\PersonnePhysique $personnePhysique = null)
    {
        // validation for constraint: choice(PersonnePhysique, PersonneMorale, PersonnePhysique, PersonneMorale)
        if ('' !== ($personnePhysiqueChoiceErrorMessage = self::validatePersonnePhysiqueForChoiceConstraintsFromSetPersonnePhysique($personnePhysique))) {
            throw new \InvalidArgumentException($personnePhysiqueChoiceErrorMessage, __LINE__);
        }
        if (is_null($personnePhysique) || (is_array($personnePhysique) && empty($personnePhysique))) {
            unset($this->PersonnePhysique);
        } else {
            $this->PersonnePhysique = $personnePhysique;
        }
        return $this;
    }
    /**
     * Get AncienneAdresse value
     * @return \StructType\TypeAdresse
     */
    public function getAncienneAdresse()
    {
        return $this->AncienneAdresse;
    }
    /**
     * Set AncienneAdresse value
     * @param \StructType\TypeAdresse $ancienneAdresse
     * @return \StructType\Titulaire
     */
    public function setAncienneAdresse(\StructType\TypeAdresse $ancienneAdresse = null)
    {
        $this->AncienneAdresse = $ancienneAdresse;
        return $this;
    }
    /**
     * Get NouvelleAdresse value
     * @return \StructType\TypeAdresse
     */
    public function getNouvelleAdresse()
    {
        return $this->NouvelleAdresse;
    }
    /**
     * Set NouvelleAdresse value
     * @param \StructType\TypeAdresse $nouvelleAdresse
     * @return \StructType\Titulaire
     */
    public function setNouvelleAdresse(\StructType\TypeAdresse $nouvelleAdresse = null)
    {
        $this->NouvelleAdresse = $nouvelleAdresse;
        return $this;
    }
    /**
     * Get Adresse value
     * @return \StructType\TypeAdresse
     */
    public function getAdresse()
    {
        return $this->Adresse;
    }
    /**
     * Set Adresse value
     * @param \StructType\TypeAdresse $adresse
     * @return \StructType\Titulaire
     */
    public function setAdresse(\StructType\TypeAdresse $adresse = null)
    {
        $this->Adresse = $adresse;
        return $this;
    }
    /**
     * Get DroitOpposition value
     * @return bool|null
     */
    public function getDroitOpposition()
    {
        return $this->DroitOpposition;
    }
    /**
     * Set DroitOpposition value
     * @param bool $droitOpposition
     * @return \StructType\Titulaire
     */
    public function setDroitOpposition($droitOpposition = null)
    {
        // validation for constraint: boolean
        if (!is_null($droitOpposition) && !is_bool($droitOpposition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($droitOpposition, true), gettype($droitOpposition)), __LINE__);
        }
        $this->DroitOpposition = $droitOpposition;
        return $this;
    }
    /**
     * Get SIRET value
     * @return string|null
     */
    public function getSIRET()
    {
        return $this->SIRET;
    }
    /**
     * Set SIRET value
     * @param string $sIRET
     * @return \StructType\Titulaire
     */
    public function setSIRET($sIRET = null)
    {
        // validation for constraint: string
        if (!is_null($sIRET) && !is_string($sIRET)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sIRET, true), gettype($sIRET)), __LINE__);
        }
        // validation for constraint: maxLength(14)
        if (!is_null($sIRET) && mb_strlen($sIRET) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 14', mb_strlen($sIRET)), __LINE__);
        }
        // validation for constraint: minLength(9)
        if (!is_null($sIRET) && mb_strlen($sIRET) < 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 9', mb_strlen($sIRET)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{9,14})
        if (!is_null($sIRET) && !preg_match('/[0-9]{9,14}/', $sIRET)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{9,14}', var_export($sIRET, true)), __LINE__);
        }
        $this->SIRET = $sIRET;
        return $this;
    }
    /**
     * Get SocieteCommerciale value
     * @return bool|null
     */
    public function getSocieteCommerciale()
    {
        return $this->SocieteCommerciale;
    }
    /**
     * Set SocieteCommerciale value
     * @param bool $societeCommerciale
     * @return \StructType\Titulaire
     */
    public function setSocieteCommerciale($societeCommerciale = null)
    {
        // validation for constraint: boolean
        if (!is_null($societeCommerciale) && !is_bool($societeCommerciale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($societeCommerciale, true), gettype($societeCommerciale)), __LINE__);
        }
        $this->SocieteCommerciale = $societeCommerciale;
        return $this;
    }
    /**
     * Get SIREN value
     * @return string|null
     */
    public function getSIREN()
    {
        return $this->SIREN;
    }
    /**
     * Set SIREN value
     * @param string $sIREN
     * @return \StructType\Titulaire
     */
    public function setSIREN($sIREN = null)
    {
        // validation for constraint: string
        if (!is_null($sIREN) && !is_string($sIREN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sIREN, true), gettype($sIREN)), __LINE__);
        }
        // validation for constraint: length(9)
        if (!is_null($sIREN) && mb_strlen($sIREN) !== 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 9', mb_strlen($sIREN)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{9})
        if (!is_null($sIREN) && !preg_match('/[0-9]{9}/', $sIREN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{9}', var_export($sIREN, true)), __LINE__);
        }
        $this->SIREN = $sIREN;
        return $this;
    }
    /**
     * Get TelephonePortable value
     * @return string|null
     */
    public function getTelephonePortable()
    {
        return $this->TelephonePortable;
    }
    /**
     * Set TelephonePortable value
     * @param string $telephonePortable
     * @return \StructType\Titulaire
     */
    public function setTelephonePortable($telephonePortable = null)
    {
        // validation for constraint: string
        if (!is_null($telephonePortable) && !is_string($telephonePortable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telephonePortable, true), gettype($telephonePortable)), __LINE__);
        }
        $this->TelephonePortable = $telephonePortable;
        return $this;
    }
    /**
     * Get Telephone value
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param string $telephone
     * @return \StructType\Titulaire
     */
    public function setTelephone($telephone = null)
    {
        // validation for constraint: string
        if (!is_null($telephone) && !is_string($telephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telephone, true), gettype($telephone)), __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
}
