<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ouvrir_Rep StructType
 * @subpackage Structs
 */
class Ouvrir_Rep extends AbstractStructBase
{
    /**
     * The Demarche
     * Meta information extracted from the WSDL
     * - choice: Demarche | Erreur | Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeDemarche
     */
    public $Demarche;
    /**
     * The Erreur
     * Meta information extracted from the WSDL
     * - choice: Demarche | Erreur | Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Erreur;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - choice: Demarche | Erreur | Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Code;
    /**
     * The Canal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Canal;
    /**
     * Constructor method for Ouvrir_Rep
     * @uses Ouvrir_Rep::setDemarche()
     * @uses Ouvrir_Rep::setErreur()
     * @uses Ouvrir_Rep::setCode()
     * @uses Ouvrir_Rep::setCanal()
     * @param \StructType\TypeDemarche $demarche
     * @param string $erreur
     * @param int $code
     * @param string $canal
     */
    public function __construct(\StructType\TypeDemarche $demarche = null, $erreur = null, $code = null, $canal = null)
    {
        $this
            ->setDemarche($demarche)
            ->setErreur($erreur)
            ->setCode($code)
            ->setCanal($canal);
    }
    /**
     * Get Demarche value
     * @return \StructType\TypeDemarche
     */
    public function getDemarche()
    {
        return isset($this->Demarche) ? $this->Demarche : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDemarche method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDemarche method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDemarcheForChoiceConstraintsFromSetDemarche($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Erreur',
            'Code',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Demarche can\'t be set as the property %s is already set. Only one property must be set among these properties: Demarche, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Demarche value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TypeDemarche $demarche
     * @return \StructType\Ouvrir_Rep
     */
    public function setDemarche(\StructType\TypeDemarche $demarche = null)
    {
        // validation for constraint: choice(Demarche, Erreur, Code)
        if ('' !== ($demarcheChoiceErrorMessage = self::validateDemarcheForChoiceConstraintsFromSetDemarche($demarche))) {
            throw new \InvalidArgumentException($demarcheChoiceErrorMessage, __LINE__);
        }
        if (is_null($demarche) || (is_array($demarche) && empty($demarche))) {
            unset($this->Demarche);
        } else {
            $this->Demarche = $demarche;
        }
        return $this;
    }
    /**
     * Get Erreur value
     * @return string
     */
    public function getErreur()
    {
        return isset($this->Erreur) ? $this->Erreur : null;
    }
    /**
     * This method is responsible for validating the value passed to the setErreur method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErreur method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateErreurForChoiceConstraintsFromSetErreur($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Demarche',
            'Code',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Erreur can\'t be set as the property %s is already set. Only one property must be set among these properties: Erreur, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Erreur value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $erreur
     * @return \StructType\Ouvrir_Rep
     */
    public function setErreur($erreur = null)
    {
        // validation for constraint: string
        if (!is_null($erreur) && !is_string($erreur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erreur, true), gettype($erreur)), __LINE__);
        }
        // validation for constraint: choice(Demarche, Erreur, Code)
        if ('' !== ($erreurChoiceErrorMessage = self::validateErreurForChoiceConstraintsFromSetErreur($erreur))) {
            throw new \InvalidArgumentException($erreurChoiceErrorMessage, __LINE__);
        }
        if (is_null($erreur) || (is_array($erreur) && empty($erreur))) {
            unset($this->Erreur);
        } else {
            $this->Erreur = $erreur;
        }
        return $this;
    }
    /**
     * Get Code value
     * @return int|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCode method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCodeForChoiceConstraintsFromSetCode($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Demarche',
            'Erreur',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Code can\'t be set as the property %s is already set. Only one property must be set among these properties: Code, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Code value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $code
     * @return \StructType\Ouvrir_Rep
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: choice(Demarche, Erreur, Code)
        if ('' !== ($codeChoiceErrorMessage = self::validateCodeForChoiceConstraintsFromSetCode($code))) {
            throw new \InvalidArgumentException($codeChoiceErrorMessage, __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get Canal value
     * @return string|null
     */
    public function getCanal()
    {
        return $this->Canal;
    }
    /**
     * Set Canal value
     * @uses \EnumType\TypeCanal::valueIsValid()
     * @uses \EnumType\TypeCanal::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $canal
     * @return \StructType\Ouvrir_Rep
     */
    public function setCanal($canal = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeCanal::valueIsValid($canal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeCanal', is_array($canal) ? implode(', ', $canal) : var_export($canal, true), implode(', ', \EnumType\TypeCanal::getValidValues())), __LINE__);
        }
        $this->Canal = $canal;
        return $this;
    }
}
