<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TypeVBD StructType
 * @subpackage Structs
 */
class TypeVBD extends AbstractStructBase
{
    /**
     * The VIN
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - pattern: [0-9A-Z]*
     * @var string
     */
    public $VIN;
    /**
     * The Immatriculation
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 6
     * - minOccurs: 1
     * - pattern: ([A-Z]{1,2}(-|\s)?\d{2,3}(-|\s)?[A-Z]{1,2})|(\d{1,4}\s?[A-Z]{2,3}\s?(2[AB]|\d{1,3}))
     * @var string
     */
    public $Immatriculation;
    /**
     * The CIPresent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CIPresent;
    /**
     * The D1_Marque
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $D1_Marque;
    /**
     * The D2_Version
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $D2_Version;
    /**
     * The Communautaire
     * Meta information extracted from the WSDL
     * - choice: Communautaire
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Communautaire
     */
    public $Communautaire;
    /**
     * The F1_MMaxTechAdm
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 5
     * @var int
     */
    public $F1_MMaxTechAdm;
    /**
     * The F2_MMaxAdmServ
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 5
     * @var int
     */
    public $F2_MMaxAdmServ;
    /**
     * The S1_NbPlaceAssise
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 3
     * @var int
     */
    public $S1_NbPlaceAssise;
    /**
     * The NumFormule
     * Meta information extracted from the WSDL
     * - choice: NumFormule | DateCI
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumFormule;
    /**
     * The DateCI
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: NumFormule | DateCI
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateCI;
    /**
     * The Couleur
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Couleur;
    /**
     * Constructor method for TypeVBD
     * @uses TypeVBD::setVIN()
     * @uses TypeVBD::setImmatriculation()
     * @uses TypeVBD::setCIPresent()
     * @uses TypeVBD::setD1_Marque()
     * @uses TypeVBD::setD2_Version()
     * @uses TypeVBD::setCommunautaire()
     * @uses TypeVBD::setF1_MMaxTechAdm()
     * @uses TypeVBD::setF2_MMaxAdmServ()
     * @uses TypeVBD::setS1_NbPlaceAssise()
     * @uses TypeVBD::setNumFormule()
     * @uses TypeVBD::setDateCI()
     * @uses TypeVBD::setCouleur()
     * @param string $vIN
     * @param string $immatriculation
     * @param bool $cIPresent
     * @param string $d1_Marque
     * @param string $d2_Version
     * @param \StructType\Communautaire $communautaire
     * @param int $f1_MMaxTechAdm
     * @param int $f2_MMaxAdmServ
     * @param int $s1_NbPlaceAssise
     * @param string $numFormule
     * @param string $dateCI
     * @param string $couleur
     */
    public function __construct($vIN = null, $immatriculation = null, $cIPresent = null, $d1_Marque = null, $d2_Version = null, \StructType\Communautaire $communautaire = null, $f1_MMaxTechAdm = null, $f2_MMaxAdmServ = null, $s1_NbPlaceAssise = null, $numFormule = null, $dateCI = null, $couleur = null)
    {
        $this
            ->setVIN($vIN)
            ->setImmatriculation($immatriculation)
            ->setCIPresent($cIPresent)
            ->setD1_Marque($d1_Marque)
            ->setD2_Version($d2_Version)
            ->setCommunautaire($communautaire)
            ->setF1_MMaxTechAdm($f1_MMaxTechAdm)
            ->setF2_MMaxAdmServ($f2_MMaxAdmServ)
            ->setS1_NbPlaceAssise($s1_NbPlaceAssise)
            ->setNumFormule($numFormule)
            ->setDateCI($dateCI)
            ->setCouleur($couleur);
    }
    /**
     * Get VIN value
     * @return string
     */
    public function getVIN()
    {
        return $this->VIN;
    }
    /**
     * Set VIN value
     * @param string $vIN
     * @return \StructType\TypeVBD
     */
    public function setVIN($vIN = null)
    {
        // validation for constraint: string
        if (!is_null($vIN) && !is_string($vIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vIN, true), gettype($vIN)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($vIN) && mb_strlen($vIN) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($vIN)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($vIN) && mb_strlen($vIN) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($vIN)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]*)
        if (!is_null($vIN) && !preg_match('/[0-9A-Z]*/', $vIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]*', var_export($vIN, true)), __LINE__);
        }
        $this->VIN = $vIN;
        return $this;
    }
    /**
     * Get Immatriculation value
     * @return string
     */
    public function getImmatriculation()
    {
        return $this->Immatriculation;
    }
    /**
     * Set Immatriculation value
     * @param string $immatriculation
     * @return \StructType\TypeVBD
     */
    public function setImmatriculation($immatriculation = null)
    {
        // validation for constraint: string
        if (!is_null($immatriculation) && !is_string($immatriculation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($immatriculation, true), gettype($immatriculation)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($immatriculation) && mb_strlen($immatriculation) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($immatriculation)), __LINE__);
        }
        // validation for constraint: minLength(6)
        if (!is_null($immatriculation) && mb_strlen($immatriculation) < 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 6', mb_strlen($immatriculation)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{1,2}(-|\s)?\d{2,3}(-|\s)?[A-Z]{1,2})|(\d{1,4}\s?[A-Z]{2,3}\s?(2[AB]|\d{1,3})))
        if (!is_null($immatriculation) && !preg_match('/([A-Z]{1,2}(-|\\s)?\\d{2,3}(-|\\s)?[A-Z]{1,2})|(\\d{1,4}\\s?[A-Z]{2,3}\\s?(2[AB]|\\d{1,3}))/', $immatriculation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{1,2}(-|\s)?\d{2,3}(-|\s)?[A-Z]{1,2})|(\d{1,4}\s?[A-Z]{2,3}\s?(2[AB]|\d{1,3}))', var_export($immatriculation, true)), __LINE__);
        }
        $this->Immatriculation = $immatriculation;
        return $this;
    }
    /**
     * Get CIPresent value
     * @return bool
     */
    public function getCIPresent()
    {
        return $this->CIPresent;
    }
    /**
     * Set CIPresent value
     * @param bool $cIPresent
     * @return \StructType\TypeVBD
     */
    public function setCIPresent($cIPresent = null)
    {
        // validation for constraint: boolean
        if (!is_null($cIPresent) && !is_bool($cIPresent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cIPresent, true), gettype($cIPresent)), __LINE__);
        }
        $this->CIPresent = $cIPresent;
        return $this;
    }
    /**
     * Get D1_Marque value
     * @return string
     */
    public function getD1_Marque()
    {
        return $this->D1_Marque;
    }
    /**
     * Set D1_Marque value
     * @param string $d1_Marque
     * @return \StructType\TypeVBD
     */
    public function setD1_Marque($d1_Marque = null)
    {
        // validation for constraint: string
        if (!is_null($d1_Marque) && !is_string($d1_Marque)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($d1_Marque, true), gettype($d1_Marque)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($d1_Marque) && mb_strlen($d1_Marque) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($d1_Marque)), __LINE__);
        }
        $this->D1_Marque = $d1_Marque;
        return $this;
    }
    /**
     * Get D2_Version value
     * @return string
     */
    public function getD2_Version()
    {
        return $this->D2_Version;
    }
    /**
     * Set D2_Version value
     * @param string $d2_Version
     * @return \StructType\TypeVBD
     */
    public function setD2_Version($d2_Version = null)
    {
        // validation for constraint: string
        if (!is_null($d2_Version) && !is_string($d2_Version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($d2_Version, true), gettype($d2_Version)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($d2_Version) && mb_strlen($d2_Version) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($d2_Version)), __LINE__);
        }
        $this->D2_Version = $d2_Version;
        return $this;
    }
    /**
     * Get Communautaire value
     * @return \StructType\Communautaire
     */
    public function getCommunautaire()
    {
        return isset($this->Communautaire) ? $this->Communautaire : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCommunautaire method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommunautaire method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCommunautaireForChoiceConstraintsFromSetCommunautaire($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Communautaire can\'t be set as the property %s is already set. Only one property must be set among these properties: Communautaire, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Communautaire value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Communautaire $communautaire
     * @return \StructType\TypeVBD
     */
    public function setCommunautaire(\StructType\Communautaire $communautaire = null)
    {
        // validation for constraint: choice(Communautaire)
        if ('' !== ($communautaireChoiceErrorMessage = self::validateCommunautaireForChoiceConstraintsFromSetCommunautaire($communautaire))) {
            throw new \InvalidArgumentException($communautaireChoiceErrorMessage, __LINE__);
        }
        if (is_null($communautaire) || (is_array($communautaire) && empty($communautaire))) {
            unset($this->Communautaire);
        } else {
            $this->Communautaire = $communautaire;
        }
        return $this;
    }
    /**
     * Get F1_MMaxTechAdm value
     * @return int
     */
    public function getF1_MMaxTechAdm()
    {
        return $this->F1_MMaxTechAdm;
    }
    /**
     * Set F1_MMaxTechAdm value
     * @param int $f1_MMaxTechAdm
     * @return \StructType\TypeVBD
     */
    public function setF1_MMaxTechAdm($f1_MMaxTechAdm = null)
    {
        // validation for constraint: int
        if (!is_null($f1_MMaxTechAdm) && !(is_int($f1_MMaxTechAdm) || ctype_digit($f1_MMaxTechAdm))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($f1_MMaxTechAdm, true), gettype($f1_MMaxTechAdm)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($f1_MMaxTechAdm) && mb_strlen(preg_replace('/(\D)/', '', $f1_MMaxTechAdm)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($f1_MMaxTechAdm, true), mb_strlen(preg_replace('/(\D)/', '', $f1_MMaxTechAdm))), __LINE__);
        }
        $this->F1_MMaxTechAdm = $f1_MMaxTechAdm;
        return $this;
    }
    /**
     * Get F2_MMaxAdmServ value
     * @return int
     */
    public function getF2_MMaxAdmServ()
    {
        return $this->F2_MMaxAdmServ;
    }
    /**
     * Set F2_MMaxAdmServ value
     * @param int $f2_MMaxAdmServ
     * @return \StructType\TypeVBD
     */
    public function setF2_MMaxAdmServ($f2_MMaxAdmServ = null)
    {
        // validation for constraint: int
        if (!is_null($f2_MMaxAdmServ) && !(is_int($f2_MMaxAdmServ) || ctype_digit($f2_MMaxAdmServ))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($f2_MMaxAdmServ, true), gettype($f2_MMaxAdmServ)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($f2_MMaxAdmServ) && mb_strlen(preg_replace('/(\D)/', '', $f2_MMaxAdmServ)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($f2_MMaxAdmServ, true), mb_strlen(preg_replace('/(\D)/', '', $f2_MMaxAdmServ))), __LINE__);
        }
        $this->F2_MMaxAdmServ = $f2_MMaxAdmServ;
        return $this;
    }
    /**
     * Get S1_NbPlaceAssise value
     * @return int
     */
    public function getS1_NbPlaceAssise()
    {
        return $this->S1_NbPlaceAssise;
    }
    /**
     * Set S1_NbPlaceAssise value
     * @param int $s1_NbPlaceAssise
     * @return \StructType\TypeVBD
     */
    public function setS1_NbPlaceAssise($s1_NbPlaceAssise = null)
    {
        // validation for constraint: int
        if (!is_null($s1_NbPlaceAssise) && !(is_int($s1_NbPlaceAssise) || ctype_digit($s1_NbPlaceAssise))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($s1_NbPlaceAssise, true), gettype($s1_NbPlaceAssise)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($s1_NbPlaceAssise) && mb_strlen(preg_replace('/(\D)/', '', $s1_NbPlaceAssise)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($s1_NbPlaceAssise, true), mb_strlen(preg_replace('/(\D)/', '', $s1_NbPlaceAssise))), __LINE__);
        }
        $this->S1_NbPlaceAssise = $s1_NbPlaceAssise;
        return $this;
    }
    /**
     * Get NumFormule value
     * @return string|null
     */
    public function getNumFormule()
    {
        return isset($this->NumFormule) ? $this->NumFormule : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNumFormule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNumFormule method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNumFormuleForChoiceConstraintsFromSetNumFormule($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DateCI',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property NumFormule can\'t be set as the property %s is already set. Only one property must be set among these properties: NumFormule, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set NumFormule value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $numFormule
     * @return \StructType\TypeVBD
     */
    public function setNumFormule($numFormule = null)
    {
        // validation for constraint: string
        if (!is_null($numFormule) && !is_string($numFormule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numFormule, true), gettype($numFormule)), __LINE__);
        }
        // validation for constraint: choice(NumFormule, DateCI)
        if ('' !== ($numFormuleChoiceErrorMessage = self::validateNumFormuleForChoiceConstraintsFromSetNumFormule($numFormule))) {
            throw new \InvalidArgumentException($numFormuleChoiceErrorMessage, __LINE__);
        }
        if (is_null($numFormule) || (is_array($numFormule) && empty($numFormule))) {
            unset($this->NumFormule);
        } else {
            $this->NumFormule = $numFormule;
        }
        return $this;
    }
    /**
     * Get DateCI value
     * @return string|null
     */
    public function getDateCI()
    {
        return isset($this->DateCI) ? $this->DateCI : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDateCI method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDateCI method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDateCIForChoiceConstraintsFromSetDateCI($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'NumFormule',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DateCI can\'t be set as the property %s is already set. Only one property must be set among these properties: DateCI, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DateCI value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $dateCI
     * @return \StructType\TypeVBD
     */
    public function setDateCI($dateCI = null)
    {
        // validation for constraint: string
        if (!is_null($dateCI) && !is_string($dateCI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateCI, true), gettype($dateCI)), __LINE__);
        }
        // validation for constraint: choice(NumFormule, DateCI)
        if ('' !== ($dateCIChoiceErrorMessage = self::validateDateCIForChoiceConstraintsFromSetDateCI($dateCI))) {
            throw new \InvalidArgumentException($dateCIChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateCI) && mb_strlen($dateCI) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateCI)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateCI) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateCI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateCI, true)), __LINE__);
        }
        if (is_null($dateCI) || (is_array($dateCI) && empty($dateCI))) {
            unset($this->DateCI);
        } else {
            $this->DateCI = $dateCI;
        }
        return $this;
    }
    /**
     * Get Couleur value
     * @return string|null
     */
    public function getCouleur()
    {
        return $this->Couleur;
    }
    /**
     * Set Couleur value
     * @param string $couleur
     * @return \StructType\TypeVBD
     */
    public function setCouleur($couleur = null)
    {
        // validation for constraint: string
        if (!is_null($couleur) && !is_string($couleur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couleur, true), gettype($couleur)), __LINE__);
        }
        $this->Couleur = $couleur;
        return $this;
    }
}
