<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vehicule StructType
 * @subpackage Structs
 */
class Vehicule extends AbstractStructBase
{
    /**
     * The Immatriculation
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 6
     * - minOccurs: 1
     * - pattern: ([A-Z]{1,2}(-|\s)?\d{2,3}(-|\s)?[A-Z]{1,2})|(\d{1,4}\s?[A-Z]{2,3}\s?(2[AB]|\d{1,3}))
     * @var string
     */
    public $Immatriculation;
    /**
     * The CIPresent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CIPresent;
    /**
     * The Genre
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Genre;
    /**
     * The TypeVehicule
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeVehicule;
    /**
     * The CO2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CO2;
    /**
     * The Puissance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Puissance;
    /**
     * The PTAC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PTAC;
    /**
     * The Energie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Energie;
    /**
     * The Collection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Collection;
    /**
     * The Departement
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: 0[1-9]|[1-8]\d|2[AB]|9[0-7]|97[0-7]
     * @var string
     */
    public $Departement;
    /**
     * The PremiereImmat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PremiereImmat;
    /**
     * The VIN
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * - pattern: [0-9A-Z]*
     * @var string
     */
    public $VIN;
    /**
     * The ExonerationPickUp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExonerationPickUp
     */
    public $ExonerationPickUp;
    /**
     * The NumFormule
     * Meta information extracted from the WSDL
     * - choice: NumFormule | DateCI | NumFormule | DateCI | NumFormule | DateCI | NumFormule | DateCI | NumFormule | DateCI | NumFormule | DateCI | NumFormule | DateCI | NumFormule | DateCI | NumFormule | DateCI
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumFormule;
    /**
     * The DateCI
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: NumFormule | DateCI | NumFormule | DateCI | NumFormule | DateCI | NumFormule | DateCI | NumFormule | DateCI | NumFormule | DateCI | NumFormule | DateCI | NumFormule | DateCI | NumFormule | DateCI
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateCI;
    /**
     * The ExoPickUp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ExoPickUp;
    /**
     * The Marque
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Marque;
    /**
     * The DenominationCommerciale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DenominationCommerciale;
    /**
     * The TypeVariantVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeVariantVersion;
    /**
     * The DateMEC
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateMEC;
    /**
     * The DateAchat
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateAchat;
    /**
     * The Couleur
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Couleur;
    /**
     * The Nuance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Nuance;
    /**
     * The ModifTechnique
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ModifTechnique
     */
    public $ModifTechnique;
    /**
     * The RemiseJustifPropriete
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $RemiseJustifPropriete;
    /**
     * The RemiseDocPreuve
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $RemiseDocPreuve;
    /**
     * The TypeAchat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeAchat;
    /**
     * The Poids
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 5
     * @var int
     */
    public $Poids;
    /**
     * The PrixVente
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 11
     * @var float
     */
    public $PrixVente;
    /**
     * The ModifGenre
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ModifGenre;
    /**
     * The Hybride50km
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Hybride50km;
    /**
     * The DateCession
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateCession;
    /**
     * Constructor method for Vehicule
     * @uses Vehicule::setImmatriculation()
     * @uses Vehicule::setCIPresent()
     * @uses Vehicule::setGenre()
     * @uses Vehicule::setTypeVehicule()
     * @uses Vehicule::setCO2()
     * @uses Vehicule::setPuissance()
     * @uses Vehicule::setPTAC()
     * @uses Vehicule::setEnergie()
     * @uses Vehicule::setCollection()
     * @uses Vehicule::setDepartement()
     * @uses Vehicule::setPremiereImmat()
     * @uses Vehicule::setVIN()
     * @uses Vehicule::setExonerationPickUp()
     * @uses Vehicule::setNumFormule()
     * @uses Vehicule::setDateCI()
     * @uses Vehicule::setExoPickUp()
     * @uses Vehicule::setMarque()
     * @uses Vehicule::setDenominationCommerciale()
     * @uses Vehicule::setTypeVariantVersion()
     * @uses Vehicule::setDateMEC()
     * @uses Vehicule::setDateAchat()
     * @uses Vehicule::setCouleur()
     * @uses Vehicule::setNuance()
     * @uses Vehicule::setModifTechnique()
     * @uses Vehicule::setRemiseJustifPropriete()
     * @uses Vehicule::setRemiseDocPreuve()
     * @uses Vehicule::setTypeAchat()
     * @uses Vehicule::setPoids()
     * @uses Vehicule::setPrixVente()
     * @uses Vehicule::setModifGenre()
     * @uses Vehicule::setHybride50km()
     * @uses Vehicule::setDateCession()
     * @param string $immatriculation
     * @param bool $cIPresent
     * @param string $genre
     * @param string $typeVehicule
     * @param int $cO2
     * @param int $puissance
     * @param string $pTAC
     * @param string $energie
     * @param bool $collection
     * @param string $departement
     * @param bool $premiereImmat
     * @param string $vIN
     * @param \StructType\ExonerationPickUp $exonerationPickUp
     * @param string $numFormule
     * @param string $dateCI
     * @param bool $exoPickUp
     * @param string $marque
     * @param string $denominationCommerciale
     * @param string $typeVariantVersion
     * @param string $dateMEC
     * @param string $dateAchat
     * @param int $couleur
     * @param int $nuance
     * @param \StructType\ModifTechnique $modifTechnique
     * @param bool $remiseJustifPropriete
     * @param bool $remiseDocPreuve
     * @param string $typeAchat
     * @param int $poids
     * @param float $prixVente
     * @param bool $modifGenre
     * @param bool $hybride50km
     * @param string $dateCession
     */
    public function __construct($immatriculation = null, $cIPresent = null, $genre = null, $typeVehicule = null, $cO2 = null, $puissance = null, $pTAC = null, $energie = null, $collection = null, $departement = null, $premiereImmat = null, $vIN = null, \StructType\ExonerationPickUp $exonerationPickUp = null, $numFormule = null, $dateCI = null, $exoPickUp = null, $marque = null, $denominationCommerciale = null, $typeVariantVersion = null, $dateMEC = null, $dateAchat = null, $couleur = null, $nuance = null, \StructType\ModifTechnique $modifTechnique = null, $remiseJustifPropriete = null, $remiseDocPreuve = null, $typeAchat = null, $poids = null, $prixVente = null, $modifGenre = null, $hybride50km = null, $dateCession = null)
    {
        $this
            ->setImmatriculation($immatriculation)
            ->setCIPresent($cIPresent)
            ->setGenre($genre)
            ->setTypeVehicule($typeVehicule)
            ->setCO2($cO2)
            ->setPuissance($puissance)
            ->setPTAC($pTAC)
            ->setEnergie($energie)
            ->setCollection($collection)
            ->setDepartement($departement)
            ->setPremiereImmat($premiereImmat)
            ->setVIN($vIN)
            ->setExonerationPickUp($exonerationPickUp)
            ->setNumFormule($numFormule)
            ->setDateCI($dateCI)
            ->setExoPickUp($exoPickUp)
            ->setMarque($marque)
            ->setDenominationCommerciale($denominationCommerciale)
            ->setTypeVariantVersion($typeVariantVersion)
            ->setDateMEC($dateMEC)
            ->setDateAchat($dateAchat)
            ->setCouleur($couleur)
            ->setNuance($nuance)
            ->setModifTechnique($modifTechnique)
            ->setRemiseJustifPropriete($remiseJustifPropriete)
            ->setRemiseDocPreuve($remiseDocPreuve)
            ->setTypeAchat($typeAchat)
            ->setPoids($poids)
            ->setPrixVente($prixVente)
            ->setModifGenre($modifGenre)
            ->setHybride50km($hybride50km)
            ->setDateCession($dateCession);
    }
    /**
     * Get Immatriculation value
     * @return string
     */
    public function getImmatriculation()
    {
        return $this->Immatriculation;
    }
    /**
     * Set Immatriculation value
     * @param string $immatriculation
     * @return \StructType\Vehicule
     */
    public function setImmatriculation($immatriculation = null)
    {
        // validation for constraint: string
        if (!is_null($immatriculation) && !is_string($immatriculation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($immatriculation, true), gettype($immatriculation)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($immatriculation) && mb_strlen($immatriculation) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($immatriculation)), __LINE__);
        }
        // validation for constraint: minLength(6)
        if (!is_null($immatriculation) && mb_strlen($immatriculation) < 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 6', mb_strlen($immatriculation)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{1,2}(-|\s)?\d{2,3}(-|\s)?[A-Z]{1,2})|(\d{1,4}\s?[A-Z]{2,3}\s?(2[AB]|\d{1,3})))
        if (!is_null($immatriculation) && !preg_match('/([A-Z]{1,2}(-|\\s)?\\d{2,3}(-|\\s)?[A-Z]{1,2})|(\\d{1,4}\\s?[A-Z]{2,3}\\s?(2[AB]|\\d{1,3}))/', $immatriculation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{1,2}(-|\s)?\d{2,3}(-|\s)?[A-Z]{1,2})|(\d{1,4}\s?[A-Z]{2,3}\s?(2[AB]|\d{1,3}))', var_export($immatriculation, true)), __LINE__);
        }
        $this->Immatriculation = $immatriculation;
        return $this;
    }
    /**
     * Get CIPresent value
     * @return bool
     */
    public function getCIPresent()
    {
        return $this->CIPresent;
    }
    /**
     * Set CIPresent value
     * @param bool $cIPresent
     * @return \StructType\Vehicule
     */
    public function setCIPresent($cIPresent = null)
    {
        // validation for constraint: boolean
        if (!is_null($cIPresent) && !is_bool($cIPresent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cIPresent, true), gettype($cIPresent)), __LINE__);
        }
        $this->CIPresent = $cIPresent;
        return $this;
    }
    /**
     * Get Genre value
     * @return string
     */
    public function getGenre()
    {
        return $this->Genre;
    }
    /**
     * Set Genre value
     * @param string $genre
     * @return \StructType\Vehicule
     */
    public function setGenre($genre = null)
    {
        // validation for constraint: string
        if (!is_null($genre) && !is_string($genre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($genre, true), gettype($genre)), __LINE__);
        }
        $this->Genre = $genre;
        return $this;
    }
    /**
     * Get TypeVehicule value
     * @return string
     */
    public function getTypeVehicule()
    {
        return $this->TypeVehicule;
    }
    /**
     * Set TypeVehicule value
     * @uses \EnumType\TypeECGVehicule::valueIsValid()
     * @uses \EnumType\TypeECGVehicule::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeVehicule
     * @return \StructType\Vehicule
     */
    public function setTypeVehicule($typeVehicule = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeECGVehicule::valueIsValid($typeVehicule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeECGVehicule', is_array($typeVehicule) ? implode(', ', $typeVehicule) : var_export($typeVehicule, true), implode(', ', \EnumType\TypeECGVehicule::getValidValues())), __LINE__);
        }
        $this->TypeVehicule = $typeVehicule;
        return $this;
    }
    /**
     * Get CO2 value
     * @return int
     */
    public function getCO2()
    {
        return $this->CO2;
    }
    /**
     * Set CO2 value
     * @param int $cO2
     * @return \StructType\Vehicule
     */
    public function setCO2($cO2 = null)
    {
        // validation for constraint: int
        if (!is_null($cO2) && !(is_int($cO2) || ctype_digit($cO2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cO2, true), gettype($cO2)), __LINE__);
        }
        $this->CO2 = $cO2;
        return $this;
    }
    /**
     * Get Puissance value
     * @return int
     */
    public function getPuissance()
    {
        return $this->Puissance;
    }
    /**
     * Set Puissance value
     * @param int $puissance
     * @return \StructType\Vehicule
     */
    public function setPuissance($puissance = null)
    {
        // validation for constraint: int
        if (!is_null($puissance) && !(is_int($puissance) || ctype_digit($puissance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($puissance, true), gettype($puissance)), __LINE__);
        }
        $this->Puissance = $puissance;
        return $this;
    }
    /**
     * Get PTAC value
     * @return string
     */
    public function getPTAC()
    {
        return $this->PTAC;
    }
    /**
     * Set PTAC value
     * @uses \EnumType\TypeECGPTAC::valueIsValid()
     * @uses \EnumType\TypeECGPTAC::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pTAC
     * @return \StructType\Vehicule
     */
    public function setPTAC($pTAC = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeECGPTAC::valueIsValid($pTAC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeECGPTAC', is_array($pTAC) ? implode(', ', $pTAC) : var_export($pTAC, true), implode(', ', \EnumType\TypeECGPTAC::getValidValues())), __LINE__);
        }
        $this->PTAC = $pTAC;
        return $this;
    }
    /**
     * Get Energie value
     * @return string
     */
    public function getEnergie()
    {
        return $this->Energie;
    }
    /**
     * Set Energie value
     * @uses \EnumType\TypeECGEnergie::valueIsValid()
     * @uses \EnumType\TypeECGEnergie::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $energie
     * @return \StructType\Vehicule
     */
    public function setEnergie($energie = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeECGEnergie::valueIsValid($energie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeECGEnergie', is_array($energie) ? implode(', ', $energie) : var_export($energie, true), implode(', ', \EnumType\TypeECGEnergie::getValidValues())), __LINE__);
        }
        $this->Energie = $energie;
        return $this;
    }
    /**
     * Get Collection value
     * @return bool
     */
    public function getCollection()
    {
        return $this->Collection;
    }
    /**
     * Set Collection value
     * @param bool $collection
     * @return \StructType\Vehicule
     */
    public function setCollection($collection = null)
    {
        // validation for constraint: boolean
        if (!is_null($collection) && !is_bool($collection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($collection, true), gettype($collection)), __LINE__);
        }
        $this->Collection = $collection;
        return $this;
    }
    /**
     * Get Departement value
     * @return string
     */
    public function getDepartement()
    {
        return $this->Departement;
    }
    /**
     * Set Departement value
     * @param string $departement
     * @return \StructType\Vehicule
     */
    public function setDepartement($departement = null)
    {
        // validation for constraint: string
        if (!is_null($departement) && !is_string($departement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departement, true), gettype($departement)), __LINE__);
        }
        // validation for constraint: pattern(0[1-9]|[1-8]\d|2[AB]|9[0-7]|97[0-7])
        if (!is_null($departement) && !preg_match('/0[1-9]|[1-8]\\d|2[AB]|9[0-7]|97[0-7]/', $departement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression 0[1-9]|[1-8]\d|2[AB]|9[0-7]|97[0-7]', var_export($departement, true)), __LINE__);
        }
        $this->Departement = $departement;
        return $this;
    }
    /**
     * Get PremiereImmat value
     * @return bool
     */
    public function getPremiereImmat()
    {
        return $this->PremiereImmat;
    }
    /**
     * Set PremiereImmat value
     * @param bool $premiereImmat
     * @return \StructType\Vehicule
     */
    public function setPremiereImmat($premiereImmat = null)
    {
        // validation for constraint: boolean
        if (!is_null($premiereImmat) && !is_bool($premiereImmat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($premiereImmat, true), gettype($premiereImmat)), __LINE__);
        }
        $this->PremiereImmat = $premiereImmat;
        return $this;
    }
    /**
     * Get VIN value
     * @return string|null
     */
    public function getVIN()
    {
        return $this->VIN;
    }
    /**
     * Set VIN value
     * @param string $vIN
     * @return \StructType\Vehicule
     */
    public function setVIN($vIN = null)
    {
        // validation for constraint: string
        if (!is_null($vIN) && !is_string($vIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vIN, true), gettype($vIN)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($vIN) && mb_strlen($vIN) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($vIN)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($vIN) && mb_strlen($vIN) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($vIN)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]*)
        if (!is_null($vIN) && !preg_match('/[0-9A-Z]*/', $vIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]*', var_export($vIN, true)), __LINE__);
        }
        $this->VIN = $vIN;
        return $this;
    }
    /**
     * Get ExonerationPickUp value
     * @return \StructType\ExonerationPickUp|null
     */
    public function getExonerationPickUp()
    {
        return $this->ExonerationPickUp;
    }
    /**
     * Set ExonerationPickUp value
     * @param \StructType\ExonerationPickUp $exonerationPickUp
     * @return \StructType\Vehicule
     */
    public function setExonerationPickUp(\StructType\ExonerationPickUp $exonerationPickUp = null)
    {
        $this->ExonerationPickUp = $exonerationPickUp;
        return $this;
    }
    /**
     * Get NumFormule value
     * @return string|null
     */
    public function getNumFormule()
    {
        return isset($this->NumFormule) ? $this->NumFormule : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNumFormule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNumFormule method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNumFormuleForChoiceConstraintsFromSetNumFormule($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DateCI',
            'DateCI',
            'DateCI',
            'DateCI',
            'DateCI',
            'DateCI',
            'DateCI',
            'DateCI',
            'DateCI',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property NumFormule can\'t be set as the property %s is already set. Only one property must be set among these properties: NumFormule, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set NumFormule value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $numFormule
     * @return \StructType\Vehicule
     */
    public function setNumFormule($numFormule = null)
    {
        // validation for constraint: string
        if (!is_null($numFormule) && !is_string($numFormule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numFormule, true), gettype($numFormule)), __LINE__);
        }
        // validation for constraint: choice(NumFormule, DateCI, NumFormule, DateCI, NumFormule, DateCI, NumFormule, DateCI, NumFormule, DateCI, NumFormule, DateCI, NumFormule, DateCI, NumFormule, DateCI, NumFormule, DateCI)
        if ('' !== ($numFormuleChoiceErrorMessage = self::validateNumFormuleForChoiceConstraintsFromSetNumFormule($numFormule))) {
            throw new \InvalidArgumentException($numFormuleChoiceErrorMessage, __LINE__);
        }
        if (is_null($numFormule) || (is_array($numFormule) && empty($numFormule))) {
            unset($this->NumFormule);
        } else {
            $this->NumFormule = $numFormule;
        }
        return $this;
    }
    /**
     * Get DateCI value
     * @return string|null
     */
    public function getDateCI()
    {
        return isset($this->DateCI) ? $this->DateCI : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDateCI method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDateCI method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDateCIForChoiceConstraintsFromSetDateCI($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'NumFormule',
            'NumFormule',
            'NumFormule',
            'NumFormule',
            'NumFormule',
            'NumFormule',
            'NumFormule',
            'NumFormule',
            'NumFormule',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DateCI can\'t be set as the property %s is already set. Only one property must be set among these properties: DateCI, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DateCI value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $dateCI
     * @return \StructType\Vehicule
     */
    public function setDateCI($dateCI = null)
    {
        // validation for constraint: string
        if (!is_null($dateCI) && !is_string($dateCI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateCI, true), gettype($dateCI)), __LINE__);
        }
        // validation for constraint: choice(NumFormule, DateCI, NumFormule, DateCI, NumFormule, DateCI, NumFormule, DateCI, NumFormule, DateCI, NumFormule, DateCI, NumFormule, DateCI, NumFormule, DateCI, NumFormule, DateCI)
        if ('' !== ($dateCIChoiceErrorMessage = self::validateDateCIForChoiceConstraintsFromSetDateCI($dateCI))) {
            throw new \InvalidArgumentException($dateCIChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateCI) && mb_strlen($dateCI) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateCI)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateCI) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateCI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateCI, true)), __LINE__);
        }
        if (is_null($dateCI) || (is_array($dateCI) && empty($dateCI))) {
            unset($this->DateCI);
        } else {
            $this->DateCI = $dateCI;
        }
        return $this;
    }
    /**
     * Get ExoPickUp value
     * @return bool|null
     */
    public function getExoPickUp()
    {
        return $this->ExoPickUp;
    }
    /**
     * Set ExoPickUp value
     * @param bool $exoPickUp
     * @return \StructType\Vehicule
     */
    public function setExoPickUp($exoPickUp = null)
    {
        // validation for constraint: boolean
        if (!is_null($exoPickUp) && !is_bool($exoPickUp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exoPickUp, true), gettype($exoPickUp)), __LINE__);
        }
        $this->ExoPickUp = $exoPickUp;
        return $this;
    }
    /**
     * Get Marque value
     * @return string|null
     */
    public function getMarque()
    {
        return $this->Marque;
    }
    /**
     * Set Marque value
     * @param string $marque
     * @return \StructType\Vehicule
     */
    public function setMarque($marque = null)
    {
        // validation for constraint: string
        if (!is_null($marque) && !is_string($marque)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marque, true), gettype($marque)), __LINE__);
        }
        $this->Marque = $marque;
        return $this;
    }
    /**
     * Get DenominationCommerciale value
     * @return string|null
     */
    public function getDenominationCommerciale()
    {
        return $this->DenominationCommerciale;
    }
    /**
     * Set DenominationCommerciale value
     * @param string $denominationCommerciale
     * @return \StructType\Vehicule
     */
    public function setDenominationCommerciale($denominationCommerciale = null)
    {
        // validation for constraint: string
        if (!is_null($denominationCommerciale) && !is_string($denominationCommerciale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($denominationCommerciale, true), gettype($denominationCommerciale)), __LINE__);
        }
        $this->DenominationCommerciale = $denominationCommerciale;
        return $this;
    }
    /**
     * Get TypeVariantVersion value
     * @return string|null
     */
    public function getTypeVariantVersion()
    {
        return $this->TypeVariantVersion;
    }
    /**
     * Set TypeVariantVersion value
     * @param string $typeVariantVersion
     * @return \StructType\Vehicule
     */
    public function setTypeVariantVersion($typeVariantVersion = null)
    {
        // validation for constraint: string
        if (!is_null($typeVariantVersion) && !is_string($typeVariantVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeVariantVersion, true), gettype($typeVariantVersion)), __LINE__);
        }
        $this->TypeVariantVersion = $typeVariantVersion;
        return $this;
    }
    /**
     * Get DateMEC value
     * @return string|null
     */
    public function getDateMEC()
    {
        return $this->DateMEC;
    }
    /**
     * Set DateMEC value
     * @param string $dateMEC
     * @return \StructType\Vehicule
     */
    public function setDateMEC($dateMEC = null)
    {
        // validation for constraint: string
        if (!is_null($dateMEC) && !is_string($dateMEC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateMEC, true), gettype($dateMEC)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateMEC) && mb_strlen($dateMEC) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateMEC)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateMEC) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateMEC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateMEC, true)), __LINE__);
        }
        $this->DateMEC = $dateMEC;
        return $this;
    }
    /**
     * Get DateAchat value
     * @return string|null
     */
    public function getDateAchat()
    {
        return $this->DateAchat;
    }
    /**
     * Set DateAchat value
     * @param string $dateAchat
     * @return \StructType\Vehicule
     */
    public function setDateAchat($dateAchat = null)
    {
        // validation for constraint: string
        if (!is_null($dateAchat) && !is_string($dateAchat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateAchat, true), gettype($dateAchat)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateAchat) && mb_strlen($dateAchat) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateAchat)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateAchat) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateAchat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateAchat, true)), __LINE__);
        }
        $this->DateAchat = $dateAchat;
        return $this;
    }
    /**
     * Get Couleur value
     * @return int|null
     */
    public function getCouleur()
    {
        return $this->Couleur;
    }
    /**
     * Set Couleur value
     * @param int $couleur
     * @return \StructType\Vehicule
     */
    public function setCouleur($couleur = null)
    {
        // validation for constraint: int
        if (!is_null($couleur) && !(is_int($couleur) || ctype_digit($couleur))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($couleur, true), gettype($couleur)), __LINE__);
        }
        $this->Couleur = $couleur;
        return $this;
    }
    /**
     * Get Nuance value
     * @return int|null
     */
    public function getNuance()
    {
        return $this->Nuance;
    }
    /**
     * Set Nuance value
     * @param int $nuance
     * @return \StructType\Vehicule
     */
    public function setNuance($nuance = null)
    {
        // validation for constraint: int
        if (!is_null($nuance) && !(is_int($nuance) || ctype_digit($nuance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nuance, true), gettype($nuance)), __LINE__);
        }
        $this->Nuance = $nuance;
        return $this;
    }
    /**
     * Get ModifTechnique value
     * @return \StructType\ModifTechnique|null
     */
    public function getModifTechnique()
    {
        return $this->ModifTechnique;
    }
    /**
     * Set ModifTechnique value
     * @param \StructType\ModifTechnique $modifTechnique
     * @return \StructType\Vehicule
     */
    public function setModifTechnique(\StructType\ModifTechnique $modifTechnique = null)
    {
        $this->ModifTechnique = $modifTechnique;
        return $this;
    }
    /**
     * Get RemiseJustifPropriete value
     * @return bool|null
     */
    public function getRemiseJustifPropriete()
    {
        return $this->RemiseJustifPropriete;
    }
    /**
     * Set RemiseJustifPropriete value
     * @param bool $remiseJustifPropriete
     * @return \StructType\Vehicule
     */
    public function setRemiseJustifPropriete($remiseJustifPropriete = null)
    {
        // validation for constraint: boolean
        if (!is_null($remiseJustifPropriete) && !is_bool($remiseJustifPropriete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($remiseJustifPropriete, true), gettype($remiseJustifPropriete)), __LINE__);
        }
        $this->RemiseJustifPropriete = $remiseJustifPropriete;
        return $this;
    }
    /**
     * Get RemiseDocPreuve value
     * @return bool|null
     */
    public function getRemiseDocPreuve()
    {
        return $this->RemiseDocPreuve;
    }
    /**
     * Set RemiseDocPreuve value
     * @param bool $remiseDocPreuve
     * @return \StructType\Vehicule
     */
    public function setRemiseDocPreuve($remiseDocPreuve = null)
    {
        // validation for constraint: boolean
        if (!is_null($remiseDocPreuve) && !is_bool($remiseDocPreuve)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($remiseDocPreuve, true), gettype($remiseDocPreuve)), __LINE__);
        }
        $this->RemiseDocPreuve = $remiseDocPreuve;
        return $this;
    }
    /**
     * Get TypeAchat value
     * @return string|null
     */
    public function getTypeAchat()
    {
        return $this->TypeAchat;
    }
    /**
     * Set TypeAchat value
     * @uses \EnumType\TypeECGAchat::valueIsValid()
     * @uses \EnumType\TypeECGAchat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeAchat
     * @return \StructType\Vehicule
     */
    public function setTypeAchat($typeAchat = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeECGAchat::valueIsValid($typeAchat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeECGAchat', is_array($typeAchat) ? implode(', ', $typeAchat) : var_export($typeAchat, true), implode(', ', \EnumType\TypeECGAchat::getValidValues())), __LINE__);
        }
        $this->TypeAchat = $typeAchat;
        return $this;
    }
    /**
     * Get Poids value
     * @return int|null
     */
    public function getPoids()
    {
        return $this->Poids;
    }
    /**
     * Set Poids value
     * @param int $poids
     * @return \StructType\Vehicule
     */
    public function setPoids($poids = null)
    {
        // validation for constraint: int
        if (!is_null($poids) && !(is_int($poids) || ctype_digit($poids))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($poids, true), gettype($poids)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($poids) && mb_strlen(preg_replace('/(\D)/', '', $poids)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($poids, true), mb_strlen(preg_replace('/(\D)/', '', $poids))), __LINE__);
        }
        $this->Poids = $poids;
        return $this;
    }
    /**
     * Get PrixVente value
     * @return float|null
     */
    public function getPrixVente()
    {
        return $this->PrixVente;
    }
    /**
     * Set PrixVente value
     * @param float $prixVente
     * @return \StructType\Vehicule
     */
    public function setPrixVente($prixVente = null)
    {
        // validation for constraint: float
        if (!is_null($prixVente) && !(is_float($prixVente) || is_numeric($prixVente))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prixVente, true), gettype($prixVente)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($prixVente) && mb_strlen(mb_substr($prixVente, false !== mb_strpos($prixVente, '.') ? mb_strpos($prixVente, '.') + 1 : mb_strlen($prixVente))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($prixVente, true), mb_strlen(mb_substr($prixVente, mb_strpos($prixVente, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(11)
        if (!is_null($prixVente) && mb_strlen(preg_replace('/(\D)/', '', $prixVente)) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 11 digits, "%d" given', var_export($prixVente, true), mb_strlen(preg_replace('/(\D)/', '', $prixVente))), __LINE__);
        }
        $this->PrixVente = $prixVente;
        return $this;
    }
    /**
     * Get ModifGenre value
     * @return bool|null
     */
    public function getModifGenre()
    {
        return $this->ModifGenre;
    }
    /**
     * Set ModifGenre value
     * @param bool $modifGenre
     * @return \StructType\Vehicule
     */
    public function setModifGenre($modifGenre = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifGenre) && !is_bool($modifGenre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modifGenre, true), gettype($modifGenre)), __LINE__);
        }
        $this->ModifGenre = $modifGenre;
        return $this;
    }
    /**
     * Get Hybride50km value
     * @return bool|null
     */
    public function getHybride50km()
    {
        return $this->Hybride50km;
    }
    /**
     * Set Hybride50km value
     * @param bool $hybride50km
     * @return \StructType\Vehicule
     */
    public function setHybride50km($hybride50km = null)
    {
        // validation for constraint: boolean
        if (!is_null($hybride50km) && !is_bool($hybride50km)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hybride50km, true), gettype($hybride50km)), __LINE__);
        }
        $this->Hybride50km = $hybride50km;
        return $this;
    }
    /**
     * Get DateCession value
     * @return string|null
     */
    public function getDateCession()
    {
        return $this->DateCession;
    }
    /**
     * Set DateCession value
     * @param string $dateCession
     * @return \StructType\Vehicule
     */
    public function setDateCession($dateCession = null)
    {
        // validation for constraint: string
        if (!is_null($dateCession) && !is_string($dateCession)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateCession, true), gettype($dateCession)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateCession) && mb_strlen($dateCession) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateCession)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateCession) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateCession)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateCession, true)), __LINE__);
        }
        $this->DateCession = $dateCession;
        return $this;
    }
}
