<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LireArchive_Req StructType
 * @subpackage Structs
 */
class LireArchive_Req extends AbstractStructBase
{
    /**
     * The DossierID
     * Meta information extracted from the WSDL
     * - choice: DossierID
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DossierID;
    /**
     * The Identification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TypeIdentification
     */
    public $Identification;
    /**
     * The Origine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Origine;
    /**
     * Constructor method for LireArchive_Req
     * @uses LireArchive_Req::setDossierID()
     * @uses LireArchive_Req::setIdentification()
     * @uses LireArchive_Req::setOrigine()
     * @param string $dossierID
     * @param \StructType\TypeIdentification $identification
     * @param string $origine
     */
    public function __construct($dossierID = null, \StructType\TypeIdentification $identification = null, $origine = null)
    {
        $this
            ->setDossierID($dossierID)
            ->setIdentification($identification)
            ->setOrigine($origine);
    }
    /**
     * Get DossierID value
     * @return string
     */
    public function getDossierID()
    {
        return isset($this->DossierID) ? $this->DossierID : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDossierID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDossierID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDossierIDForChoiceConstraintsFromSetDossierID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DossierID can\'t be set as the property %s is already set. Only one property must be set among these properties: DossierID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DossierID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $dossierID
     * @return \StructType\LireArchive_Req
     */
    public function setDossierID($dossierID = null)
    {
        // validation for constraint: string
        if (!is_null($dossierID) && !is_string($dossierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dossierID, true), gettype($dossierID)), __LINE__);
        }
        // validation for constraint: choice(DossierID)
        if ('' !== ($dossierIDChoiceErrorMessage = self::validateDossierIDForChoiceConstraintsFromSetDossierID($dossierID))) {
            throw new \InvalidArgumentException($dossierIDChoiceErrorMessage, __LINE__);
        }
        if (is_null($dossierID) || (is_array($dossierID) && empty($dossierID))) {
            unset($this->DossierID);
        } else {
            $this->DossierID = $dossierID;
        }
        return $this;
    }
    /**
     * Get Identification value
     * @return \StructType\TypeIdentification|null
     */
    public function getIdentification()
    {
        return $this->Identification;
    }
    /**
     * Set Identification value
     * @param \StructType\TypeIdentification $identification
     * @return \StructType\LireArchive_Req
     */
    public function setIdentification(\StructType\TypeIdentification $identification = null)
    {
        $this->Identification = $identification;
        return $this;
    }
    /**
     * Get Origine value
     * @return string|null
     */
    public function getOrigine()
    {
        return $this->Origine;
    }
    /**
     * Set Origine value
     * @param string $origine
     * @return \StructType\LireArchive_Req
     */
    public function setOrigine($origine = null)
    {
        // validation for constraint: string
        if (!is_null($origine) && !is_string($origine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origine, true), gettype($origine)), __LINE__);
        }
        $this->Origine = $origine;
        return $this;
    }
}
