<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Lire ServiceType
 * @subpackage Services
 */
class Lire extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LireArchive
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LireArchive_Req $lireArchiveRepMsg
     * @return \StructType\LireArchive_Rep|bool
     */
    public function LireArchive(\StructType\LireArchive_Req $lireArchiveRepMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->LireArchive($lireArchiveRepMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\LireArchive_Rep
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
