<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfoCoC_Rep StructType
 * @subpackage Structs
 */
class InfoCoC_Rep extends AbstractStructBase
{
    /**
     * The F1_MMaxTechAdm
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - choice: F1_MMaxTechAdm | F2_MMaxAdmServ | G_MMaxAvecAttelage | G1_PoidsVide | J1_Genre | J3_Carrosserie | S1_NbPlaceAssise | Erreur | Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - totalDigits: 10
     * @var int
     */
    public $F1_MMaxTechAdm;
    /**
     * The F2_MMaxAdmServ
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - choice: F1_MMaxTechAdm | F2_MMaxAdmServ | G_MMaxAvecAttelage | G1_PoidsVide | J1_Genre | J3_Carrosserie | S1_NbPlaceAssise | Erreur | Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - totalDigits: 10
     * @var int
     */
    public $F2_MMaxAdmServ;
    /**
     * The G_MMaxAvecAttelage
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - choice: F1_MMaxTechAdm | F2_MMaxAdmServ | G_MMaxAvecAttelage | G1_PoidsVide | J1_Genre | J3_Carrosserie | S1_NbPlaceAssise | Erreur | Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - totalDigits: 10
     * @var int
     */
    public $G_MMaxAvecAttelage;
    /**
     * The G1_PoidsVide
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - choice: F1_MMaxTechAdm | F2_MMaxAdmServ | G_MMaxAvecAttelage | G1_PoidsVide | J1_Genre | J3_Carrosserie | S1_NbPlaceAssise | Erreur | Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - totalDigits: 10
     * @var int
     */
    public $G1_PoidsVide;
    /**
     * The J1_Genre
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: F1_MMaxTechAdm | F2_MMaxAdmServ | G_MMaxAvecAttelage | G1_PoidsVide | J1_Genre | J3_Carrosserie | S1_NbPlaceAssise | Erreur | Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $J1_Genre;
    /**
     * The J3_Carrosserie
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: F1_MMaxTechAdm | F2_MMaxAdmServ | G_MMaxAvecAttelage | G1_PoidsVide | J1_Genre | J3_Carrosserie | S1_NbPlaceAssise | Erreur | Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $J3_Carrosserie;
    /**
     * The S1_NbPlaceAssise
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - choice: F1_MMaxTechAdm | F2_MMaxAdmServ | G_MMaxAvecAttelage | G1_PoidsVide | J1_Genre | J3_Carrosserie | S1_NbPlaceAssise | Erreur | Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - totalDigits: 3
     * @var int
     */
    public $S1_NbPlaceAssise;
    /**
     * The Erreur
     * Meta information extracted from the WSDL
     * - choice: F1_MMaxTechAdm | F2_MMaxAdmServ | G_MMaxAvecAttelage | G1_PoidsVide | J1_Genre | J3_Carrosserie | S1_NbPlaceAssise | Erreur | Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Erreur;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - choice: F1_MMaxTechAdm | F2_MMaxAdmServ | G_MMaxAvecAttelage | G1_PoidsVide | J1_Genre | J3_Carrosserie | S1_NbPlaceAssise | Erreur | Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Code;
    /**
     * Constructor method for InfoCoC_Rep
     * @uses InfoCoC_Rep::setF1_MMaxTechAdm()
     * @uses InfoCoC_Rep::setF2_MMaxAdmServ()
     * @uses InfoCoC_Rep::setG_MMaxAvecAttelage()
     * @uses InfoCoC_Rep::setG1_PoidsVide()
     * @uses InfoCoC_Rep::setJ1_Genre()
     * @uses InfoCoC_Rep::setJ3_Carrosserie()
     * @uses InfoCoC_Rep::setS1_NbPlaceAssise()
     * @uses InfoCoC_Rep::setErreur()
     * @uses InfoCoC_Rep::setCode()
     * @param int $f1_MMaxTechAdm
     * @param int $f2_MMaxAdmServ
     * @param int $g_MMaxAvecAttelage
     * @param int $g1_PoidsVide
     * @param string $j1_Genre
     * @param string $j3_Carrosserie
     * @param int $s1_NbPlaceAssise
     * @param string $erreur
     * @param int $code
     */
    public function __construct($f1_MMaxTechAdm = null, $f2_MMaxAdmServ = null, $g_MMaxAvecAttelage = null, $g1_PoidsVide = null, $j1_Genre = null, $j3_Carrosserie = null, $s1_NbPlaceAssise = null, $erreur = null, $code = null)
    {
        $this
            ->setF1_MMaxTechAdm($f1_MMaxTechAdm)
            ->setF2_MMaxAdmServ($f2_MMaxAdmServ)
            ->setG_MMaxAvecAttelage($g_MMaxAvecAttelage)
            ->setG1_PoidsVide($g1_PoidsVide)
            ->setJ1_Genre($j1_Genre)
            ->setJ3_Carrosserie($j3_Carrosserie)
            ->setS1_NbPlaceAssise($s1_NbPlaceAssise)
            ->setErreur($erreur)
            ->setCode($code);
    }
    /**
     * Get F1_MMaxTechAdm value
     * @return int
     */
    public function getF1_MMaxTechAdm()
    {
        return isset($this->F1_MMaxTechAdm) ? $this->F1_MMaxTechAdm : null;
    }
    /**
     * This method is responsible for validating the value passed to the setF1_MMaxTechAdm method
     * This method is willingly generated in order to preserve the one-line inline validation within the setF1_MMaxTechAdm method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateF1_MMaxTechAdmForChoiceConstraintsFromSetF1_MMaxTechAdm($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'F2_MMaxAdmServ',
            'G_MMaxAvecAttelage',
            'G1_PoidsVide',
            'J1_Genre',
            'J3_Carrosserie',
            'S1_NbPlaceAssise',
            'Erreur',
            'Code',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property F1_MMaxTechAdm can\'t be set as the property %s is already set. Only one property must be set among these properties: F1_MMaxTechAdm, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set F1_MMaxTechAdm value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $f1_MMaxTechAdm
     * @return \StructType\InfoCoC_Rep
     */
    public function setF1_MMaxTechAdm($f1_MMaxTechAdm = null)
    {
        // validation for constraint: int
        if (!is_null($f1_MMaxTechAdm) && !(is_int($f1_MMaxTechAdm) || ctype_digit($f1_MMaxTechAdm))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($f1_MMaxTechAdm, true), gettype($f1_MMaxTechAdm)), __LINE__);
        }
        // validation for constraint: choice(F1_MMaxTechAdm, F2_MMaxAdmServ, G_MMaxAvecAttelage, G1_PoidsVide, J1_Genre, J3_Carrosserie, S1_NbPlaceAssise, Erreur, Code)
        if ('' !== ($f1_MMaxTechAdmChoiceErrorMessage = self::validateF1_MMaxTechAdmForChoiceConstraintsFromSetF1_MMaxTechAdm($f1_MMaxTechAdm))) {
            throw new \InvalidArgumentException($f1_MMaxTechAdmChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: totalDigits(10)
        if (!is_null($f1_MMaxTechAdm) && mb_strlen(preg_replace('/(\D)/', '', $f1_MMaxTechAdm)) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 10 digits, "%d" given', var_export($f1_MMaxTechAdm, true), mb_strlen(preg_replace('/(\D)/', '', $f1_MMaxTechAdm))), __LINE__);
        }
        if (is_null($f1_MMaxTechAdm) || (is_array($f1_MMaxTechAdm) && empty($f1_MMaxTechAdm))) {
            unset($this->F1_MMaxTechAdm);
        } else {
            $this->F1_MMaxTechAdm = $f1_MMaxTechAdm;
        }
        return $this;
    }
    /**
     * Get F2_MMaxAdmServ value
     * @return int
     */
    public function getF2_MMaxAdmServ()
    {
        return isset($this->F2_MMaxAdmServ) ? $this->F2_MMaxAdmServ : null;
    }
    /**
     * This method is responsible for validating the value passed to the setF2_MMaxAdmServ method
     * This method is willingly generated in order to preserve the one-line inline validation within the setF2_MMaxAdmServ method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateF2_MMaxAdmServForChoiceConstraintsFromSetF2_MMaxAdmServ($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'F1_MMaxTechAdm',
            'G_MMaxAvecAttelage',
            'G1_PoidsVide',
            'J1_Genre',
            'J3_Carrosserie',
            'S1_NbPlaceAssise',
            'Erreur',
            'Code',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property F2_MMaxAdmServ can\'t be set as the property %s is already set. Only one property must be set among these properties: F2_MMaxAdmServ, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set F2_MMaxAdmServ value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $f2_MMaxAdmServ
     * @return \StructType\InfoCoC_Rep
     */
    public function setF2_MMaxAdmServ($f2_MMaxAdmServ = null)
    {
        // validation for constraint: int
        if (!is_null($f2_MMaxAdmServ) && !(is_int($f2_MMaxAdmServ) || ctype_digit($f2_MMaxAdmServ))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($f2_MMaxAdmServ, true), gettype($f2_MMaxAdmServ)), __LINE__);
        }
        // validation for constraint: choice(F1_MMaxTechAdm, F2_MMaxAdmServ, G_MMaxAvecAttelage, G1_PoidsVide, J1_Genre, J3_Carrosserie, S1_NbPlaceAssise, Erreur, Code)
        if ('' !== ($f2_MMaxAdmServChoiceErrorMessage = self::validateF2_MMaxAdmServForChoiceConstraintsFromSetF2_MMaxAdmServ($f2_MMaxAdmServ))) {
            throw new \InvalidArgumentException($f2_MMaxAdmServChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: totalDigits(10)
        if (!is_null($f2_MMaxAdmServ) && mb_strlen(preg_replace('/(\D)/', '', $f2_MMaxAdmServ)) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 10 digits, "%d" given', var_export($f2_MMaxAdmServ, true), mb_strlen(preg_replace('/(\D)/', '', $f2_MMaxAdmServ))), __LINE__);
        }
        if (is_null($f2_MMaxAdmServ) || (is_array($f2_MMaxAdmServ) && empty($f2_MMaxAdmServ))) {
            unset($this->F2_MMaxAdmServ);
        } else {
            $this->F2_MMaxAdmServ = $f2_MMaxAdmServ;
        }
        return $this;
    }
    /**
     * Get G_MMaxAvecAttelage value
     * @return int
     */
    public function getG_MMaxAvecAttelage()
    {
        return isset($this->G_MMaxAvecAttelage) ? $this->G_MMaxAvecAttelage : null;
    }
    /**
     * This method is responsible for validating the value passed to the setG_MMaxAvecAttelage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setG_MMaxAvecAttelage method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateG_MMaxAvecAttelageForChoiceConstraintsFromSetG_MMaxAvecAttelage($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'F1_MMaxTechAdm',
            'F2_MMaxAdmServ',
            'G1_PoidsVide',
            'J1_Genre',
            'J3_Carrosserie',
            'S1_NbPlaceAssise',
            'Erreur',
            'Code',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property G_MMaxAvecAttelage can\'t be set as the property %s is already set. Only one property must be set among these properties: G_MMaxAvecAttelage, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set G_MMaxAvecAttelage value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $g_MMaxAvecAttelage
     * @return \StructType\InfoCoC_Rep
     */
    public function setG_MMaxAvecAttelage($g_MMaxAvecAttelage = null)
    {
        // validation for constraint: int
        if (!is_null($g_MMaxAvecAttelage) && !(is_int($g_MMaxAvecAttelage) || ctype_digit($g_MMaxAvecAttelage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($g_MMaxAvecAttelage, true), gettype($g_MMaxAvecAttelage)), __LINE__);
        }
        // validation for constraint: choice(F1_MMaxTechAdm, F2_MMaxAdmServ, G_MMaxAvecAttelage, G1_PoidsVide, J1_Genre, J3_Carrosserie, S1_NbPlaceAssise, Erreur, Code)
        if ('' !== ($g_MMaxAvecAttelageChoiceErrorMessage = self::validateG_MMaxAvecAttelageForChoiceConstraintsFromSetG_MMaxAvecAttelage($g_MMaxAvecAttelage))) {
            throw new \InvalidArgumentException($g_MMaxAvecAttelageChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: totalDigits(10)
        if (!is_null($g_MMaxAvecAttelage) && mb_strlen(preg_replace('/(\D)/', '', $g_MMaxAvecAttelage)) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 10 digits, "%d" given', var_export($g_MMaxAvecAttelage, true), mb_strlen(preg_replace('/(\D)/', '', $g_MMaxAvecAttelage))), __LINE__);
        }
        if (is_null($g_MMaxAvecAttelage) || (is_array($g_MMaxAvecAttelage) && empty($g_MMaxAvecAttelage))) {
            unset($this->G_MMaxAvecAttelage);
        } else {
            $this->G_MMaxAvecAttelage = $g_MMaxAvecAttelage;
        }
        return $this;
    }
    /**
     * Get G1_PoidsVide value
     * @return int
     */
    public function getG1_PoidsVide()
    {
        return isset($this->G1_PoidsVide) ? $this->G1_PoidsVide : null;
    }
    /**
     * This method is responsible for validating the value passed to the setG1_PoidsVide method
     * This method is willingly generated in order to preserve the one-line inline validation within the setG1_PoidsVide method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateG1_PoidsVideForChoiceConstraintsFromSetG1_PoidsVide($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'F1_MMaxTechAdm',
            'F2_MMaxAdmServ',
            'G_MMaxAvecAttelage',
            'J1_Genre',
            'J3_Carrosserie',
            'S1_NbPlaceAssise',
            'Erreur',
            'Code',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property G1_PoidsVide can\'t be set as the property %s is already set. Only one property must be set among these properties: G1_PoidsVide, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set G1_PoidsVide value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $g1_PoidsVide
     * @return \StructType\InfoCoC_Rep
     */
    public function setG1_PoidsVide($g1_PoidsVide = null)
    {
        // validation for constraint: int
        if (!is_null($g1_PoidsVide) && !(is_int($g1_PoidsVide) || ctype_digit($g1_PoidsVide))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($g1_PoidsVide, true), gettype($g1_PoidsVide)), __LINE__);
        }
        // validation for constraint: choice(F1_MMaxTechAdm, F2_MMaxAdmServ, G_MMaxAvecAttelage, G1_PoidsVide, J1_Genre, J3_Carrosserie, S1_NbPlaceAssise, Erreur, Code)
        if ('' !== ($g1_PoidsVideChoiceErrorMessage = self::validateG1_PoidsVideForChoiceConstraintsFromSetG1_PoidsVide($g1_PoidsVide))) {
            throw new \InvalidArgumentException($g1_PoidsVideChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: totalDigits(10)
        if (!is_null($g1_PoidsVide) && mb_strlen(preg_replace('/(\D)/', '', $g1_PoidsVide)) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 10 digits, "%d" given', var_export($g1_PoidsVide, true), mb_strlen(preg_replace('/(\D)/', '', $g1_PoidsVide))), __LINE__);
        }
        if (is_null($g1_PoidsVide) || (is_array($g1_PoidsVide) && empty($g1_PoidsVide))) {
            unset($this->G1_PoidsVide);
        } else {
            $this->G1_PoidsVide = $g1_PoidsVide;
        }
        return $this;
    }
    /**
     * Get J1_Genre value
     * @return string
     */
    public function getJ1_Genre()
    {
        return isset($this->J1_Genre) ? $this->J1_Genre : null;
    }
    /**
     * This method is responsible for validating the value passed to the setJ1_Genre method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJ1_Genre method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateJ1_GenreForChoiceConstraintsFromSetJ1_Genre($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'F1_MMaxTechAdm',
            'F2_MMaxAdmServ',
            'G_MMaxAvecAttelage',
            'G1_PoidsVide',
            'J3_Carrosserie',
            'S1_NbPlaceAssise',
            'Erreur',
            'Code',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property J1_Genre can\'t be set as the property %s is already set. Only one property must be set among these properties: J1_Genre, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set J1_Genre value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $j1_Genre
     * @return \StructType\InfoCoC_Rep
     */
    public function setJ1_Genre($j1_Genre = null)
    {
        // validation for constraint: string
        if (!is_null($j1_Genre) && !is_string($j1_Genre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($j1_Genre, true), gettype($j1_Genre)), __LINE__);
        }
        // validation for constraint: choice(F1_MMaxTechAdm, F2_MMaxAdmServ, G_MMaxAvecAttelage, G1_PoidsVide, J1_Genre, J3_Carrosserie, S1_NbPlaceAssise, Erreur, Code)
        if ('' !== ($j1_GenreChoiceErrorMessage = self::validateJ1_GenreForChoiceConstraintsFromSetJ1_Genre($j1_Genre))) {
            throw new \InvalidArgumentException($j1_GenreChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($j1_Genre) && mb_strlen($j1_Genre) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($j1_Genre)), __LINE__);
        }
        if (is_null($j1_Genre) || (is_array($j1_Genre) && empty($j1_Genre))) {
            unset($this->J1_Genre);
        } else {
            $this->J1_Genre = $j1_Genre;
        }
        return $this;
    }
    /**
     * Get J3_Carrosserie value
     * @return string
     */
    public function getJ3_Carrosserie()
    {
        return isset($this->J3_Carrosserie) ? $this->J3_Carrosserie : null;
    }
    /**
     * This method is responsible for validating the value passed to the setJ3_Carrosserie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJ3_Carrosserie method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateJ3_CarrosserieForChoiceConstraintsFromSetJ3_Carrosserie($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'F1_MMaxTechAdm',
            'F2_MMaxAdmServ',
            'G_MMaxAvecAttelage',
            'G1_PoidsVide',
            'J1_Genre',
            'S1_NbPlaceAssise',
            'Erreur',
            'Code',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property J3_Carrosserie can\'t be set as the property %s is already set. Only one property must be set among these properties: J3_Carrosserie, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set J3_Carrosserie value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $j3_Carrosserie
     * @return \StructType\InfoCoC_Rep
     */
    public function setJ3_Carrosserie($j3_Carrosserie = null)
    {
        // validation for constraint: string
        if (!is_null($j3_Carrosserie) && !is_string($j3_Carrosserie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($j3_Carrosserie, true), gettype($j3_Carrosserie)), __LINE__);
        }
        // validation for constraint: choice(F1_MMaxTechAdm, F2_MMaxAdmServ, G_MMaxAvecAttelage, G1_PoidsVide, J1_Genre, J3_Carrosserie, S1_NbPlaceAssise, Erreur, Code)
        if ('' !== ($j3_CarrosserieChoiceErrorMessage = self::validateJ3_CarrosserieForChoiceConstraintsFromSetJ3_Carrosserie($j3_Carrosserie))) {
            throw new \InvalidArgumentException($j3_CarrosserieChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($j3_Carrosserie) && mb_strlen($j3_Carrosserie) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($j3_Carrosserie)), __LINE__);
        }
        if (is_null($j3_Carrosserie) || (is_array($j3_Carrosserie) && empty($j3_Carrosserie))) {
            unset($this->J3_Carrosserie);
        } else {
            $this->J3_Carrosserie = $j3_Carrosserie;
        }
        return $this;
    }
    /**
     * Get S1_NbPlaceAssise value
     * @return int
     */
    public function getS1_NbPlaceAssise()
    {
        return isset($this->S1_NbPlaceAssise) ? $this->S1_NbPlaceAssise : null;
    }
    /**
     * This method is responsible for validating the value passed to the setS1_NbPlaceAssise method
     * This method is willingly generated in order to preserve the one-line inline validation within the setS1_NbPlaceAssise method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateS1_NbPlaceAssiseForChoiceConstraintsFromSetS1_NbPlaceAssise($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'F1_MMaxTechAdm',
            'F2_MMaxAdmServ',
            'G_MMaxAvecAttelage',
            'G1_PoidsVide',
            'J1_Genre',
            'J3_Carrosserie',
            'Erreur',
            'Code',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property S1_NbPlaceAssise can\'t be set as the property %s is already set. Only one property must be set among these properties: S1_NbPlaceAssise, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set S1_NbPlaceAssise value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $s1_NbPlaceAssise
     * @return \StructType\InfoCoC_Rep
     */
    public function setS1_NbPlaceAssise($s1_NbPlaceAssise = null)
    {
        // validation for constraint: int
        if (!is_null($s1_NbPlaceAssise) && !(is_int($s1_NbPlaceAssise) || ctype_digit($s1_NbPlaceAssise))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($s1_NbPlaceAssise, true), gettype($s1_NbPlaceAssise)), __LINE__);
        }
        // validation for constraint: choice(F1_MMaxTechAdm, F2_MMaxAdmServ, G_MMaxAvecAttelage, G1_PoidsVide, J1_Genre, J3_Carrosserie, S1_NbPlaceAssise, Erreur, Code)
        if ('' !== ($s1_NbPlaceAssiseChoiceErrorMessage = self::validateS1_NbPlaceAssiseForChoiceConstraintsFromSetS1_NbPlaceAssise($s1_NbPlaceAssise))) {
            throw new \InvalidArgumentException($s1_NbPlaceAssiseChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($s1_NbPlaceAssise) && mb_strlen(preg_replace('/(\D)/', '', $s1_NbPlaceAssise)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($s1_NbPlaceAssise, true), mb_strlen(preg_replace('/(\D)/', '', $s1_NbPlaceAssise))), __LINE__);
        }
        if (is_null($s1_NbPlaceAssise) || (is_array($s1_NbPlaceAssise) && empty($s1_NbPlaceAssise))) {
            unset($this->S1_NbPlaceAssise);
        } else {
            $this->S1_NbPlaceAssise = $s1_NbPlaceAssise;
        }
        return $this;
    }
    /**
     * Get Erreur value
     * @return string
     */
    public function getErreur()
    {
        return isset($this->Erreur) ? $this->Erreur : null;
    }
    /**
     * This method is responsible for validating the value passed to the setErreur method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErreur method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateErreurForChoiceConstraintsFromSetErreur($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'F1_MMaxTechAdm',
            'F2_MMaxAdmServ',
            'G_MMaxAvecAttelage',
            'G1_PoidsVide',
            'J1_Genre',
            'J3_Carrosserie',
            'S1_NbPlaceAssise',
            'Code',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Erreur can\'t be set as the property %s is already set. Only one property must be set among these properties: Erreur, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Erreur value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $erreur
     * @return \StructType\InfoCoC_Rep
     */
    public function setErreur($erreur = null)
    {
        // validation for constraint: string
        if (!is_null($erreur) && !is_string($erreur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erreur, true), gettype($erreur)), __LINE__);
        }
        // validation for constraint: choice(F1_MMaxTechAdm, F2_MMaxAdmServ, G_MMaxAvecAttelage, G1_PoidsVide, J1_Genre, J3_Carrosserie, S1_NbPlaceAssise, Erreur, Code)
        if ('' !== ($erreurChoiceErrorMessage = self::validateErreurForChoiceConstraintsFromSetErreur($erreur))) {
            throw new \InvalidArgumentException($erreurChoiceErrorMessage, __LINE__);
        }
        if (is_null($erreur) || (is_array($erreur) && empty($erreur))) {
            unset($this->Erreur);
        } else {
            $this->Erreur = $erreur;
        }
        return $this;
    }
    /**
     * Get Code value
     * @return int
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCode method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCodeForChoiceConstraintsFromSetCode($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'F1_MMaxTechAdm',
            'F2_MMaxAdmServ',
            'G_MMaxAvecAttelage',
            'G1_PoidsVide',
            'J1_Genre',
            'J3_Carrosserie',
            'S1_NbPlaceAssise',
            'Erreur',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Code can\'t be set as the property %s is already set. Only one property must be set among these properties: Code, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Code value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $code
     * @return \StructType\InfoCoC_Rep
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: choice(F1_MMaxTechAdm, F2_MMaxAdmServ, G_MMaxAvecAttelage, G1_PoidsVide, J1_Genre, J3_Carrosserie, S1_NbPlaceAssise, Erreur, Code)
        if ('' !== ($codeChoiceErrorMessage = self::validateCodeForChoiceConstraintsFromSetCode($code))) {
            throw new \InvalidArgumentException($codeChoiceErrorMessage, __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
}
