<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Rechercher ServiceType
 * @subpackage Services
 */
class Rechercher extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RechercherArchive
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RechercherArchive_Req $rechercherArchiveRepMsg
     * @return \StructType\RechercherArchive_Rep|bool
     */
    public function RechercherArchive(\StructType\RechercherArchive_Req $rechercherArchiveRepMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->RechercherArchive($rechercherArchiveRepMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RechercherArchive_Rep
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
