<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Lot StructType
 * @subpackage Structs
 */
class Lot extends AbstractStructBase
{
    /**
     * The Demarche
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\TypeDemarche[]
     */
    public $Demarche;
    /**
     * The Origine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Origine;
    /**
     * The Canal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Canal;
    /**
     * Constructor method for Lot
     * @uses Lot::setDemarche()
     * @uses Lot::setOrigine()
     * @uses Lot::setCanal()
     * @param \StructType\TypeDemarche[] $demarche
     * @param string $origine
     * @param string $canal
     */
    public function __construct(array $demarche = array(), $origine = null, $canal = null)
    {
        $this
            ->setDemarche($demarche)
            ->setOrigine($origine)
            ->setCanal($canal);
    }
    /**
     * Get Demarche value
     * @return \StructType\TypeDemarche[]
     */
    public function getDemarche()
    {
        return $this->Demarche;
    }
    /**
     * This method is responsible for validating the values passed to the setDemarche method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDemarche method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDemarcheForArrayConstraintsFromSetDemarche(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lotDemarcheItem) {
            // validation for constraint: itemType
            if (!$lotDemarcheItem instanceof \StructType\TypeDemarche) {
                $invalidValues[] = is_object($lotDemarcheItem) ? get_class($lotDemarcheItem) : sprintf('%s(%s)', gettype($lotDemarcheItem), var_export($lotDemarcheItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Demarche property can only contain items of type \StructType\TypeDemarche, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Demarche value
     * @throws \InvalidArgumentException
     * @param \StructType\TypeDemarche[] $demarche
     * @return \StructType\Lot
     */
    public function setDemarche(array $demarche = array())
    {
        // validation for constraint: array
        if ('' !== ($demarcheArrayErrorMessage = self::validateDemarcheForArrayConstraintsFromSetDemarche($demarche))) {
            throw new \InvalidArgumentException($demarcheArrayErrorMessage, __LINE__);
        }
        $this->Demarche = $demarche;
        return $this;
    }
    /**
     * Add item to Demarche value
     * @throws \InvalidArgumentException
     * @param \StructType\TypeDemarche $item
     * @return \StructType\Lot
     */
    public function addToDemarche(\StructType\TypeDemarche $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TypeDemarche) {
            throw new \InvalidArgumentException(sprintf('The Demarche property can only contain items of type \StructType\TypeDemarche, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Demarche[] = $item;
        return $this;
    }
    /**
     * Get Origine value
     * @return string|null
     */
    public function getOrigine()
    {
        return $this->Origine;
    }
    /**
     * Set Origine value
     * @param string $origine
     * @return \StructType\Lot
     */
    public function setOrigine($origine = null)
    {
        // validation for constraint: string
        if (!is_null($origine) && !is_string($origine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origine, true), gettype($origine)), __LINE__);
        }
        $this->Origine = $origine;
        return $this;
    }
    /**
     * Get Canal value
     * @return string|null
     */
    public function getCanal()
    {
        return $this->Canal;
    }
    /**
     * Set Canal value
     * @uses \EnumType\TypeCanal::valueIsValid()
     * @uses \EnumType\TypeCanal::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $canal
     * @return \StructType\Lot
     */
    public function setCanal($canal = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeCanal::valueIsValid($canal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeCanal', is_array($canal) ? implode(', ', $canal) : var_export($canal, true), implode(', ', \EnumType\TypeCanal::getValidValues())), __LINE__);
        }
        $this->Canal = $canal;
        return $this;
    }
}
