<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reponse StructType
 * @subpackage Structs
 */
class Reponse extends AbstractStructBase
{
    /**
     * The Statut
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Statut;
    /**
     * The DateDemande
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateDemande;
    /**
     * The DateReceptionSIV
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateReceptionSIV;
    /**
     * The DateReponseSIV
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateReponseSIV;
    /**
     * The Negative
     * Meta information extracted from the WSDL
     * - choice: Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive
     * | Negative | Positive | Negative | Positive | Positive | Negative | Positive | Negative | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Positive | Negative | Positive | Negative |
     * Positive | Negative | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Positive | Negative
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Negative
     */
    public $Negative;
    /**
     * The Positive
     * Meta information extracted from the WSDL
     * - choice: Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive
     * | Negative | Positive | Negative | Positive | Positive | Negative | Positive | Negative | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Positive | Negative | Positive | Negative |
     * Positive | Negative | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Negative | Positive | Positive | Negative
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TypeInfoVehicule
     */
    public $Positive;
    /**
     * Constructor method for Reponse
     * @uses Reponse::setStatut()
     * @uses Reponse::setDateDemande()
     * @uses Reponse::setDateReceptionSIV()
     * @uses Reponse::setDateReponseSIV()
     * @uses Reponse::setNegative()
     * @uses Reponse::setPositive()
     * @param string $statut
     * @param string $dateDemande
     * @param string $dateReceptionSIV
     * @param string $dateReponseSIV
     * @param \StructType\Negative $negative
     * @param \StructType\TypeInfoVehicule $positive
     */
    public function __construct($statut = null, $dateDemande = null, $dateReceptionSIV = null, $dateReponseSIV = null, \StructType\Negative $negative = null, \StructType\TypeInfoVehicule $positive = null)
    {
        $this
            ->setStatut($statut)
            ->setDateDemande($dateDemande)
            ->setDateReceptionSIV($dateReceptionSIV)
            ->setDateReponseSIV($dateReponseSIV)
            ->setNegative($negative)
            ->setPositive($positive);
    }
    /**
     * Get Statut value
     * @return string
     */
    public function getStatut()
    {
        return $this->Statut;
    }
    /**
     * Set Statut value
     * @uses \EnumType\TypeStatusDemarche::valueIsValid()
     * @uses \EnumType\TypeStatusDemarche::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statut
     * @return \StructType\Reponse
     */
    public function setStatut($statut = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeStatusDemarche::valueIsValid($statut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeStatusDemarche', is_array($statut) ? implode(', ', $statut) : var_export($statut, true), implode(', ', \EnumType\TypeStatusDemarche::getValidValues())), __LINE__);
        }
        $this->Statut = $statut;
        return $this;
    }
    /**
     * Get DateDemande value
     * @return string
     */
    public function getDateDemande()
    {
        return $this->DateDemande;
    }
    /**
     * Set DateDemande value
     * @param string $dateDemande
     * @return \StructType\Reponse
     */
    public function setDateDemande($dateDemande = null)
    {
        // validation for constraint: string
        if (!is_null($dateDemande) && !is_string($dateDemande)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateDemande, true), gettype($dateDemande)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateDemande) && mb_strlen($dateDemande) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateDemande)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateDemande) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateDemande)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateDemande, true)), __LINE__);
        }
        $this->DateDemande = $dateDemande;
        return $this;
    }
    /**
     * Get DateReceptionSIV value
     * @return string
     */
    public function getDateReceptionSIV()
    {
        return $this->DateReceptionSIV;
    }
    /**
     * Set DateReceptionSIV value
     * @param string $dateReceptionSIV
     * @return \StructType\Reponse
     */
    public function setDateReceptionSIV($dateReceptionSIV = null)
    {
        // validation for constraint: string
        if (!is_null($dateReceptionSIV) && !is_string($dateReceptionSIV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateReceptionSIV, true), gettype($dateReceptionSIV)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateReceptionSIV) && mb_strlen($dateReceptionSIV) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateReceptionSIV)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateReceptionSIV) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateReceptionSIV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateReceptionSIV, true)), __LINE__);
        }
        $this->DateReceptionSIV = $dateReceptionSIV;
        return $this;
    }
    /**
     * Get DateReponseSIV value
     * @return string
     */
    public function getDateReponseSIV()
    {
        return $this->DateReponseSIV;
    }
    /**
     * Set DateReponseSIV value
     * @param string $dateReponseSIV
     * @return \StructType\Reponse
     */
    public function setDateReponseSIV($dateReponseSIV = null)
    {
        // validation for constraint: string
        if (!is_null($dateReponseSIV) && !is_string($dateReponseSIV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateReponseSIV, true), gettype($dateReponseSIV)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateReponseSIV) && mb_strlen($dateReponseSIV) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateReponseSIV)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateReponseSIV) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateReponseSIV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateReponseSIV, true)), __LINE__);
        }
        $this->DateReponseSIV = $dateReponseSIV;
        return $this;
    }
    /**
     * Get Negative value
     * @return \StructType\Negative|null
     */
    public function getNegative()
    {
        return isset($this->Negative) ? $this->Negative : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNegative method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNegative method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNegativeForChoiceConstraintsFromSetNegative($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
            'Positive',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Negative can\'t be set as the property %s is already set. Only one property must be set among these properties: Negative, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Negative value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Negative $negative
     * @return \StructType\Reponse
     */
    public function setNegative(\StructType\Negative $negative = null)
    {
        // validation for constraint: choice(Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Positive, Negative, Positive, Negative, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Positive, Negative, Positive, Negative, Positive, Negative, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Positive, Negative)
        if ('' !== ($negativeChoiceErrorMessage = self::validateNegativeForChoiceConstraintsFromSetNegative($negative))) {
            throw new \InvalidArgumentException($negativeChoiceErrorMessage, __LINE__);
        }
        if (is_null($negative) || (is_array($negative) && empty($negative))) {
            unset($this->Negative);
        } else {
            $this->Negative = $negative;
        }
        return $this;
    }
    /**
     * Get Positive value
     * @return \StructType\TypeInfoVehicule|null
     */
    public function getPositive()
    {
        return isset($this->Positive) ? $this->Positive : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPositive method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPositive method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePositiveForChoiceConstraintsFromSetPositive($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
            'Negative',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Positive can\'t be set as the property %s is already set. Only one property must be set among these properties: Positive, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Positive value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TypeInfoVehicule $positive
     * @return \StructType\Reponse
     */
    public function setPositive(\StructType\TypeInfoVehicule $positive = null)
    {
        // validation for constraint: choice(Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Positive, Negative, Positive, Negative, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Positive, Negative, Positive, Negative, Positive, Negative, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Negative, Positive, Positive, Negative)
        if ('' !== ($positiveChoiceErrorMessage = self::validatePositiveForChoiceConstraintsFromSetPositive($positive))) {
            throw new \InvalidArgumentException($positiveChoiceErrorMessage, __LINE__);
        }
        if (is_null($positive) || (is_array($positive) && empty($positive))) {
            unset($this->Positive);
        } else {
            $this->Positive = $positive;
        }
        return $this;
    }
}
