<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TypeDNF StructType
 * @subpackage Structs
 */
class TypeDNF extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The TypeDemarche
     * Meta information extracted from the WSDL
     * - fixed: DNF
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeDemarche;
    /**
     * The Vehicule
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Vehicule
     */
    public $Vehicule;
    /**
     * The Reponse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Reponse
     */
    public $Reponse;
    /**
     * Constructor method for TypeDNF
     * @uses TypeDNF::setID()
     * @uses TypeDNF::setTypeDemarche()
     * @uses TypeDNF::setVehicule()
     * @uses TypeDNF::setReponse()
     * @param int $iD
     * @param string $typeDemarche
     * @param \StructType\Vehicule $vehicule
     * @param \StructType\Reponse $reponse
     */
    public function __construct($iD = null, $typeDemarche = null, \StructType\Vehicule $vehicule = null, \StructType\Reponse $reponse = null)
    {
        $this
            ->setID($iD)
            ->setTypeDemarche($typeDemarche)
            ->setVehicule($vehicule)
            ->setReponse($reponse);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\TypeDNF
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get TypeDemarche value
     * @return string
     */
    public function getTypeDemarche()
    {
        return $this->TypeDemarche;
    }
    /**
     * Set TypeDemarche value
     * @param string $typeDemarche
     * @return \StructType\TypeDNF
     */
    public function setTypeDemarche($typeDemarche = null)
    {
        // validation for constraint: string
        if (!is_null($typeDemarche) && !is_string($typeDemarche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeDemarche, true), gettype($typeDemarche)), __LINE__);
        }
        $this->TypeDemarche = $typeDemarche;
        return $this;
    }
    /**
     * Get Vehicule value
     * @return \StructType\Vehicule
     */
    public function getVehicule()
    {
        return $this->Vehicule;
    }
    /**
     * Set Vehicule value
     * @param \StructType\Vehicule $vehicule
     * @return \StructType\TypeDNF
     */
    public function setVehicule(\StructType\Vehicule $vehicule = null)
    {
        $this->Vehicule = $vehicule;
        return $this;
    }
    /**
     * Get Reponse value
     * @return \StructType\Reponse|null
     */
    public function getReponse()
    {
        return $this->Reponse;
    }
    /**
     * Set Reponse value
     * @param \StructType\Reponse $reponse
     * @return \StructType\TypeDNF
     */
    public function setReponse(\StructType\Reponse $reponse = null)
    {
        $this->Reponse = $reponse;
        return $this;
    }
}
