<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfoCoC_Req StructType
 * @subpackage Structs
 */
class InfoCoC_Req extends AbstractStructBase
{
    /**
     * The VIN
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - pattern: [0-9A-Z]*
     * @var string
     */
    public $VIN;
    /**
     * The D2_Version
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $D2_Version;
    /**
     * The K_NumRecepCE
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $K_NumRecepCE;
    /**
     * The Identification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TypeIdentification
     */
    public $Identification;
    /**
     * The TypeDemarche
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TypeDemarche
     */
    public $TypeDemarche;
    /**
     * Constructor method for InfoCoC_Req
     * @uses InfoCoC_Req::setVIN()
     * @uses InfoCoC_Req::setD2_Version()
     * @uses InfoCoC_Req::setK_NumRecepCE()
     * @uses InfoCoC_Req::setIdentification()
     * @uses InfoCoC_Req::setTypeDemarche()
     * @param string $vIN
     * @param string $d2_Version
     * @param string $k_NumRecepCE
     * @param \StructType\TypeIdentification $identification
     * @param \StructType\TypeDemarche $typeDemarche
     */
    public function __construct($vIN = null, $d2_Version = null, $k_NumRecepCE = null, \StructType\TypeIdentification $identification = null, \StructType\TypeDemarche $typeDemarche = null)
    {
        $this
            ->setVIN($vIN)
            ->setD2_Version($d2_Version)
            ->setK_NumRecepCE($k_NumRecepCE)
            ->setIdentification($identification)
            ->setTypeDemarche($typeDemarche);
    }
    /**
     * Get VIN value
     * @return string
     */
    public function getVIN()
    {
        return $this->VIN;
    }
    /**
     * Set VIN value
     * @param string $vIN
     * @return \StructType\InfoCoC_Req
     */
    public function setVIN($vIN = null)
    {
        // validation for constraint: string
        if (!is_null($vIN) && !is_string($vIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vIN, true), gettype($vIN)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($vIN) && mb_strlen($vIN) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($vIN)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($vIN) && mb_strlen($vIN) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($vIN)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]*)
        if (!is_null($vIN) && !preg_match('/[0-9A-Z]*/', $vIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]*', var_export($vIN, true)), __LINE__);
        }
        $this->VIN = $vIN;
        return $this;
    }
    /**
     * Get D2_Version value
     * @return string
     */
    public function getD2_Version()
    {
        return $this->D2_Version;
    }
    /**
     * Set D2_Version value
     * @param string $d2_Version
     * @return \StructType\InfoCoC_Req
     */
    public function setD2_Version($d2_Version = null)
    {
        // validation for constraint: string
        if (!is_null($d2_Version) && !is_string($d2_Version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($d2_Version, true), gettype($d2_Version)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($d2_Version) && mb_strlen($d2_Version) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($d2_Version)), __LINE__);
        }
        $this->D2_Version = $d2_Version;
        return $this;
    }
    /**
     * Get K_NumRecepCE value
     * @return string
     */
    public function getK_NumRecepCE()
    {
        return $this->K_NumRecepCE;
    }
    /**
     * Set K_NumRecepCE value
     * @param string $k_NumRecepCE
     * @return \StructType\InfoCoC_Req
     */
    public function setK_NumRecepCE($k_NumRecepCE = null)
    {
        // validation for constraint: string
        if (!is_null($k_NumRecepCE) && !is_string($k_NumRecepCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($k_NumRecepCE, true), gettype($k_NumRecepCE)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($k_NumRecepCE) && mb_strlen($k_NumRecepCE) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($k_NumRecepCE)), __LINE__);
        }
        $this->K_NumRecepCE = $k_NumRecepCE;
        return $this;
    }
    /**
     * Get Identification value
     * @return \StructType\TypeIdentification|null
     */
    public function getIdentification()
    {
        return $this->Identification;
    }
    /**
     * Set Identification value
     * @param \StructType\TypeIdentification $identification
     * @return \StructType\InfoCoC_Req
     */
    public function setIdentification(\StructType\TypeIdentification $identification = null)
    {
        $this->Identification = $identification;
        return $this;
    }
    /**
     * Get TypeDemarche value
     * @return \StructType\TypeDemarche|null
     */
    public function getTypeDemarche()
    {
        return $this->TypeDemarche;
    }
    /**
     * Set TypeDemarche value
     * @param \StructType\TypeDemarche $typeDemarche
     * @return \StructType\InfoCoC_Req
     */
    public function setTypeDemarche(\StructType\TypeDemarche $typeDemarche = null)
    {
        $this->TypeDemarche = $typeDemarche;
        return $this;
    }
}
