<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expedition StructType
 * @subpackage Structs
 */
class Expedition extends AbstractStructBase
{
    /**
     * The RaisonSociale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RaisonSociale;
    /**
     * The SIRET
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 14
     * - maxOccurs: 1
     * - minLength: 9
     * - minOccurs: 1
     * - pattern: [0-9]{9,14}
     * @var string
     */
    public $SIRET;
    /**
     * The Adresse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeAdresse
     */
    public $Adresse;
    /**
     * The DroitOpposition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DroitOpposition;
    /**
     * Constructor method for Expedition
     * @uses Expedition::setRaisonSociale()
     * @uses Expedition::setSIRET()
     * @uses Expedition::setAdresse()
     * @uses Expedition::setDroitOpposition()
     * @param string $raisonSociale
     * @param string $sIRET
     * @param \StructType\TypeAdresse $adresse
     * @param bool $droitOpposition
     */
    public function __construct($raisonSociale = null, $sIRET = null, \StructType\TypeAdresse $adresse = null, $droitOpposition = null)
    {
        $this
            ->setRaisonSociale($raisonSociale)
            ->setSIRET($sIRET)
            ->setAdresse($adresse)
            ->setDroitOpposition($droitOpposition);
    }
    /**
     * Get RaisonSociale value
     * @return string
     */
    public function getRaisonSociale()
    {
        return $this->RaisonSociale;
    }
    /**
     * Set RaisonSociale value
     * @param string $raisonSociale
     * @return \StructType\Expedition
     */
    public function setRaisonSociale($raisonSociale = null)
    {
        // validation for constraint: string
        if (!is_null($raisonSociale) && !is_string($raisonSociale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($raisonSociale, true), gettype($raisonSociale)), __LINE__);
        }
        $this->RaisonSociale = $raisonSociale;
        return $this;
    }
    /**
     * Get SIRET value
     * @return string
     */
    public function getSIRET()
    {
        return $this->SIRET;
    }
    /**
     * Set SIRET value
     * @param string $sIRET
     * @return \StructType\Expedition
     */
    public function setSIRET($sIRET = null)
    {
        // validation for constraint: string
        if (!is_null($sIRET) && !is_string($sIRET)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sIRET, true), gettype($sIRET)), __LINE__);
        }
        // validation for constraint: maxLength(14)
        if (!is_null($sIRET) && mb_strlen($sIRET) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 14', mb_strlen($sIRET)), __LINE__);
        }
        // validation for constraint: minLength(9)
        if (!is_null($sIRET) && mb_strlen($sIRET) < 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 9', mb_strlen($sIRET)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{9,14})
        if (!is_null($sIRET) && !preg_match('/[0-9]{9,14}/', $sIRET)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{9,14}', var_export($sIRET, true)), __LINE__);
        }
        $this->SIRET = $sIRET;
        return $this;
    }
    /**
     * Get Adresse value
     * @return \StructType\TypeAdresse
     */
    public function getAdresse()
    {
        return $this->Adresse;
    }
    /**
     * Set Adresse value
     * @param \StructType\TypeAdresse $adresse
     * @return \StructType\Expedition
     */
    public function setAdresse(\StructType\TypeAdresse $adresse = null)
    {
        $this->Adresse = $adresse;
        return $this;
    }
    /**
     * Get DroitOpposition value
     * @return bool
     */
    public function getDroitOpposition()
    {
        return $this->DroitOpposition;
    }
    /**
     * Set DroitOpposition value
     * @param bool $droitOpposition
     * @return \StructType\Expedition
     */
    public function setDroitOpposition($droitOpposition = null)
    {
        // validation for constraint: boolean
        if (!is_null($droitOpposition) && !is_bool($droitOpposition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($droitOpposition, true), gettype($droitOpposition)), __LINE__);
        }
        $this->DroitOpposition = $droitOpposition;
        return $this;
    }
}
