<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TypePIVOL StructType
 * @subpackage Structs
 */
class TypePIVOL extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The TypeDemarche
     * Meta information extracted from the WSDL
     * - fixed: PIVOL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeDemarche;
    /**
     * The DateDemarche
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateDemarche;
    /**
     * The TypeLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeLocation;
    /**
     * The ModeExpedition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ModeExpedition;
    /**
     * The Acquereur
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Acquereur
     */
    public $Acquereur;
    /**
     * The Vehicule
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeVI
     */
    public $Vehicule;
    /**
     * The PaiementCBClient
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $PaiementCBClient;
    /**
     * The NumPortable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumPortable;
    /**
     * The EmissionBO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $EmissionBO;
    /**
     * The ExoPickUp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ExoPickUp;
    /**
     * The Locataire
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Locataire
     */
    public $Locataire;
    /**
     * The Loueur
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Loueur
     */
    public $Loueur;
    /**
     * The Expedition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Expedition
     */
    public $Expedition;
    /**
     * The Reponse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Reponse
     */
    public $Reponse;
    /**
     * Constructor method for TypePIVOL
     * @uses TypePIVOL::setID()
     * @uses TypePIVOL::setTypeDemarche()
     * @uses TypePIVOL::setDateDemarche()
     * @uses TypePIVOL::setTypeLocation()
     * @uses TypePIVOL::setModeExpedition()
     * @uses TypePIVOL::setAcquereur()
     * @uses TypePIVOL::setVehicule()
     * @uses TypePIVOL::setPaiementCBClient()
     * @uses TypePIVOL::setNumPortable()
     * @uses TypePIVOL::setEmissionBO()
     * @uses TypePIVOL::setExoPickUp()
     * @uses TypePIVOL::setLocataire()
     * @uses TypePIVOL::setLoueur()
     * @uses TypePIVOL::setExpedition()
     * @uses TypePIVOL::setReponse()
     * @param int $iD
     * @param string $typeDemarche
     * @param string $dateDemarche
     * @param string $typeLocation
     * @param string $modeExpedition
     * @param \StructType\Acquereur $acquereur
     * @param \StructType\TypeVI $vehicule
     * @param bool $paiementCBClient
     * @param string $numPortable
     * @param bool $emissionBO
     * @param bool $exoPickUp
     * @param \StructType\Locataire $locataire
     * @param \StructType\Loueur $loueur
     * @param \StructType\Expedition $expedition
     * @param \StructType\Reponse $reponse
     */
    public function __construct($iD = null, $typeDemarche = null, $dateDemarche = null, $typeLocation = null, $modeExpedition = null, \StructType\Acquereur $acquereur = null, \StructType\TypeVI $vehicule = null, $paiementCBClient = null, $numPortable = null, $emissionBO = null, $exoPickUp = null, \StructType\Locataire $locataire = null, \StructType\Loueur $loueur = null, \StructType\Expedition $expedition = null, \StructType\Reponse $reponse = null)
    {
        $this
            ->setID($iD)
            ->setTypeDemarche($typeDemarche)
            ->setDateDemarche($dateDemarche)
            ->setTypeLocation($typeLocation)
            ->setModeExpedition($modeExpedition)
            ->setAcquereur($acquereur)
            ->setVehicule($vehicule)
            ->setPaiementCBClient($paiementCBClient)
            ->setNumPortable($numPortable)
            ->setEmissionBO($emissionBO)
            ->setExoPickUp($exoPickUp)
            ->setLocataire($locataire)
            ->setLoueur($loueur)
            ->setExpedition($expedition)
            ->setReponse($reponse);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\TypePIVOL
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get TypeDemarche value
     * @return string
     */
    public function getTypeDemarche()
    {
        return $this->TypeDemarche;
    }
    /**
     * Set TypeDemarche value
     * @param string $typeDemarche
     * @return \StructType\TypePIVOL
     */
    public function setTypeDemarche($typeDemarche = null)
    {
        // validation for constraint: string
        if (!is_null($typeDemarche) && !is_string($typeDemarche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeDemarche, true), gettype($typeDemarche)), __LINE__);
        }
        $this->TypeDemarche = $typeDemarche;
        return $this;
    }
    /**
     * Get DateDemarche value
     * @return string
     */
    public function getDateDemarche()
    {
        return $this->DateDemarche;
    }
    /**
     * Set DateDemarche value
     * @param string $dateDemarche
     * @return \StructType\TypePIVOL
     */
    public function setDateDemarche($dateDemarche = null)
    {
        // validation for constraint: string
        if (!is_null($dateDemarche) && !is_string($dateDemarche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateDemarche, true), gettype($dateDemarche)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateDemarche) && mb_strlen($dateDemarche) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateDemarche)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateDemarche) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateDemarche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateDemarche, true)), __LINE__);
        }
        $this->DateDemarche = $dateDemarche;
        return $this;
    }
    /**
     * Get TypeLocation value
     * @return string
     */
    public function getTypeLocation()
    {
        return $this->TypeLocation;
    }
    /**
     * Set TypeLocation value
     * @uses \EnumType\TypeLoc::valueIsValid()
     * @uses \EnumType\TypeLoc::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeLocation
     * @return \StructType\TypePIVOL
     */
    public function setTypeLocation($typeLocation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeLoc::valueIsValid($typeLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeLoc', is_array($typeLocation) ? implode(', ', $typeLocation) : var_export($typeLocation, true), implode(', ', \EnumType\TypeLoc::getValidValues())), __LINE__);
        }
        $this->TypeLocation = $typeLocation;
        return $this;
    }
    /**
     * Get ModeExpedition value
     * @return string
     */
    public function getModeExpedition()
    {
        return $this->ModeExpedition;
    }
    /**
     * Set ModeExpedition value
     * @uses \EnumType\ModeExp::valueIsValid()
     * @uses \EnumType\ModeExp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $modeExpedition
     * @return \StructType\TypePIVOL
     */
    public function setModeExpedition($modeExpedition = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ModeExp::valueIsValid($modeExpedition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ModeExp', is_array($modeExpedition) ? implode(', ', $modeExpedition) : var_export($modeExpedition, true), implode(', ', \EnumType\ModeExp::getValidValues())), __LINE__);
        }
        $this->ModeExpedition = $modeExpedition;
        return $this;
    }
    /**
     * Get Acquereur value
     * @return \StructType\Acquereur
     */
    public function getAcquereur()
    {
        return $this->Acquereur;
    }
    /**
     * Set Acquereur value
     * @param \StructType\Acquereur $acquereur
     * @return \StructType\TypePIVOL
     */
    public function setAcquereur(\StructType\Acquereur $acquereur = null)
    {
        $this->Acquereur = $acquereur;
        return $this;
    }
    /**
     * Get Vehicule value
     * @return \StructType\TypeVI
     */
    public function getVehicule()
    {
        return $this->Vehicule;
    }
    /**
     * Set Vehicule value
     * @param \StructType\TypeVI $vehicule
     * @return \StructType\TypePIVOL
     */
    public function setVehicule(\StructType\TypeVI $vehicule = null)
    {
        $this->Vehicule = $vehicule;
        return $this;
    }
    /**
     * Get PaiementCBClient value
     * @return bool|null
     */
    public function getPaiementCBClient()
    {
        return $this->PaiementCBClient;
    }
    /**
     * Set PaiementCBClient value
     * @param bool $paiementCBClient
     * @return \StructType\TypePIVOL
     */
    public function setPaiementCBClient($paiementCBClient = null)
    {
        // validation for constraint: boolean
        if (!is_null($paiementCBClient) && !is_bool($paiementCBClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paiementCBClient, true), gettype($paiementCBClient)), __LINE__);
        }
        $this->PaiementCBClient = $paiementCBClient;
        return $this;
    }
    /**
     * Get NumPortable value
     * @return string|null
     */
    public function getNumPortable()
    {
        return $this->NumPortable;
    }
    /**
     * Set NumPortable value
     * @param string $numPortable
     * @return \StructType\TypePIVOL
     */
    public function setNumPortable($numPortable = null)
    {
        // validation for constraint: string
        if (!is_null($numPortable) && !is_string($numPortable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numPortable, true), gettype($numPortable)), __LINE__);
        }
        $this->NumPortable = $numPortable;
        return $this;
    }
    /**
     * Get EmissionBO value
     * @return bool|null
     */
    public function getEmissionBO()
    {
        return $this->EmissionBO;
    }
    /**
     * Set EmissionBO value
     * @param bool $emissionBO
     * @return \StructType\TypePIVOL
     */
    public function setEmissionBO($emissionBO = null)
    {
        // validation for constraint: boolean
        if (!is_null($emissionBO) && !is_bool($emissionBO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emissionBO, true), gettype($emissionBO)), __LINE__);
        }
        $this->EmissionBO = $emissionBO;
        return $this;
    }
    /**
     * Get ExoPickUp value
     * @return bool|null
     */
    public function getExoPickUp()
    {
        return $this->ExoPickUp;
    }
    /**
     * Set ExoPickUp value
     * @param bool $exoPickUp
     * @return \StructType\TypePIVOL
     */
    public function setExoPickUp($exoPickUp = null)
    {
        // validation for constraint: boolean
        if (!is_null($exoPickUp) && !is_bool($exoPickUp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exoPickUp, true), gettype($exoPickUp)), __LINE__);
        }
        $this->ExoPickUp = $exoPickUp;
        return $this;
    }
    /**
     * Get Locataire value
     * @return \StructType\Locataire|null
     */
    public function getLocataire()
    {
        return $this->Locataire;
    }
    /**
     * Set Locataire value
     * @param \StructType\Locataire $locataire
     * @return \StructType\TypePIVOL
     */
    public function setLocataire(\StructType\Locataire $locataire = null)
    {
        $this->Locataire = $locataire;
        return $this;
    }
    /**
     * Get Loueur value
     * @return \StructType\Loueur|null
     */
    public function getLoueur()
    {
        return $this->Loueur;
    }
    /**
     * Set Loueur value
     * @param \StructType\Loueur $loueur
     * @return \StructType\TypePIVOL
     */
    public function setLoueur(\StructType\Loueur $loueur = null)
    {
        $this->Loueur = $loueur;
        return $this;
    }
    /**
     * Get Expedition value
     * @return \StructType\Expedition|null
     */
    public function getExpedition()
    {
        return $this->Expedition;
    }
    /**
     * Set Expedition value
     * @param \StructType\Expedition $expedition
     * @return \StructType\TypePIVOL
     */
    public function setExpedition(\StructType\Expedition $expedition = null)
    {
        $this->Expedition = $expedition;
        return $this;
    }
    /**
     * Get Reponse value
     * @return \StructType\Reponse|null
     */
    public function getReponse()
    {
        return $this->Reponse;
    }
    /**
     * Set Reponse value
     * @param \StructType\Reponse $reponse
     * @return \StructType\TypePIVOL
     */
    public function setReponse(\StructType\Reponse $reponse = null)
    {
        $this->Reponse = $reponse;
        return $this;
    }
}
