<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TypeFUD StructType
 * @subpackage Structs
 */
class TypeFUD extends AbstractStructBase
{
    /**
     * The TypeDemarche
     * Meta information extracted from the WSDL
     * - fixed: FUD
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeDemarche;
    /**
     * The DateDemarche
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateDemarche;
    /**
     * The Motif
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Motif;
    /**
     * The Titulaire
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Titulaire
     */
    public $Titulaire;
    /**
     * The Vehicule
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Vehicule
     */
    public $Vehicule;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The PaiementCBClient
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $PaiementCBClient;
    /**
     * The EmissionBO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $EmissionBO;
    /**
     * The CertifReglement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $CertifReglement;
    /**
     * The Reponse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Reponse
     */
    public $Reponse;
    /**
     * Constructor method for TypeFUD
     * @uses TypeFUD::setTypeDemarche()
     * @uses TypeFUD::setDateDemarche()
     * @uses TypeFUD::setMotif()
     * @uses TypeFUD::setTitulaire()
     * @uses TypeFUD::setVehicule()
     * @uses TypeFUD::setID()
     * @uses TypeFUD::setPaiementCBClient()
     * @uses TypeFUD::setEmissionBO()
     * @uses TypeFUD::setCertifReglement()
     * @uses TypeFUD::setReponse()
     * @param string $typeDemarche
     * @param string $dateDemarche
     * @param string $motif
     * @param \StructType\Titulaire $titulaire
     * @param \StructType\Vehicule $vehicule
     * @param int $iD
     * @param bool $paiementCBClient
     * @param bool $emissionBO
     * @param bool $certifReglement
     * @param \StructType\Reponse $reponse
     */
    public function __construct($typeDemarche = null, $dateDemarche = null, $motif = null, \StructType\Titulaire $titulaire = null, \StructType\Vehicule $vehicule = null, $iD = null, $paiementCBClient = null, $emissionBO = null, $certifReglement = null, \StructType\Reponse $reponse = null)
    {
        $this
            ->setTypeDemarche($typeDemarche)
            ->setDateDemarche($dateDemarche)
            ->setMotif($motif)
            ->setTitulaire($titulaire)
            ->setVehicule($vehicule)
            ->setID($iD)
            ->setPaiementCBClient($paiementCBClient)
            ->setEmissionBO($emissionBO)
            ->setCertifReglement($certifReglement)
            ->setReponse($reponse);
    }
    /**
     * Get TypeDemarche value
     * @return string
     */
    public function getTypeDemarche()
    {
        return $this->TypeDemarche;
    }
    /**
     * Set TypeDemarche value
     * @param string $typeDemarche
     * @return \StructType\TypeFUD
     */
    public function setTypeDemarche($typeDemarche = null)
    {
        // validation for constraint: string
        if (!is_null($typeDemarche) && !is_string($typeDemarche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeDemarche, true), gettype($typeDemarche)), __LINE__);
        }
        $this->TypeDemarche = $typeDemarche;
        return $this;
    }
    /**
     * Get DateDemarche value
     * @return string
     */
    public function getDateDemarche()
    {
        return $this->DateDemarche;
    }
    /**
     * Set DateDemarche value
     * @param string $dateDemarche
     * @return \StructType\TypeFUD
     */
    public function setDateDemarche($dateDemarche = null)
    {
        // validation for constraint: string
        if (!is_null($dateDemarche) && !is_string($dateDemarche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateDemarche, true), gettype($dateDemarche)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateDemarche) && mb_strlen($dateDemarche) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateDemarche)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateDemarche) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateDemarche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateDemarche, true)), __LINE__);
        }
        $this->DateDemarche = $dateDemarche;
        return $this;
    }
    /**
     * Get Motif value
     * @return string
     */
    public function getMotif()
    {
        return $this->Motif;
    }
    /**
     * Set Motif value
     * @uses \EnumType\MotifFUD::valueIsValid()
     * @uses \EnumType\MotifFUD::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $motif
     * @return \StructType\TypeFUD
     */
    public function setMotif($motif = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MotifFUD::valueIsValid($motif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MotifFUD', is_array($motif) ? implode(', ', $motif) : var_export($motif, true), implode(', ', \EnumType\MotifFUD::getValidValues())), __LINE__);
        }
        $this->Motif = $motif;
        return $this;
    }
    /**
     * Get Titulaire value
     * @return \StructType\Titulaire
     */
    public function getTitulaire()
    {
        return $this->Titulaire;
    }
    /**
     * Set Titulaire value
     * @param \StructType\Titulaire $titulaire
     * @return \StructType\TypeFUD
     */
    public function setTitulaire(\StructType\Titulaire $titulaire = null)
    {
        $this->Titulaire = $titulaire;
        return $this;
    }
    /**
     * Get Vehicule value
     * @return \StructType\Vehicule
     */
    public function getVehicule()
    {
        return $this->Vehicule;
    }
    /**
     * Set Vehicule value
     * @param \StructType\Vehicule $vehicule
     * @return \StructType\TypeFUD
     */
    public function setVehicule(\StructType\Vehicule $vehicule = null)
    {
        $this->Vehicule = $vehicule;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\TypeFUD
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get PaiementCBClient value
     * @return bool|null
     */
    public function getPaiementCBClient()
    {
        return $this->PaiementCBClient;
    }
    /**
     * Set PaiementCBClient value
     * @param bool $paiementCBClient
     * @return \StructType\TypeFUD
     */
    public function setPaiementCBClient($paiementCBClient = null)
    {
        // validation for constraint: boolean
        if (!is_null($paiementCBClient) && !is_bool($paiementCBClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paiementCBClient, true), gettype($paiementCBClient)), __LINE__);
        }
        $this->PaiementCBClient = $paiementCBClient;
        return $this;
    }
    /**
     * Get EmissionBO value
     * @return bool|null
     */
    public function getEmissionBO()
    {
        return $this->EmissionBO;
    }
    /**
     * Set EmissionBO value
     * @param bool $emissionBO
     * @return \StructType\TypeFUD
     */
    public function setEmissionBO($emissionBO = null)
    {
        // validation for constraint: boolean
        if (!is_null($emissionBO) && !is_bool($emissionBO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emissionBO, true), gettype($emissionBO)), __LINE__);
        }
        $this->EmissionBO = $emissionBO;
        return $this;
    }
    /**
     * Get CertifReglement value
     * @return bool|null
     */
    public function getCertifReglement()
    {
        return $this->CertifReglement;
    }
    /**
     * Set CertifReglement value
     * @param bool $certifReglement
     * @return \StructType\TypeFUD
     */
    public function setCertifReglement($certifReglement = null)
    {
        // validation for constraint: boolean
        if (!is_null($certifReglement) && !is_bool($certifReglement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($certifReglement, true), gettype($certifReglement)), __LINE__);
        }
        $this->CertifReglement = $certifReglement;
        return $this;
    }
    /**
     * Get Reponse value
     * @return \StructType\Reponse|null
     */
    public function getReponse()
    {
        return $this->Reponse;
    }
    /**
     * Set Reponse value
     * @param \StructType\Reponse $reponse
     * @return \StructType\TypeFUD
     */
    public function setReponse(\StructType\Reponse $reponse = null)
    {
        $this->Reponse = $reponse;
        return $this;
    }
}
