<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Communautaire StructType
 * @subpackage Structs
 */
class Communautaire extends AbstractStructBase
{
    /**
     * The K_NumRecepCE
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $K_NumRecepCE;
    /**
     * The DateReception
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateReception;
    /**
     * The D21_CNIT
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $D21_CNIT;
    /**
     * The DerivVP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $DerivVP;
    /**
     * The BrideeDebridee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $BrideeDebridee;
    /**
     * The CertifieValiditeVariables
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $CertifieValiditeVariables;
    /**
     * The ExoPickUp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ExoPickUp;
    /**
     * Constructor method for Communautaire
     * @uses Communautaire::setK_NumRecepCE()
     * @uses Communautaire::setDateReception()
     * @uses Communautaire::setD21_CNIT()
     * @uses Communautaire::setDerivVP()
     * @uses Communautaire::setBrideeDebridee()
     * @uses Communautaire::setCertifieValiditeVariables()
     * @uses Communautaire::setExoPickUp()
     * @param string $k_NumRecepCE
     * @param string $dateReception
     * @param string $d21_CNIT
     * @param bool $derivVP
     * @param bool $brideeDebridee
     * @param bool $certifieValiditeVariables
     * @param bool $exoPickUp
     */
    public function __construct($k_NumRecepCE = null, $dateReception = null, $d21_CNIT = null, $derivVP = null, $brideeDebridee = null, $certifieValiditeVariables = null, $exoPickUp = null)
    {
        $this
            ->setK_NumRecepCE($k_NumRecepCE)
            ->setDateReception($dateReception)
            ->setD21_CNIT($d21_CNIT)
            ->setDerivVP($derivVP)
            ->setBrideeDebridee($brideeDebridee)
            ->setCertifieValiditeVariables($certifieValiditeVariables)
            ->setExoPickUp($exoPickUp);
    }
    /**
     * Get K_NumRecepCE value
     * @return string
     */
    public function getK_NumRecepCE()
    {
        return $this->K_NumRecepCE;
    }
    /**
     * Set K_NumRecepCE value
     * @param string $k_NumRecepCE
     * @return \StructType\Communautaire
     */
    public function setK_NumRecepCE($k_NumRecepCE = null)
    {
        // validation for constraint: string
        if (!is_null($k_NumRecepCE) && !is_string($k_NumRecepCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($k_NumRecepCE, true), gettype($k_NumRecepCE)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($k_NumRecepCE) && mb_strlen($k_NumRecepCE) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($k_NumRecepCE)), __LINE__);
        }
        $this->K_NumRecepCE = $k_NumRecepCE;
        return $this;
    }
    /**
     * Get DateReception value
     * @return string|null
     */
    public function getDateReception()
    {
        return $this->DateReception;
    }
    /**
     * Set DateReception value
     * @param string $dateReception
     * @return \StructType\Communautaire
     */
    public function setDateReception($dateReception = null)
    {
        // validation for constraint: string
        if (!is_null($dateReception) && !is_string($dateReception)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateReception, true), gettype($dateReception)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateReception) && mb_strlen($dateReception) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateReception)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateReception) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateReception)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateReception, true)), __LINE__);
        }
        $this->DateReception = $dateReception;
        return $this;
    }
    /**
     * Get D21_CNIT value
     * @return string|null
     */
    public function getD21_CNIT()
    {
        return $this->D21_CNIT;
    }
    /**
     * Set D21_CNIT value
     * @param string $d21_CNIT
     * @return \StructType\Communautaire
     */
    public function setD21_CNIT($d21_CNIT = null)
    {
        // validation for constraint: string
        if (!is_null($d21_CNIT) && !is_string($d21_CNIT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($d21_CNIT, true), gettype($d21_CNIT)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($d21_CNIT) && mb_strlen($d21_CNIT) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($d21_CNIT)), __LINE__);
        }
        $this->D21_CNIT = $d21_CNIT;
        return $this;
    }
    /**
     * Get DerivVP value
     * @return bool|null
     */
    public function getDerivVP()
    {
        return $this->DerivVP;
    }
    /**
     * Set DerivVP value
     * @param bool $derivVP
     * @return \StructType\Communautaire
     */
    public function setDerivVP($derivVP = null)
    {
        // validation for constraint: boolean
        if (!is_null($derivVP) && !is_bool($derivVP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($derivVP, true), gettype($derivVP)), __LINE__);
        }
        $this->DerivVP = $derivVP;
        return $this;
    }
    /**
     * Get BrideeDebridee value
     * @return bool|null
     */
    public function getBrideeDebridee()
    {
        return $this->BrideeDebridee;
    }
    /**
     * Set BrideeDebridee value
     * @param bool $brideeDebridee
     * @return \StructType\Communautaire
     */
    public function setBrideeDebridee($brideeDebridee = null)
    {
        // validation for constraint: boolean
        if (!is_null($brideeDebridee) && !is_bool($brideeDebridee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($brideeDebridee, true), gettype($brideeDebridee)), __LINE__);
        }
        $this->BrideeDebridee = $brideeDebridee;
        return $this;
    }
    /**
     * Get CertifieValiditeVariables value
     * @return bool|null
     */
    public function getCertifieValiditeVariables()
    {
        return $this->CertifieValiditeVariables;
    }
    /**
     * Set CertifieValiditeVariables value
     * @param bool $certifieValiditeVariables
     * @return \StructType\Communautaire
     */
    public function setCertifieValiditeVariables($certifieValiditeVariables = null)
    {
        // validation for constraint: boolean
        if (!is_null($certifieValiditeVariables) && !is_bool($certifieValiditeVariables)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($certifieValiditeVariables, true), gettype($certifieValiditeVariables)), __LINE__);
        }
        $this->CertifieValiditeVariables = $certifieValiditeVariables;
        return $this;
    }
    /**
     * Get ExoPickUp value
     * @return bool|null
     */
    public function getExoPickUp()
    {
        return $this->ExoPickUp;
    }
    /**
     * Set ExoPickUp value
     * @param bool $exoPickUp
     * @return \StructType\Communautaire
     */
    public function setExoPickUp($exoPickUp = null)
    {
        // validation for constraint: boolean
        if (!is_null($exoPickUp) && !is_bool($exoPickUp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exoPickUp, true), gettype($exoPickUp)), __LINE__);
        }
        $this->ExoPickUp = $exoPickUp;
        return $this;
    }
}
