<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TypeVM StructType
 * @subpackage Structs
 */
class TypeVM extends AbstractStructBase
{
    /**
     * The VIN
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - pattern: [0-9A-Z]*
     * @var string
     */
    public $VIN;
    /**
     * The Immatriculation
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 6
     * - minOccurs: 1
     * - pattern: ([A-Z]{1,2}(-|\s)?\d{2,3}(-|\s)?[A-Z]{1,2})|(\d{1,4}\s?[A-Z]{2,3}\s?(2[AB]|\d{1,3}))
     * @var string
     */
    public $Immatriculation;
    /**
     * The CIPresent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CIPresent;
    /**
     * The D1_Marque
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $D1_Marque;
    /**
     * The D2_Version
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $D2_Version;
    /**
     * The Communautaire
     * Meta information extracted from the WSDL
     * - choice: Communautaire | Nationale
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Communautaire
     */
    public $Communautaire;
    /**
     * The Nationale
     * Meta information extracted from the WSDL
     * - choice: Communautaire | Nationale
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\VehiculeCaracteristiquesNationale
     */
    public $Nationale;
    /**
     * The F1_MMaxTechAdm
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 5
     * @var int
     */
    public $F1_MMaxTechAdm;
    /**
     * The F2_MMaxAdmServ
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 5
     * @var int
     */
    public $F2_MMaxAdmServ;
    /**
     * The G_MMaxAvecAttelage
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 5
     * @var int
     */
    public $G_MMaxAvecAttelage;
    /**
     * The G1_PoidsVide
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 5
     * @var int
     */
    public $G1_PoidsVide;
    /**
     * The J1_Genre
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $J1_Genre;
    /**
     * The J3_Carrosserie
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $J3_Carrosserie;
    /**
     * The S1_NbPlaceAssise
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 3
     * @var int
     */
    public $S1_NbPlaceAssise;
    /**
     * The NumFormule
     * Meta information extracted from the WSDL
     * - choice: NumFormule | DateCI
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumFormule;
    /**
     * The DateCI
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: NumFormule | DateCI
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateCI;
    /**
     * The Couleur
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Couleur;
    /**
     * The BrideeDebridee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $BrideeDebridee;
    /**
     * The ExoPickUp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ExoPickUp;
    /**
     * The Z1_Mention1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Z1_Mention1;
    /**
     * The Z1_Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Z1_Value;
    /**
     * The NbMentions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $NbMentions;
    /**
     * The Mentions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Mentions
     */
    public $Mentions;
    /**
     * Constructor method for TypeVM
     * @uses TypeVM::setVIN()
     * @uses TypeVM::setImmatriculation()
     * @uses TypeVM::setCIPresent()
     * @uses TypeVM::setD1_Marque()
     * @uses TypeVM::setD2_Version()
     * @uses TypeVM::setCommunautaire()
     * @uses TypeVM::setNationale()
     * @uses TypeVM::setF1_MMaxTechAdm()
     * @uses TypeVM::setF2_MMaxAdmServ()
     * @uses TypeVM::setG_MMaxAvecAttelage()
     * @uses TypeVM::setG1_PoidsVide()
     * @uses TypeVM::setJ1_Genre()
     * @uses TypeVM::setJ3_Carrosserie()
     * @uses TypeVM::setS1_NbPlaceAssise()
     * @uses TypeVM::setNumFormule()
     * @uses TypeVM::setDateCI()
     * @uses TypeVM::setCouleur()
     * @uses TypeVM::setBrideeDebridee()
     * @uses TypeVM::setExoPickUp()
     * @uses TypeVM::setZ1_Mention1()
     * @uses TypeVM::setZ1_Value()
     * @uses TypeVM::setNbMentions()
     * @uses TypeVM::setMentions()
     * @param string $vIN
     * @param string $immatriculation
     * @param bool $cIPresent
     * @param string $d1_Marque
     * @param string $d2_Version
     * @param \StructType\Communautaire $communautaire
     * @param \StructType\VehiculeCaracteristiquesNationale $nationale
     * @param int $f1_MMaxTechAdm
     * @param int $f2_MMaxAdmServ
     * @param int $g_MMaxAvecAttelage
     * @param int $g1_PoidsVide
     * @param string $j1_Genre
     * @param string $j3_Carrosserie
     * @param int $s1_NbPlaceAssise
     * @param string $numFormule
     * @param string $dateCI
     * @param string $couleur
     * @param bool $brideeDebridee
     * @param bool $exoPickUp
     * @param string $z1_Mention1
     * @param string $z1_Value
     * @param int $nbMentions
     * @param \StructType\Mentions $mentions
     */
    public function __construct($vIN = null, $immatriculation = null, $cIPresent = null, $d1_Marque = null, $d2_Version = null, \StructType\Communautaire $communautaire = null, \StructType\VehiculeCaracteristiquesNationale $nationale = null, $f1_MMaxTechAdm = null, $f2_MMaxAdmServ = null, $g_MMaxAvecAttelage = null, $g1_PoidsVide = null, $j1_Genre = null, $j3_Carrosserie = null, $s1_NbPlaceAssise = null, $numFormule = null, $dateCI = null, $couleur = null, $brideeDebridee = null, $exoPickUp = null, $z1_Mention1 = null, $z1_Value = null, $nbMentions = null, \StructType\Mentions $mentions = null)
    {
        $this
            ->setVIN($vIN)
            ->setImmatriculation($immatriculation)
            ->setCIPresent($cIPresent)
            ->setD1_Marque($d1_Marque)
            ->setD2_Version($d2_Version)
            ->setCommunautaire($communautaire)
            ->setNationale($nationale)
            ->setF1_MMaxTechAdm($f1_MMaxTechAdm)
            ->setF2_MMaxAdmServ($f2_MMaxAdmServ)
            ->setG_MMaxAvecAttelage($g_MMaxAvecAttelage)
            ->setG1_PoidsVide($g1_PoidsVide)
            ->setJ1_Genre($j1_Genre)
            ->setJ3_Carrosserie($j3_Carrosserie)
            ->setS1_NbPlaceAssise($s1_NbPlaceAssise)
            ->setNumFormule($numFormule)
            ->setDateCI($dateCI)
            ->setCouleur($couleur)
            ->setBrideeDebridee($brideeDebridee)
            ->setExoPickUp($exoPickUp)
            ->setZ1_Mention1($z1_Mention1)
            ->setZ1_Value($z1_Value)
            ->setNbMentions($nbMentions)
            ->setMentions($mentions);
    }
    /**
     * Get VIN value
     * @return string
     */
    public function getVIN()
    {
        return $this->VIN;
    }
    /**
     * Set VIN value
     * @param string $vIN
     * @return \StructType\TypeVM
     */
    public function setVIN($vIN = null)
    {
        // validation for constraint: string
        if (!is_null($vIN) && !is_string($vIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vIN, true), gettype($vIN)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($vIN) && mb_strlen($vIN) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($vIN)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($vIN) && mb_strlen($vIN) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($vIN)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]*)
        if (!is_null($vIN) && !preg_match('/[0-9A-Z]*/', $vIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]*', var_export($vIN, true)), __LINE__);
        }
        $this->VIN = $vIN;
        return $this;
    }
    /**
     * Get Immatriculation value
     * @return string
     */
    public function getImmatriculation()
    {
        return $this->Immatriculation;
    }
    /**
     * Set Immatriculation value
     * @param string $immatriculation
     * @return \StructType\TypeVM
     */
    public function setImmatriculation($immatriculation = null)
    {
        // validation for constraint: string
        if (!is_null($immatriculation) && !is_string($immatriculation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($immatriculation, true), gettype($immatriculation)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($immatriculation) && mb_strlen($immatriculation) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($immatriculation)), __LINE__);
        }
        // validation for constraint: minLength(6)
        if (!is_null($immatriculation) && mb_strlen($immatriculation) < 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 6', mb_strlen($immatriculation)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{1,2}(-|\s)?\d{2,3}(-|\s)?[A-Z]{1,2})|(\d{1,4}\s?[A-Z]{2,3}\s?(2[AB]|\d{1,3})))
        if (!is_null($immatriculation) && !preg_match('/([A-Z]{1,2}(-|\\s)?\\d{2,3}(-|\\s)?[A-Z]{1,2})|(\\d{1,4}\\s?[A-Z]{2,3}\\s?(2[AB]|\\d{1,3}))/', $immatriculation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{1,2}(-|\s)?\d{2,3}(-|\s)?[A-Z]{1,2})|(\d{1,4}\s?[A-Z]{2,3}\s?(2[AB]|\d{1,3}))', var_export($immatriculation, true)), __LINE__);
        }
        $this->Immatriculation = $immatriculation;
        return $this;
    }
    /**
     * Get CIPresent value
     * @return bool
     */
    public function getCIPresent()
    {
        return $this->CIPresent;
    }
    /**
     * Set CIPresent value
     * @param bool $cIPresent
     * @return \StructType\TypeVM
     */
    public function setCIPresent($cIPresent = null)
    {
        // validation for constraint: boolean
        if (!is_null($cIPresent) && !is_bool($cIPresent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cIPresent, true), gettype($cIPresent)), __LINE__);
        }
        $this->CIPresent = $cIPresent;
        return $this;
    }
    /**
     * Get D1_Marque value
     * @return string
     */
    public function getD1_Marque()
    {
        return $this->D1_Marque;
    }
    /**
     * Set D1_Marque value
     * @param string $d1_Marque
     * @return \StructType\TypeVM
     */
    public function setD1_Marque($d1_Marque = null)
    {
        // validation for constraint: string
        if (!is_null($d1_Marque) && !is_string($d1_Marque)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($d1_Marque, true), gettype($d1_Marque)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($d1_Marque) && mb_strlen($d1_Marque) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($d1_Marque)), __LINE__);
        }
        $this->D1_Marque = $d1_Marque;
        return $this;
    }
    /**
     * Get D2_Version value
     * @return string
     */
    public function getD2_Version()
    {
        return $this->D2_Version;
    }
    /**
     * Set D2_Version value
     * @param string $d2_Version
     * @return \StructType\TypeVM
     */
    public function setD2_Version($d2_Version = null)
    {
        // validation for constraint: string
        if (!is_null($d2_Version) && !is_string($d2_Version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($d2_Version, true), gettype($d2_Version)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($d2_Version) && mb_strlen($d2_Version) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($d2_Version)), __LINE__);
        }
        $this->D2_Version = $d2_Version;
        return $this;
    }
    /**
     * Get Communautaire value
     * @return \StructType\Communautaire
     */
    public function getCommunautaire()
    {
        return isset($this->Communautaire) ? $this->Communautaire : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCommunautaire method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommunautaire method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCommunautaireForChoiceConstraintsFromSetCommunautaire($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Nationale',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Communautaire can\'t be set as the property %s is already set. Only one property must be set among these properties: Communautaire, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Communautaire value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Communautaire $communautaire
     * @return \StructType\TypeVM
     */
    public function setCommunautaire(\StructType\Communautaire $communautaire = null)
    {
        // validation for constraint: choice(Communautaire, Nationale)
        if ('' !== ($communautaireChoiceErrorMessage = self::validateCommunautaireForChoiceConstraintsFromSetCommunautaire($communautaire))) {
            throw new \InvalidArgumentException($communautaireChoiceErrorMessage, __LINE__);
        }
        if (is_null($communautaire) || (is_array($communautaire) && empty($communautaire))) {
            unset($this->Communautaire);
        } else {
            $this->Communautaire = $communautaire;
        }
        return $this;
    }
    /**
     * Get Nationale value
     * @return \StructType\VehiculeCaracteristiquesNationale
     */
    public function getNationale()
    {
        return isset($this->Nationale) ? $this->Nationale : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNationale method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNationale method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNationaleForChoiceConstraintsFromSetNationale($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Communautaire',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Nationale can\'t be set as the property %s is already set. Only one property must be set among these properties: Nationale, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Nationale value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VehiculeCaracteristiquesNationale $nationale
     * @return \StructType\TypeVM
     */
    public function setNationale(\StructType\VehiculeCaracteristiquesNationale $nationale = null)
    {
        // validation for constraint: choice(Communautaire, Nationale)
        if ('' !== ($nationaleChoiceErrorMessage = self::validateNationaleForChoiceConstraintsFromSetNationale($nationale))) {
            throw new \InvalidArgumentException($nationaleChoiceErrorMessage, __LINE__);
        }
        if (is_null($nationale) || (is_array($nationale) && empty($nationale))) {
            unset($this->Nationale);
        } else {
            $this->Nationale = $nationale;
        }
        return $this;
    }
    /**
     * Get F1_MMaxTechAdm value
     * @return int
     */
    public function getF1_MMaxTechAdm()
    {
        return $this->F1_MMaxTechAdm;
    }
    /**
     * Set F1_MMaxTechAdm value
     * @param int $f1_MMaxTechAdm
     * @return \StructType\TypeVM
     */
    public function setF1_MMaxTechAdm($f1_MMaxTechAdm = null)
    {
        // validation for constraint: int
        if (!is_null($f1_MMaxTechAdm) && !(is_int($f1_MMaxTechAdm) || ctype_digit($f1_MMaxTechAdm))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($f1_MMaxTechAdm, true), gettype($f1_MMaxTechAdm)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($f1_MMaxTechAdm) && mb_strlen(preg_replace('/(\D)/', '', $f1_MMaxTechAdm)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($f1_MMaxTechAdm, true), mb_strlen(preg_replace('/(\D)/', '', $f1_MMaxTechAdm))), __LINE__);
        }
        $this->F1_MMaxTechAdm = $f1_MMaxTechAdm;
        return $this;
    }
    /**
     * Get F2_MMaxAdmServ value
     * @return int
     */
    public function getF2_MMaxAdmServ()
    {
        return $this->F2_MMaxAdmServ;
    }
    /**
     * Set F2_MMaxAdmServ value
     * @param int $f2_MMaxAdmServ
     * @return \StructType\TypeVM
     */
    public function setF2_MMaxAdmServ($f2_MMaxAdmServ = null)
    {
        // validation for constraint: int
        if (!is_null($f2_MMaxAdmServ) && !(is_int($f2_MMaxAdmServ) || ctype_digit($f2_MMaxAdmServ))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($f2_MMaxAdmServ, true), gettype($f2_MMaxAdmServ)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($f2_MMaxAdmServ) && mb_strlen(preg_replace('/(\D)/', '', $f2_MMaxAdmServ)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($f2_MMaxAdmServ, true), mb_strlen(preg_replace('/(\D)/', '', $f2_MMaxAdmServ))), __LINE__);
        }
        $this->F2_MMaxAdmServ = $f2_MMaxAdmServ;
        return $this;
    }
    /**
     * Get G_MMaxAvecAttelage value
     * @return int
     */
    public function getG_MMaxAvecAttelage()
    {
        return $this->G_MMaxAvecAttelage;
    }
    /**
     * Set G_MMaxAvecAttelage value
     * @param int $g_MMaxAvecAttelage
     * @return \StructType\TypeVM
     */
    public function setG_MMaxAvecAttelage($g_MMaxAvecAttelage = null)
    {
        // validation for constraint: int
        if (!is_null($g_MMaxAvecAttelage) && !(is_int($g_MMaxAvecAttelage) || ctype_digit($g_MMaxAvecAttelage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($g_MMaxAvecAttelage, true), gettype($g_MMaxAvecAttelage)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($g_MMaxAvecAttelage) && mb_strlen(preg_replace('/(\D)/', '', $g_MMaxAvecAttelage)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($g_MMaxAvecAttelage, true), mb_strlen(preg_replace('/(\D)/', '', $g_MMaxAvecAttelage))), __LINE__);
        }
        $this->G_MMaxAvecAttelage = $g_MMaxAvecAttelage;
        return $this;
    }
    /**
     * Get G1_PoidsVide value
     * @return int
     */
    public function getG1_PoidsVide()
    {
        return $this->G1_PoidsVide;
    }
    /**
     * Set G1_PoidsVide value
     * @param int $g1_PoidsVide
     * @return \StructType\TypeVM
     */
    public function setG1_PoidsVide($g1_PoidsVide = null)
    {
        // validation for constraint: int
        if (!is_null($g1_PoidsVide) && !(is_int($g1_PoidsVide) || ctype_digit($g1_PoidsVide))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($g1_PoidsVide, true), gettype($g1_PoidsVide)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($g1_PoidsVide) && mb_strlen(preg_replace('/(\D)/', '', $g1_PoidsVide)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($g1_PoidsVide, true), mb_strlen(preg_replace('/(\D)/', '', $g1_PoidsVide))), __LINE__);
        }
        $this->G1_PoidsVide = $g1_PoidsVide;
        return $this;
    }
    /**
     * Get J1_Genre value
     * @return string
     */
    public function getJ1_Genre()
    {
        return $this->J1_Genre;
    }
    /**
     * Set J1_Genre value
     * @param string $j1_Genre
     * @return \StructType\TypeVM
     */
    public function setJ1_Genre($j1_Genre = null)
    {
        // validation for constraint: string
        if (!is_null($j1_Genre) && !is_string($j1_Genre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($j1_Genre, true), gettype($j1_Genre)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($j1_Genre) && mb_strlen($j1_Genre) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($j1_Genre)), __LINE__);
        }
        $this->J1_Genre = $j1_Genre;
        return $this;
    }
    /**
     * Get J3_Carrosserie value
     * @return string
     */
    public function getJ3_Carrosserie()
    {
        return $this->J3_Carrosserie;
    }
    /**
     * Set J3_Carrosserie value
     * @param string $j3_Carrosserie
     * @return \StructType\TypeVM
     */
    public function setJ3_Carrosserie($j3_Carrosserie = null)
    {
        // validation for constraint: string
        if (!is_null($j3_Carrosserie) && !is_string($j3_Carrosserie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($j3_Carrosserie, true), gettype($j3_Carrosserie)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($j3_Carrosserie) && mb_strlen($j3_Carrosserie) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($j3_Carrosserie)), __LINE__);
        }
        $this->J3_Carrosserie = $j3_Carrosserie;
        return $this;
    }
    /**
     * Get S1_NbPlaceAssise value
     * @return int
     */
    public function getS1_NbPlaceAssise()
    {
        return $this->S1_NbPlaceAssise;
    }
    /**
     * Set S1_NbPlaceAssise value
     * @param int $s1_NbPlaceAssise
     * @return \StructType\TypeVM
     */
    public function setS1_NbPlaceAssise($s1_NbPlaceAssise = null)
    {
        // validation for constraint: int
        if (!is_null($s1_NbPlaceAssise) && !(is_int($s1_NbPlaceAssise) || ctype_digit($s1_NbPlaceAssise))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($s1_NbPlaceAssise, true), gettype($s1_NbPlaceAssise)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($s1_NbPlaceAssise) && mb_strlen(preg_replace('/(\D)/', '', $s1_NbPlaceAssise)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($s1_NbPlaceAssise, true), mb_strlen(preg_replace('/(\D)/', '', $s1_NbPlaceAssise))), __LINE__);
        }
        $this->S1_NbPlaceAssise = $s1_NbPlaceAssise;
        return $this;
    }
    /**
     * Get NumFormule value
     * @return string|null
     */
    public function getNumFormule()
    {
        return isset($this->NumFormule) ? $this->NumFormule : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNumFormule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNumFormule method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNumFormuleForChoiceConstraintsFromSetNumFormule($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DateCI',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property NumFormule can\'t be set as the property %s is already set. Only one property must be set among these properties: NumFormule, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set NumFormule value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $numFormule
     * @return \StructType\TypeVM
     */
    public function setNumFormule($numFormule = null)
    {
        // validation for constraint: string
        if (!is_null($numFormule) && !is_string($numFormule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numFormule, true), gettype($numFormule)), __LINE__);
        }
        // validation for constraint: choice(NumFormule, DateCI)
        if ('' !== ($numFormuleChoiceErrorMessage = self::validateNumFormuleForChoiceConstraintsFromSetNumFormule($numFormule))) {
            throw new \InvalidArgumentException($numFormuleChoiceErrorMessage, __LINE__);
        }
        if (is_null($numFormule) || (is_array($numFormule) && empty($numFormule))) {
            unset($this->NumFormule);
        } else {
            $this->NumFormule = $numFormule;
        }
        return $this;
    }
    /**
     * Get DateCI value
     * @return string|null
     */
    public function getDateCI()
    {
        return isset($this->DateCI) ? $this->DateCI : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDateCI method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDateCI method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDateCIForChoiceConstraintsFromSetDateCI($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'NumFormule',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DateCI can\'t be set as the property %s is already set. Only one property must be set among these properties: DateCI, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DateCI value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $dateCI
     * @return \StructType\TypeVM
     */
    public function setDateCI($dateCI = null)
    {
        // validation for constraint: string
        if (!is_null($dateCI) && !is_string($dateCI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateCI, true), gettype($dateCI)), __LINE__);
        }
        // validation for constraint: choice(NumFormule, DateCI)
        if ('' !== ($dateCIChoiceErrorMessage = self::validateDateCIForChoiceConstraintsFromSetDateCI($dateCI))) {
            throw new \InvalidArgumentException($dateCIChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateCI) && mb_strlen($dateCI) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateCI)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateCI) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateCI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateCI, true)), __LINE__);
        }
        if (is_null($dateCI) || (is_array($dateCI) && empty($dateCI))) {
            unset($this->DateCI);
        } else {
            $this->DateCI = $dateCI;
        }
        return $this;
    }
    /**
     * Get Couleur value
     * @return string|null
     */
    public function getCouleur()
    {
        return $this->Couleur;
    }
    /**
     * Set Couleur value
     * @param string $couleur
     * @return \StructType\TypeVM
     */
    public function setCouleur($couleur = null)
    {
        // validation for constraint: string
        if (!is_null($couleur) && !is_string($couleur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couleur, true), gettype($couleur)), __LINE__);
        }
        $this->Couleur = $couleur;
        return $this;
    }
    /**
     * Get BrideeDebridee value
     * @return bool|null
     */
    public function getBrideeDebridee()
    {
        return $this->BrideeDebridee;
    }
    /**
     * Set BrideeDebridee value
     * @param bool $brideeDebridee
     * @return \StructType\TypeVM
     */
    public function setBrideeDebridee($brideeDebridee = null)
    {
        // validation for constraint: boolean
        if (!is_null($brideeDebridee) && !is_bool($brideeDebridee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($brideeDebridee, true), gettype($brideeDebridee)), __LINE__);
        }
        $this->BrideeDebridee = $brideeDebridee;
        return $this;
    }
    /**
     * Get ExoPickUp value
     * @return bool|null
     */
    public function getExoPickUp()
    {
        return $this->ExoPickUp;
    }
    /**
     * Set ExoPickUp value
     * @param bool $exoPickUp
     * @return \StructType\TypeVM
     */
    public function setExoPickUp($exoPickUp = null)
    {
        // validation for constraint: boolean
        if (!is_null($exoPickUp) && !is_bool($exoPickUp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exoPickUp, true), gettype($exoPickUp)), __LINE__);
        }
        $this->ExoPickUp = $exoPickUp;
        return $this;
    }
    /**
     * Get Z1_Mention1 value
     * @return string|null
     */
    public function getZ1_Mention1()
    {
        return $this->Z1_Mention1;
    }
    /**
     * Set Z1_Mention1 value
     * @uses \EnumType\Z1_Mention1::valueIsValid()
     * @uses \EnumType\Z1_Mention1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $z1_Mention1
     * @return \StructType\TypeVM
     */
    public function setZ1_Mention1($z1_Mention1 = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Z1_Mention1::valueIsValid($z1_Mention1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Z1_Mention1', is_array($z1_Mention1) ? implode(', ', $z1_Mention1) : var_export($z1_Mention1, true), implode(', ', \EnumType\Z1_Mention1::getValidValues())), __LINE__);
        }
        $this->Z1_Mention1 = $z1_Mention1;
        return $this;
    }
    /**
     * Get Z1_Value value
     * @return string|null
     */
    public function getZ1_Value()
    {
        return $this->Z1_Value;
    }
    /**
     * Set Z1_Value value
     * @param string $z1_Value
     * @return \StructType\TypeVM
     */
    public function setZ1_Value($z1_Value = null)
    {
        // validation for constraint: string
        if (!is_null($z1_Value) && !is_string($z1_Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($z1_Value, true), gettype($z1_Value)), __LINE__);
        }
        $this->Z1_Value = $z1_Value;
        return $this;
    }
    /**
     * Get NbMentions value
     * @return int|null
     */
    public function getNbMentions()
    {
        return $this->NbMentions;
    }
    /**
     * Set NbMentions value
     * @param int $nbMentions
     * @return \StructType\TypeVM
     */
    public function setNbMentions($nbMentions = null)
    {
        // validation for constraint: int
        if (!is_null($nbMentions) && !(is_int($nbMentions) || ctype_digit($nbMentions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbMentions, true), gettype($nbMentions)), __LINE__);
        }
        $this->NbMentions = $nbMentions;
        return $this;
    }
    /**
     * Get Mentions value
     * @return \StructType\Mentions|null
     */
    public function getMentions()
    {
        return $this->Mentions;
    }
    /**
     * Set Mentions value
     * @param \StructType\Mentions $mentions
     * @return \StructType\TypeVM
     */
    public function setMentions(\StructType\Mentions $mentions = null)
    {
        $this->Mentions = $mentions;
        return $this;
    }
}
