<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TypeIdentification StructType
 * @subpackage Structs
 */
class TypeIdentification extends AbstractStructBase
{
    /**
     * The CodeTMS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CodeTMS;
    /**
     * The Login
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Login;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - choice: Password | ApiKey
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Password;
    /**
     * The ApiKey
     * Meta information extracted from the WSDL
     * - choice: Password | ApiKey
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ApiKey;
    /**
     * The Succursale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Succursale;
    /**
     * Constructor method for TypeIdentification
     * @uses TypeIdentification::setCodeTMS()
     * @uses TypeIdentification::setLogin()
     * @uses TypeIdentification::setPassword()
     * @uses TypeIdentification::setApiKey()
     * @uses TypeIdentification::setSuccursale()
     * @param string $codeTMS
     * @param string $login
     * @param string $password
     * @param string $apiKey
     * @param string $succursale
     */
    public function __construct($codeTMS = null, $login = null, $password = null, $apiKey = null, $succursale = null)
    {
        $this
            ->setCodeTMS($codeTMS)
            ->setLogin($login)
            ->setPassword($password)
            ->setApiKey($apiKey)
            ->setSuccursale($succursale);
    }
    /**
     * Get CodeTMS value
     * @return string
     */
    public function getCodeTMS()
    {
        return $this->CodeTMS;
    }
    /**
     * Set CodeTMS value
     * @param string $codeTMS
     * @return \StructType\TypeIdentification
     */
    public function setCodeTMS($codeTMS = null)
    {
        // validation for constraint: string
        if (!is_null($codeTMS) && !is_string($codeTMS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeTMS, true), gettype($codeTMS)), __LINE__);
        }
        $this->CodeTMS = $codeTMS;
        return $this;
    }
    /**
     * Get Login value
     * @return string
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param string $login
     * @return \StructType\TypeIdentification
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        $this->Login = $login;
        return $this;
    }
    /**
     * Get Password value
     * @return string
     */
    public function getPassword()
    {
        return isset($this->Password) ? $this->Password : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPassword method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPassword method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePasswordForChoiceConstraintsFromSetPassword($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ApiKey',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Password can\'t be set as the property %s is already set. Only one property must be set among these properties: Password, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Password value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $password
     * @return \StructType\TypeIdentification
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        // validation for constraint: choice(Password, ApiKey)
        if ('' !== ($passwordChoiceErrorMessage = self::validatePasswordForChoiceConstraintsFromSetPassword($password))) {
            throw new \InvalidArgumentException($passwordChoiceErrorMessage, __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->Password);
        } else {
            $this->Password = $password;
        }
        return $this;
    }
    /**
     * Get ApiKey value
     * @return string
     */
    public function getApiKey()
    {
        return isset($this->ApiKey) ? $this->ApiKey : null;
    }
    /**
     * This method is responsible for validating the value passed to the setApiKey method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApiKey method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateApiKeyForChoiceConstraintsFromSetApiKey($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Password',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ApiKey can\'t be set as the property %s is already set. Only one property must be set among these properties: ApiKey, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ApiKey value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $apiKey
     * @return \StructType\TypeIdentification
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiKey, true), gettype($apiKey)), __LINE__);
        }
        // validation for constraint: choice(Password, ApiKey)
        if ('' !== ($apiKeyChoiceErrorMessage = self::validateApiKeyForChoiceConstraintsFromSetApiKey($apiKey))) {
            throw new \InvalidArgumentException($apiKeyChoiceErrorMessage, __LINE__);
        }
        if (is_null($apiKey) || (is_array($apiKey) && empty($apiKey))) {
            unset($this->ApiKey);
        } else {
            $this->ApiKey = $apiKey;
        }
        return $this;
    }
    /**
     * Get Succursale value
     * @return string|null
     */
    public function getSuccursale()
    {
        return $this->Succursale;
    }
    /**
     * Set Succursale value
     * @param string $succursale
     * @return \StructType\TypeIdentification
     */
    public function setSuccursale($succursale = null)
    {
        // validation for constraint: string
        if (!is_null($succursale) && !is_string($succursale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($succursale, true), gettype($succursale)), __LINE__);
        }
        $this->Succursale = $succursale;
        return $this;
    }
}
